# IHE ITI Patient Identifier Cross-referencing for mobile (PIXm) - Consumer (client) - Patient Identifier Cross-referencing for mobile (PIXm) v3.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **IHE ITI Patient Identifier Cross-referencing for mobile (PIXm) - Consumer (client)**

## CapabilityStatement: IHE ITI Patient Identifier Cross-referencing for mobile (PIXm) - Consumer (client) 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/ITI/PIXm/CapabilityStatement/IHE.PIXm.Consumer | *Version*:3.1.0 |
| Active as of 2025-05-30 | *Computable Name*:IHE_PIXm_Consumer |

 
The [Patient Identifier Cross-reference Consumer Actor](volume-1.md#141112-patient-identifier-cross-reference-consumer) CapabililtyStatement expresses the requirements that can be utilized while being compliant. 
* using FHIR R4
* using json or xml encoding
* [ITI-83](ITI-83.md) the $ihe-pix operation
* should use a security framework. Recommend [ATNA](https://profiles.ihe.net/ITI/TF/Volume1/ch-9.html), encouraged [IHE-IUA](https://profiles.ihe.net/ITI/IUA/index.html) or [SMART-app-launch](http://www.hl7.org/fhir/smart-app-launch/)
 

 [Raw OpenAPI-Swagger Definition file](IHE.PIXm.Consumer.openapi.json) | [Download](IHE.PIXm.Consumer.openapi.json) 



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "IHE.PIXm.Consumer",
  "url" : "https://profiles.ihe.net/ITI/PIXm/CapabilityStatement/IHE.PIXm.Consumer",
  "version" : "3.1.0",
  "name" : "IHE_PIXm_Consumer",
  "title" : "IHE ITI Patient Identifier Cross-referencing for mobile (PIXm) - Consumer (client)",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-05-30T13:12:36-06:00",
  "publisher" : "IHE IT Infrastructure Technical Committee",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ihe.net/ihe_domains/it_infrastructure/"
        }
      ]
    },
    {
      "telecom" : [
        {
          "system" : "email",
          "value" : "iti@ihe.net"
        }
      ]
    },
    {
      "name" : "IHE IT Infrastructure Technical Committee",
      "telecom" : [
        {
          "system" : "email",
          "value" : "iti@ihe.net"
        }
      ]
    }
  ],
  "description" : "The [Patient Identifier Cross-reference Consumer Actor](volume-1.html#141112-patient-identifier-cross-reference-consumer) CapabililtyStatement expresses the requirements that can be utilized while being compliant.\n\n- using FHIR R4\n- using json or xml encoding\n- [ITI-83](ITI-83.html) the $ihe-pix operation\n- should use a security framework. Recommend [ATNA](https://profiles.ihe.net/ITI/TF/Volume1/ch-9.html), encouraged [IHE-IUA](https://profiles.ihe.net/ITI/IUA/index.html) or [SMART-app-launch](http://www.hl7.org/fhir/smart-app-launch/)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "kind" : "requirements",
  "fhirVersion" : "4.0.1",
  "format" : ["application/fhir+xml", "application/fhir+json"],
  "rest" : [
    {
      "mode" : "client",
      "documentation" : "PIXm client queries for Patient Identity Cross-reference matching a query parameters",
      "security" : {
        "description" : "Recommend [ATNA](https://profiles.ihe.net/ITI/TF/Volume1/ch-9.html), encouraged [IHE-IUA](https://profiles.ihe.net/ITI/IUA/index.html) or [SMART-app-launch](http://www.hl7.org/fhir/smart-app-launch/)"
      },
      "resource" : [
        {
          "type" : "Patient",
          "operation" : [
            {
              "name" : "$ihe-pix",
              "definition" : "https://profiles.ihe.net/ITI/PIXm/OperationDefinition/IHE.PIXm.pix"
            }
          ]
        }
      ]
    }
  ]
}

```
