# 2:3:104 Patient Identity Feed FHIR [ITI-104] - Patient Identifier Cross-referencing for mobile (PIXm) v3.0.5-current

* [**Table of Contents**](toc.md)
* **2:3:104 Patient Identity Feed FHIR [ITI-104]**

## 2:3:104 Patient Identity Feed FHIR [ITI-104]

This section corresponds to transaction [ITI-104] of the IHE Technical Framework. Transaction [ITI-104] is used by the Patient Identity Source and Patient Identifier Cross-reference Manager.

### 2:3.104.1 Scope

This transaction communicates patient information, including corroborating demographic data, after a patient’s identity is established, modified or merged or after the key corroborating demographic data has been modified. In addition the removal of a patient identity in the source patient identifier domain may be communicated.

### 2:3.104.2 Actor Roles

The roles in this transaction are defined in the following table and may be played by the actors shown here:

**Table 2:3.104.2-1: Actor Roles**

| | |
| :--- | :--- |
| Patient Identity Source | Provides notification to the Patient Identifier Cross-reference Manager for any patient identification related events including: creation, updates, merges, etc. |
| Patient Identifier Cross-reference Manager | Serves a well-defined set of Patient Identification Domains. Based on information provided in each Patient Identification Domain by a Patient Identity Source Actor, it manages the cross-referencing of patient identifiers across Patient Identification Domains. |

### 2:3.104.3 Referenced Standards

**FHIR-R4** [HL7 FHIR Release 4.0](http://www.hl7.org/FHIR/R4)

[HL7 Cross Paradigm Implementation Guide: Gender Harmony - Sex and Gender Representation, Edition 1](https://hl7.org/xprod/ig/uv/gender-harmony/)

### 2:3.104.4 Messages

**Figure 2:3.104.4-1: Interaction Diagram**

A Patient Identity Source notifies the Patient Identifier Cross-reference Manager that a patient has been [added or revised](#2310441-add-or-revise-patient) in the Patient Identity Source. The Patient Identity Source notifies the Patient Identifier Cross-reference Manager that [duplicate records](#2310442-resolve-duplicate-patient) were resolved in the Patient Identity Source. If the [Remove Patient Option](volume-1.md#14121-remove-patient) is supported the Patient Identity Source notifies the Patient Identifier Cross-reference Manager that [a patient record was removed](#2310443-remove-patient) in the Patient Identity Source.

#### 2:3.104.4.1 Add or Revise Patient

This message is implemented as an HTTP conditional update operation from the Patient Identity Source to the Patient Identifier Cross-reference Manager described in Section 2:3.104.4.1.2 Message Semantics.

##### 2:3.104.4.1.1 Trigger Events

The Add Patient message is triggered when a new patient is added to a Patient Identity Source.

The Revise Patient message is triggered when the patient information is revised within a Patient Identity Source (e.g., change in patient name, patient address, etc.).

The Patient Identifier Cross-reference Manager shall only perform cross-referencing logic on messages received from Patient Identity Source Actors.

##### 2:3.104.4.1.2 Message Semantics

A Patient Identity Source initiates a FHIR request using Conditional Update as defined at [http://hl7.org/fhir/http.html#cond-update](http://hl7.org/fhir/http.html#cond-update) on a Patient Resource.

A Patient Identity Source shall be able to send a request for either the JSON or the XML format as defined in FHIR. A Patient Identifier Cross-reference Manager shall be able to support the JSON and the XML format and support the conditional PUT operation.

The Patient Identity Source shall provide the identifier of the Patient Identification Domain of the Patient Identity Source.

For example:

The identifier for a patient with identifier IHERED-994 assigned by authority “1.3.6.1.4.1.21367.13.20.1000” would be represented as:

```
identifier=urn:oid:1.3.6.1.4.1.21367.13.20.1000|IHERED-994

```

If a FHIR server in the source domain with base `http://fhir.mydomain.com` is the assigning authority, a patient on that server with a Logical id of “123” the identifier would be represented as:

```
identifier=http://fhir.mydomain.com|Patient/123

```

##### 2:3.104.4.1.2.1 Patient Resource constraints

The Patient Identifier Cross-reference Manager shall be capable of accepting elements specified in [profile PDQm Patient](https://profiles.ihe.net/ITI/PDQm/StructureDefinition/IHE.PDQm.Patient): `https://profiles.ihe.net/ITI/PDQm/StructureDefinition/IHE.PDQm.Patient`. This is to ensure that the Patient Identifier Cross-reference Manager can handle a sufficient set of corroborating information in order to perform its cross-referencing function.

If a Patient Identifier Cross-reference Manager constrains or specifies additional elements (e.g., extensions), it shall constrain the PIXm Patient profile [see example](StructureDefinition-IHE.PIXm.Patient.BirthDateRequired.md) and reference this as a [supportedProfile](http://hl7.org/fhir/capabilitystatement-definitions.html#CapabilityStatement.rest.resource.supportedProfile) in the CapabilityStatement.

##### 2:3.104.4.1.3 Expected Actions

The Patient Identifier Cross-reference Manager shall provide a CapabilityStatement with the [capabilities interaction](https://www.hl7.org/fhir/http.html#capabilities) and indicate that conditionalUpdate is available on the Patient.

A Patient Identifier Cross-reference Manager shall support the Conditional Update based on the identifier parameter as outlined in http://hl7.org/fhir/http.html#cond-update. The identifier parameters carries either the Logical id or the business identifier as outlined in [Message Semantics](#23104412-message-semantics). The identifier parameter needs to be used for the cross-referencing.

The Patient Identifier Cross-reference Manager is not required to maintain a Patient resource, only to cross-reference provided identifiers.

The Patient Identifier Cross-reference Manager shall only recognize a single Patient Identity Source per domain.

The cross-referencing process (algorithm, human decisions, etc.) is performed within the Patient Identifier Cross-reference Manager, but its specification is beyond the scope of IHE.

Once the Patient Identifier Cross-reference Manager has completed its cross-referencing function, it shall make the newly cross-referenced identifiers available to PIX queries.

##### 2:3.104.4.1.4 Response message

See [http://hl7.org/fhir/http.html#cond-update](http://hl7.org/fhir/http.html#cond-update) for response.

##### 2:3.104.4.1.5 Example

Add Patient [Alissa Mohr](Patient-Patient-MohrAlissa-Red.json.md):

```

PUT http://example.org/fhir/Patient?identifier=urn:oid:1.3.6.1.4.1.21367.13.20.1000|IHERED-994 HTTP/1.1
Accept: application/fhir+json
Content-Type: application/fhir+json

{
  "resourceType" : "Patient",
  "identifier" : [
    {
      "system" : "urn:oid:1.3.6.1.4.1.21367.13.20.1000",
      "value" : "IHERED-994"
    }
  ],
  "active" : true,
  "name" : [
    {
      "family" : "MOHR",
      "given" : [
        "ALISSA"
      ]
    }
  ],
  "gender" : "female",
  "birthDate" : "1958-01-30"
}

```

Revise Patient [Alissa Mohr](Patient-Patient-MohrAlissa-Red.json.md) with updated demographics ([given name Alice instead of Alissa](Patient-Patient-MohrAlice-Red.json.md)):

```

PUT http://example.org/fhir/Patient?identifier=urn:oid:1.3.6.1.4.1.21367.13.20.1000|IHERED-994 HTTP/1.1
Accept: application/fhir+json
Content-Type: application/fhir+json

{
  "resourceType" : "Patient",
  "identifier" : [
    {
      "system" : "urn:oid:1.3.6.1.4.1.21367.13.20.1000",
      "value" : "IHERED-994"
    }
  ],
  "active" : true,
  "name" : [
    {
      "family" : "MOHR",
      "given" : [
        "ALICE"
      ]
    }
  ],
  "gender" : "female",
  "birthDate" : "1958-01-30"
}

```

#### 2:3.104.4.2 Resolve Duplicate Patient

The Patient Identity Source notifies the Patient Identifier Cross-reference Manager that duplicate records were resolved in the Patient Identity Source.

This message is implemented as an HTTP conditional update operation from the Patient Identity Source to the Patient Identifier Cross-reference Manager described in Section 2:3.104.4.2.2 Message Semantics.

##### 2:3.104.4.2.1 Trigger Events

A Resolve Duplicate Patient message is triggered when the Patient Identity Source does a merge within its Patient Identification Domain.

##### 2:3.104.4.2.2 Message Semantics

A Patient Identity Source initiates a FHIR request using HTTP PUT as defined at [http://hl7.org/fhir/http.html#cond-update](http://hl7.org/fhir/http.html#cond-update) on the duplicate patient record based on the identifier parameter.

In the Patient resource a link of type 'replaced-by' shall be added with the identifier pointing to the surviving patient identifier, see https://www.hl7.org/fhir/patient.html#dup-records.

A Patient Identity Source shall be able to send a request for either the JSON or the XML format as defined in FHIR. A Patient Identifier Cross-reference Manager shall be able to support the JSON and the XML format and support the conditional PUT operation.

##### 2:3.104.4.2.3 Expected Actions

The Patient Identifier Cross-reference Manager shall provide a CapabilityStatement with the [capabilities interaction](https://www.hl7.org/fhir/http.html#capabilities) and indicate that conditionalUpdate is available on the Patient.

When the Patient Identifier Cross-reference Manager receives the Resolve Duplicate Patient message it shall replace any references it is maintaining internally to the subsumed patient identifier with the patient identifier in the ‘replaced-by’ link.

After the identifier references are replaced, the Patient Identifier Cross-reference Manager shall reapply its internal cross-referencing logic/ policies before providing the updated information via the PIX Query transactions.

##### 2:3.104.4.2.4 Response Message

See [http://hl7.org/fhir/http.html#cond-update](http://hl7.org/fhir/http.html#cond-update) for response.

##### 2:3.104.4.2.5 Example

Patient [Maiden Alice](Patient-Patient-MaidenAlice-Red.json.md) has been subsumed by Patient [Mohr Alice](Patient-Patient-MohrAlice-Red.json.md) in the Patient Identifier Domain urn:oid:1.3.6.1.4.1.21367.13.20.1000. The HTTP conditional update operation is done with the subsumed identifier 'IHERED-m94' from [Maiden Alice](Patient-Patient-MaidenAlice-Red.json.md) in the request and referencing the surviving identifier 'IHERED-994' of [Patient Mohr Alice](Patient-Patient-MohrAlice-Red.json.md) in the message:

```

PUT http://example.org/fhir/Patient?identifier=urn:oid:1.3.6.1.4.1.21367.13.20.1000|IHERED-m94 HTTP/1.1
Accept: application/fhir+json
Content-Type: application/fhir+json

{
  "resourceType" : "Patient",
  "identifier" : [
    {
      "system" : "urn:oid:1.3.6.1.4.1.21367.13.20.1000",
      "value" : "IHERED-m94"
    }
  ],
  "active" : false,
  "name" : [
    {
      "family" : "MOHR",
      "given" : [
        "MAIDEN"
      ]
    }
  ],
  "gender" : "female",
  "birthDate" : "1958-01-30",
  "link" : [
    {
      "other" : {
        "identifier" : {
          "system" : "urn:oid:1.3.6.1.4.1.21367.13.20.1000",
          "value" : "IHERED-994"
        }
      },
      "type" : "replaced-by"
    }
  ]
}

```

#### 2:3.104.4.3 Remove Patient

This message enables the removal of patient identity data if the [Remove Patient Option](volume-1.md#14121-remove-patient) is supported.

This message is implemented as an HTTP conditional delete operation from the Patient Identity Source to the Patient Identifier Cross-reference Manager described in Section 2:3.104.4.3.2 Message Semantics.

##### 2:3.104.4.3.1 Trigger Events

A Removed Patient message is triggered when the Patient Identity Source has removed a patient within its Patient Identification Domain.

##### 2:3.104.4.3.2 Message Semantics

A Patient Identity Source initiates a FHIR request using HTTP DELETE as defined at [3.1.0.7.1 Conditional delete](https://www.hl7.org/fhir/http.html#3.1.0.7.1) on a Patient Resource based on the identifier parameter.

A Patient Identity Source shall be able to send a request for either the JSON or the XML format as defined in FHIR. A Patient Identifier Cross-reference Manager shall be able to support the JSON and the XML format and support the conditional DELETE operation if it supports the Remove Patient message.

##### 2:3.104.4.3.3 Expected Actions

The Patient Identifier Cross-reference Manager indicates in the [CapabilityStatement](http://hl7.org/fhir/capabilitystatement-definitions.html#CapabilityStatement.rest.resource.conditionalDelete) that conditionalDelete is available on the Patient if this message is supported.

When the Patient Identifier Cross-reference Manager receives the Remove Patient message, it shall remove any references it is maintaining internally to the patient identifier provided.

After processing the Remove Patient message, the Patient Identifier Cross-reference Manager shall not return the removed identifier in response to PIX Query transactions.

##### 2:3.104.4.3.4 Response Message

See [3.1.0.7.1 Conditional delete](https://www.hl7.org/fhir/http.html#3.1.0.7.1) for the response.

##### 2:3.104.4.3.5 Example

Remove Patient [Maiden Alice](Patient-Patient-MaidenAlice-Red.json.md):

```

DELETE http://example.org/fhir/Patient?identifier=urn:oid:1.3.6.1.4.1.21367.13.20.1000|IHERED-994 HTTP/1.1
Accept: application/fhir+json

```

### 2:3.104.5 Security Considerations

See [ITI TF-2: Appendix Z.8 “Mobile Security Considerations”](https://profiles.ihe.net/ITI/TF/Volume2/ch-Z.html#z.8-mobile-security-considerations), which includes guidance on the use of [ATNA](https://profiles.ihe.net/ITI/TF/Volume1/ch-9.html) and [IUA](https://profiles.ihe.net/ITI/TF/Volume1/ch-34.html) to protect the communication, access control, and audit logging.

The Patient Identifier Cross-reference Manager should check that the Patient Identity Source is only making changes to Patient Identifier Domain for which it is authorized.

#### 2:3.104.5.1 Security Audit Considerations

The Security audit logging will conform to the RESTful interactions following [IHE-BALP Basic Audit Logging Patterns](https://profiles.ihe.net/ITI/BALP/index.html).

##### 2:3.104.5.1.1 Patient Identity Source Audit

The Patient Identity Source when grouped with ATNA Secure Node or Secure Application actor shall be able to record AuditEvents. The Patient Identity Source will log a Delete or Update. The Patient Identity Source can't distinguish a Create from a Update.

* on an Update - [PIXm Feed Update Source Audit Event Log](StructureDefinition-IHE.PIXm.Feed.Update.Audit.Source.md). 
* [Audit Example for a PIXm Feed Update transaction from source perspective](AuditEvent-ex-auditPixmFeed-update-source.md).
 
* on a Delete - [PIXm Feed Delete Source Audit Event Log](StructureDefinition-IHE.PIXm.Feed.Delete.Audit.Source.md). 
* [Audit Example for a PIXm Feed Delete transaction from source perspective](AuditEvent-ex-auditPixmFeed-delete-source.md).
 

##### 2:3.104.5.1.2 Patient Identifier Cross-reference Manager Audit

The Patient Identifier Cross-reference Manager when grouped with ATNA Secure Node or Secure Application actor shall be able to record AuditEvents. The Patient Identifier Cross-Reference Manager can distinguish a Create and Update so is expected to record Create and Update specifically.

* on a Create [PIXm Feed Create Manager Audit Event Log](StructureDefinition-IHE.PIXm.Feed.Create.Audit.Manager.md) 
* [Audit Example for a PIXm Feed Create transaction from manager perspective](AuditEvent-ex-auditPixmFeed-create-manager.md).
 
* on an Update [PIXm Feed Update Manager Audit Event Log](StructureDefinition-IHE.PIXm.Feed.Update.Audit.Manager.md) 
* [Audit Example for a PIXm Feed Update transaction from manager perspective](AuditEvent-ex-auditPixmFeed-update-manager.md).
 
* on a Delete [PIXm Feed Delete Manager Audit Event Log](StructureDefinition-IHE.PIXm.Feed.Delete.Audit.Manager.md) 
* [Audit Example for a PIXm Feed Delete transaction from manager perspective](AuditEvent-ex-auditPixmFeed-delete-manager.md).
 

#### 2:3.104.5.2 Use with the Internet User Authorization (IUA) Profile

The [Internet User Authorization (IUA)](https://profiles.ihe.net/ITI/IUA/index.html) Profile provides support for user authentication, app authentication, and authorization decisions. When PIXm actors are grouped with IUA actors there are additional security and privacy functionality enabled by this grouping. There are additional requirements and functionality enabled through scope definitions that are transaction-specific.

A Patient Identity Source, when grouped with an [IUA](https://profiles.ihe.net/ITI/IUA/index.html) Authorization Client, shall use [Get Access Token [ITI-71]](https://profiles.ihe.net/ITI/IUA/index.html#volume-2----transactions) to request the following scope from the IUA Authorization Server. This enables the Patient Identity Source, to provide notifications with the Patient Identity Feed FHIR [ITI-104] transaction with the authorizing token in the combined transaction [Incorporate Access Token [ITI-72]](https://profiles.ihe.net/ITI/IUA/index.html#372-incorporate-access-token-iti-72).

The Patient Identifier Cross-reference Manager, when grouped with an [IUA](https://profiles.ihe.net/ITI/IUA/index.html) Resource Server, shall require [Incorporate Access Token [ITI-72]](https://profiles.ihe.net/ITI/IUA/index.html#372-incorporate-access-token-iti-72) in all Patient Identity Feed FHIR [ITI-104] transactions, shall enforce the authorization decision in the token, and may further enforce policies beyond those made by the Authorization Server such as consent or business rules.

```
scope: ITI-104

```

This scope request authorizes the full [ITI-105] transaction. This scope implicitly request patient-specific Create/Update/Delete for Patient resources as defined in [ITI-104]. Further scope refinement is allowed in realm or project-specific situations; these scopes would be in addition to the scope defined here.

##### 2:3.104.5.2.1 AuditEvent Augmentation

The Security audit logging interactions should be augmented following [IHE-BALP Basic Audit Logging Patterns](https://profiles.ihe.net/ITI/BALP/index.html), to include agent details [from the OAuth Security token](https://profiles.ihe.net/ITI/BALP/content.html#3575-oauth-security-token).

