# Download and Analysis - Patient Identifier Cross-referencing for mobile (PIXm) v3.0.5-current

* [**Table of Contents**](toc.md)
* **Download and Analysis**

## Download and Analysis

You can download:

* [this entire guide](full-ig.zip),
* the definition resources in [json](definitions.json.zip), [xml](definitions.xml.zip), [ttl](definitions.ttl.zip), or [csv](csvs.zip) format, or
* the example resources in [json](examples.json.zip), [xml](examples.xml.zip) or [ttl](examples.ttl.zip) format.

The source code for this Implementation Guide can be found on [IHE ITI.PIXm Github Repo](https://github.com/IHE/ITI.PIXm).

#### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (ihe.iti.pixm.r4)](package.r4.tgz) and [R4B (ihe.iti.pixm.r4b)](package.r4b.tgz) are available.

#### Dependency Table





#### Globals Table

*There are no Global profiles defined*

#### IP Statements

This publication includes IP covered under the following statements.

* These codes are excerpted from Digital Imaging and Communications in Medicine (DICOM) Standard, Part 16: Content Mapping Resource, Copyright © 2011 by the National Electrical Manufacturers Association.

* [DICOM Controlled Terminology Definitions](http://hl7.org/fhir/R4/codesystem-dicom-dcim.html): [AuditEvent/ex-auditPixmFeed-create-manager](AuditEvent-ex-auditPixmFeed-create-manager.md), [AuditEvent/ex-auditPixmFeed-delete-manager](AuditEvent-ex-auditPixmFeed-delete-manager.md)...Show 14 more,[AuditEvent/ex-auditPixmFeed-delete-source](AuditEvent-ex-auditPixmFeed-delete-source.md),[AuditEvent/ex-auditPixmFeed-update-manager](AuditEvent-ex-auditPixmFeed-update-manager.md),[AuditEvent/ex-auditPixmFeed-update-source](AuditEvent-ex-auditPixmFeed-update-source.md),[AuditEvent/ex-auditPixmFeedDelete-manager](AuditEvent-ex-auditPixmFeedDelete-manager.md),[AuditEvent/ex-auditPixmFeedDelete-source](AuditEvent-ex-auditPixmFeedDelete-source.md),[AuditEvent/ex-auditPixmQuery-consumer](AuditEvent-ex-auditPixmQuery-consumer.md),[AuditEvent/ex-auditPixmQuery-manager](AuditEvent-ex-auditPixmQuery-manager.md),[AuditPixmFeedManagerCreate](StructureDefinition-IHE.PIXm.Feed.Create.Audit.Manager.md),[AuditPixmFeedManagerDelete](StructureDefinition-IHE.PIXm.Feed.Delete.Audit.Manager.md),[AuditPixmFeedManagerUpdate](StructureDefinition-IHE.PIXm.Feed.Update.Audit.Manager.md),[AuditPixmFeedSourceDelete](StructureDefinition-IHE.PIXm.Feed.Delete.Audit.Source.md),[AuditPixmFeedSourceUpdate](StructureDefinition-IHE.PIXm.Feed.Update.Audit.Source.md),[AuditPixmQueryConsumer](StructureDefinition-IHE.PIXm.Query.Audit.Consumer.md)and[AuditPixmQueryManager](StructureDefinition-IHE.PIXm.Query.Audit.Manager.md)
* [Audit Event ID](http://terminology.hl7.org/6.5.0/CodeSystem-audit-event-type.html): [AuditEvent/ex-auditPixmFeed-create-manager](AuditEvent-ex-auditPixmFeed-create-manager.md), [AuditEvent/ex-auditPixmFeed-delete-manager](AuditEvent-ex-auditPixmFeed-delete-manager.md)...Show 14 more,[AuditEvent/ex-auditPixmFeed-delete-source](AuditEvent-ex-auditPixmFeed-delete-source.md),[AuditEvent/ex-auditPixmFeed-update-manager](AuditEvent-ex-auditPixmFeed-update-manager.md),[AuditEvent/ex-auditPixmFeed-update-source](AuditEvent-ex-auditPixmFeed-update-source.md),[AuditEvent/ex-auditPixmFeedDelete-manager](AuditEvent-ex-auditPixmFeedDelete-manager.md),[AuditEvent/ex-auditPixmFeedDelete-source](AuditEvent-ex-auditPixmFeedDelete-source.md),[AuditEvent/ex-auditPixmQuery-consumer](AuditEvent-ex-auditPixmQuery-consumer.md),[AuditEvent/ex-auditPixmQuery-manager](AuditEvent-ex-auditPixmQuery-manager.md),[AuditPixmFeedManagerCreate](StructureDefinition-IHE.PIXm.Feed.Create.Audit.Manager.md),[AuditPixmFeedManagerDelete](StructureDefinition-IHE.PIXm.Feed.Delete.Audit.Manager.md),[AuditPixmFeedManagerUpdate](StructureDefinition-IHE.PIXm.Feed.Update.Audit.Manager.md),[AuditPixmFeedSourceDelete](StructureDefinition-IHE.PIXm.Feed.Delete.Audit.Source.md),[AuditPixmFeedSourceUpdate](StructureDefinition-IHE.PIXm.Feed.Update.Audit.Source.md),[AuditPixmQueryConsumer](StructureDefinition-IHE.PIXm.Query.Audit.Consumer.md)and[AuditPixmQueryManager](StructureDefinition-IHE.PIXm.Query.Audit.Manager.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Audit event entity type](http://terminology.hl7.org/6.5.0/CodeSystem-audit-entity-type.html): [AuditEvent/ex-auditPixmFeed-create-manager](AuditEvent-ex-auditPixmFeed-create-manager.md), [AuditEvent/ex-auditPixmFeed-delete-manager](AuditEvent-ex-auditPixmFeed-delete-manager.md)...Show 14 more,[AuditEvent/ex-auditPixmFeed-delete-source](AuditEvent-ex-auditPixmFeed-delete-source.md),[AuditEvent/ex-auditPixmFeed-update-manager](AuditEvent-ex-auditPixmFeed-update-manager.md),[AuditEvent/ex-auditPixmFeed-update-source](AuditEvent-ex-auditPixmFeed-update-source.md),[AuditEvent/ex-auditPixmFeedDelete-manager](AuditEvent-ex-auditPixmFeedDelete-manager.md),[AuditEvent/ex-auditPixmFeedDelete-source](AuditEvent-ex-auditPixmFeedDelete-source.md),[AuditEvent/ex-auditPixmQuery-consumer](AuditEvent-ex-auditPixmQuery-consumer.md),[AuditEvent/ex-auditPixmQuery-manager](AuditEvent-ex-auditPixmQuery-manager.md),[AuditPixmFeedManagerCreate](StructureDefinition-IHE.PIXm.Feed.Create.Audit.Manager.md),[AuditPixmFeedManagerDelete](StructureDefinition-IHE.PIXm.Feed.Delete.Audit.Manager.md),[AuditPixmFeedManagerUpdate](StructureDefinition-IHE.PIXm.Feed.Update.Audit.Manager.md),[AuditPixmFeedSourceDelete](StructureDefinition-IHE.PIXm.Feed.Delete.Audit.Source.md),[AuditPixmFeedSourceUpdate](StructureDefinition-IHE.PIXm.Feed.Update.Audit.Source.md),[AuditPixmQueryConsumer](StructureDefinition-IHE.PIXm.Query.Audit.Consumer.md)and[AuditPixmQueryManager](StructureDefinition-IHE.PIXm.Query.Audit.Manager.md)
* [AuditEventEntityRole](http://terminology.hl7.org/6.5.0/CodeSystem-object-role.html): [AuditEvent/ex-auditPixmFeed-create-manager](AuditEvent-ex-auditPixmFeed-create-manager.md), [AuditEvent/ex-auditPixmFeed-delete-manager](AuditEvent-ex-auditPixmFeed-delete-manager.md)...Show 14 more,[AuditEvent/ex-auditPixmFeed-delete-source](AuditEvent-ex-auditPixmFeed-delete-source.md),[AuditEvent/ex-auditPixmFeed-update-manager](AuditEvent-ex-auditPixmFeed-update-manager.md),[AuditEvent/ex-auditPixmFeed-update-source](AuditEvent-ex-auditPixmFeed-update-source.md),[AuditEvent/ex-auditPixmFeedDelete-manager](AuditEvent-ex-auditPixmFeedDelete-manager.md),[AuditEvent/ex-auditPixmFeedDelete-source](AuditEvent-ex-auditPixmFeedDelete-source.md),[AuditEvent/ex-auditPixmQuery-consumer](AuditEvent-ex-auditPixmQuery-consumer.md),[AuditEvent/ex-auditPixmQuery-manager](AuditEvent-ex-auditPixmQuery-manager.md),[AuditPixmFeedManagerCreate](StructureDefinition-IHE.PIXm.Feed.Create.Audit.Manager.md),[AuditPixmFeedManagerDelete](StructureDefinition-IHE.PIXm.Feed.Delete.Audit.Manager.md),[AuditPixmFeedManagerUpdate](StructureDefinition-IHE.PIXm.Feed.Update.Audit.Manager.md),[AuditPixmFeedSourceDelete](StructureDefinition-IHE.PIXm.Feed.Delete.Audit.Source.md),[AuditPixmFeedSourceUpdate](StructureDefinition-IHE.PIXm.Feed.Update.Audit.Source.md),[AuditPixmQueryConsumer](StructureDefinition-IHE.PIXm.Query.Audit.Consumer.md)and[AuditPixmQueryManager](StructureDefinition-IHE.PIXm.Query.Audit.Manager.md)
* [Provenance participant type](http://terminology.hl7.org/6.5.0/CodeSystem-provenance-participant-type.html): [AuditEvent/ex-auditPixmFeed-delete-manager](AuditEvent-ex-auditPixmFeed-delete-manager.md), [AuditEvent/ex-auditPixmFeed-delete-source](AuditEvent-ex-auditPixmFeed-delete-source.md)...Show 4 more,[AuditEvent/ex-auditPixmFeedDelete-manager](AuditEvent-ex-auditPixmFeedDelete-manager.md),[AuditEvent/ex-auditPixmFeedDelete-source](AuditEvent-ex-auditPixmFeedDelete-source.md),[AuditPixmFeedManagerDelete](StructureDefinition-IHE.PIXm.Feed.Delete.Audit.Manager.md)and[AuditPixmFeedSourceDelete](StructureDefinition-IHE.PIXm.Feed.Delete.Audit.Source.md)
* [Audit Event Source Type](http://terminology.hl7.org/6.5.0/CodeSystem-security-source-type.html): [AuditEvent/ex-auditPixmFeed-create-manager](AuditEvent-ex-auditPixmFeed-create-manager.md), [AuditEvent/ex-auditPixmFeed-delete-manager](AuditEvent-ex-auditPixmFeed-delete-manager.md)...Show 7 more,[AuditEvent/ex-auditPixmFeed-delete-source](AuditEvent-ex-auditPixmFeed-delete-source.md),[AuditEvent/ex-auditPixmFeed-update-manager](AuditEvent-ex-auditPixmFeed-update-manager.md),[AuditEvent/ex-auditPixmFeed-update-source](AuditEvent-ex-auditPixmFeed-update-source.md),[AuditEvent/ex-auditPixmFeedDelete-manager](AuditEvent-ex-auditPixmFeedDelete-manager.md),[AuditEvent/ex-auditPixmFeedDelete-source](AuditEvent-ex-auditPixmFeedDelete-source.md),[AuditEvent/ex-auditPixmQuery-consumer](AuditEvent-ex-auditPixmQuery-consumer.md)and[AuditEvent/ex-auditPixmQuery-manager](AuditEvent-ex-auditPixmQuery-manager.md)
* [ActReason](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActReason.html): [AuditEvent/ex-auditPixmFeed-create-manager](AuditEvent-ex-auditPixmFeed-create-manager.md), [AuditEvent/ex-auditPixmFeed-delete-manager](AuditEvent-ex-auditPixmFeed-delete-manager.md)...Show 9 more,[AuditEvent/ex-auditPixmFeed-delete-source](AuditEvent-ex-auditPixmFeed-delete-source.md),[AuditEvent/ex-auditPixmFeed-update-manager](AuditEvent-ex-auditPixmFeed-update-manager.md),[AuditEvent/ex-auditPixmFeed-update-source](AuditEvent-ex-auditPixmFeed-update-source.md),[AuditEvent/ex-auditPixmFeedDelete-manager](AuditEvent-ex-auditPixmFeedDelete-manager.md),[AuditEvent/ex-auditPixmFeedDelete-source](AuditEvent-ex-auditPixmFeedDelete-source.md),[AuditEvent/ex-auditPixmQuery-consumer](AuditEvent-ex-auditPixmQuery-consumer.md),[AuditEvent/ex-auditPixmQuery-manager](AuditEvent-ex-auditPixmQuery-manager.md),[Device/ex-device](Device-ex-device.md)and[Patient/ex-patient](Patient-ex-patient.md)
* [ParticipationType](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ParticipationType.html): [AuditPixmQueryConsumer](StructureDefinition-IHE.PIXm.Query.Audit.Consumer.md) and [AuditPixmQueryManager](StructureDefinition-IHE.PIXm.Query.Audit.Manager.md)


