# Update Name - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* **Update Name**

## Update Name

### Update Name Overview

The update name operations allow an authorised user to update a name on a persons identity record.

The update has four sub-operations available:

* **Set-preferred-name – Set the Preferred Name the person wishes to be identied as**
* **Add-name – Add a new name to the set of Patient Names for this NHI record**
* **Replace-name – Replace a name that is currently on the patients NHI record**
* **Inactivate-name – Remove a name from the set of Patient Names returned to users**

### Set-preferred-name Overview

* Allows an authorised user to select the Preferred Name for this NHI number.

**Set-preferred-name - Processing steps:**

1. The user selects a patients name (that already exists on NHI) to become the new preferred name.
1. The integrating application sends an HTTP Post request using the $set-preferred-name operation to the NHI E.g. Post<Endpoint>/Patient/$set-preferred-name.
1. The request is validated - ALT: Validation failure. Operation Outcome resource returned.
1. The preferred name flag is set to false on the existing preferred name and true on the requested name.
1. The updated patient record is returned with an HTTP 200 ok response.
1. The integrating application displays the updated patient details to the user.

#### Set-preferred-name - In Parameters 

* Parameter name: nhi
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The patients nhi number
* Parameter name: version-id
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The current patient version number
* Parameter name: preferred-id
  * Parameter type: valueInteger
  * Mandatory / Optional: Mandatory
  * Description: The id for the name that will be preferred

#### Set-preferred-name - Behaviour

* The NHI is validated.
* The Patient version-id is validated.
* The name preferred-id is validated.
* If all request parameters are valid the name.preferred boolean is set to TRUE on the requested name and FALSE on the current preferred name.

#### Set-preferred-name - Example request

```
{
  "resourceType": "Parameters",
  "id": "example",
  "parameter": [
    {
        "name" : "nhi",
        "valueString" : "ZGD1407"
    },
    {
        "name" : "version-id",
        "valueString" : "3357591"
    },
    {
        "name" : "preferred-id",
        "valueInteger" : 6
    }
  ]
}


```

#### Set-preferred-name - Rules and errors

[For Request rules and errors click here](/general.md#request-rules-and-errors)

##### Set-preferred-name rules

* A set-preferred-name request must contain: 
* the live NHI number for the Patient Record.
* the version number of the current Patient Record.
* the preferred-id.
 

-------

* **Set-preferred-name errors.** 
* **A valid NHI, preferred ID and version number are required.**
* **Patient Name Set ID provided is invalid or inactive.**
 

### Add-name Overview

* Allows an authorised user to add a new name to the set of patient names for this NHI record.

**Add-name - Processing steps:**

1. The user provides the new patient name to be added to the patients NHI record.
1. The integrating application sends an HTTP Post request using the $add-name operation to the NHI E.g. Post<Endpoint>/Patient/$add-name.
1. The request is validated - ALT: Validation failure. Operation Outcome resource returned.
1. The updated patient record is returned with an HTTP 200 ok response.
1. The integrating application displays the updated patient details to the user.

#### Add-name - In Parameters 

* Parameter name: nhi
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The patients nhi number
* Parameter name: version-id
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The current patient version number
* Parameter name: use
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: The name use qualifier for a name
* Parameter name: prefix
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: The name prefix
* Parameter name: given-1
  * Parameter type: valueString
  * Mandatory / Optional: Optional*
  * Description: The first or given name
* Parameter name: given-2
  * Parameter type: valueString
  * Mandatory / Optional: Optional*
  * Description: The middle or other given name/s
* Parameter name: family
  * Parameter type: valueString
  * Mandatory / Optional: Optional*
  * Description: The family name
* Parameter name: preferred
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The attribute used to indicate whether the name is preferred or not
* Parameter name: information-source
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: the information source sighted when adding the name
* Parameter name: nhi-name-use-extra
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: an attribute used to qualify pre-allocated and babyof names

#### Add-name - Behaviour

* The NHI is validated.
* The Patient version-id is validated.
* If all request parameters are valid the name is added to the NHI. 
* If the preferred boolean is set to TRUE in the request then the name is added as the preferred name and the current preferred name is set to FALSE.
* If the preferred boolean is set to FALSE in the request then the name is added to the NHI and no changes occur to any names on the NHI.
 

#### Add-name - Example request

```
{
  "resourceType": "Parameters",
  "id": "example",
  "parameter": [
    {
        "name" : "nhi",
        "valueString" : "ZGD1407"
    },
    {
        "name" : "version-id",
        "valueString" : "3357591"
    },
    {
        "name" : "use",
        "valueString" : "maiden"
    },
    {
        "name" : "prefix",
        "valueString" : "mr"
    },
    {
        "name" : "given-1",
        "valueString" : "James"
    },
    {
        "name" : "given-2",
        "valueString" : "George Joseph"
    },
    {
        "name" : "family",
        "valueString" : "Granger"
    },
    {
        "name" : "preferred",
        "valueString" : "true"
    },
    {
        "name" : "information-source",
        "valueString" : "NPRF"
    }
  ]
}


```

#### Add-name - Rules and errors

[For Request rules and errors click here](/general.md#request-rules-and-errors)

##### Add-name rules

* All [create patient name rules](/createPatient.md#create-patient-name-rules) apply, and
* An add-name request must contain: 
* the live NHI number for the Patient Record.
* the version number of the current Patient Record.
 
* An update name request must not create a duplicate of an existing name for an NHI number [see glossary for name definitions](/glossary.md)
* A request must not result in information removed from a Patient Record by NHI Administration, being added (A name that has been deleted by HealthNZ cannot be added i.e. family name, given(1) and given(2) match a name with a ‘deleted’ status).
* A request must update the source of information only when the information is also provided.
* An update which results in an attribute Status of Registered must only be submitted via an authorised Agency update.
* A Patient must have one, and only one, Active Name which is preferred.
* A Patient may have a maximum of 200 active Names.

-------

* **Add-name errors.** 
* **Patient NHI and version number are required.**
* **Version number is incorrect.**
* **The name already exists for this patient.**
* **The name requested has been removed from the patient record by NHI administration.**
* **name-information-source is required when name is present.**
* **name can only be set to a ‘Registered’ value by an authorised Agency.**
* **A Patient must not have more than 200 active names.**
 

### Replace-name Overview

* Allows an authorised user to replace a patients name on an NHI record.

**Replace-name - Processing steps:**

1. The user provides the new patient name to replace a patients name on the NHI record.
1. The integrating application sends an HTTP Post request using the $replace-name operation to the NHI E.g. Post<Endpoint>/Patient/$replace-name.
1. The request is validated - ALT: Validation failure. Operation Outcome resource returned.
1. The updated patient record is returned with an HTTP 200 ok response.
1. The integrating application displays the updated patient details to the user.

#### Replace-name - In Parameters 

* Parameter name: nhi
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The patients nhi number
* Parameter name: version-id
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The current patient version number
* Parameter name: replace-id
  * Parameter type: valueInteger
  * Mandatory / Optional: Mandatory
  * Description: The set id for the name to be replaced
* Parameter name: use
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: The name use qualifier for a name
* Parameter name: prefix
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: The name prefix
* Parameter name: given-1
  * Parameter type: valueString
  * Mandatory / Optional: Optional*
  * Description: The first or given name
* Parameter name: given-2
  * Parameter type: valueString
  * Mandatory / Optional: Optional*
  * Description: The middle or other given name/s
* Parameter name: family
  * Parameter type: valueString
  * Mandatory / Optional: Optional*
  * Description: The family name
* Parameter name: preferred
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The attribute used to indicate whether the name is preferred or not
* Parameter name: information-source
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The information source sighted when adding the name
* Parameter name: nhi-name-use-extra
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: an attribute used to qualify pre-allocated and babyof names

#### Replace-name - Behaviour

* The NHI is validated.
* The Patient version-id is validated.
* The name replace-id is validated.
* If all request parameters are valid the name in the request will replace the requested name in the NHI. 
* If the preferred boolean is set to TRUE in the request then the name is added as the preferred name.
* If the preferred boolean is set to FALSE in the request then the name is added as a **non-preferred name**.
 

#### Replace-name - Example request

```
{
  "resourceType": "Parameters",
  "id": "example",
  "parameter": [
    {
        "name" : "nhi",
        "valueString" : "ZGD1407"
    },
    {
        "name" : "version-id",
        "valueString" : "3357591"
    },
    {
        "name" : "replace-id",
        "valueInteger" : 22
    },
    {
        "name" : "use",
        "valueString" : "nickname"
    },
    {
        "name" : "prefix",
        "valueString" : "mr"
    },
    {
        "name" : "given-1",
        "valueString" : "James"
    },
    {
        "name" : "given-2",
        "valueString" : "George Joseph"
    },
    {
        "name" : "family",
        "valueString" : "Granger"
    },
    {
        "name" : "preferred",
        "valueString" : "true"
    },
    {
        "name" : "information-source",
        "valueString" : "NPRF"
    }
  ]
}


```

#### Replace-name - Rules and errors

[For Request rules and errors click here](/general.md#request-rules-and-errors)

##### Replace-name rules

* All [create patient name rules](/createPatient.md#create-patient-name-rules) apply, and
* An replace-name request must contain: 
* the live NHI number for the Patient Record.
* the version number of the current Patient Record.
* the replace-id (set-id for name being replaced).
 
* An update name request must not create a duplicate of an existing name for an NHI number [see glossary for name definitions](/glossary.md).
* A request must not result in information, removed from a Patient Record by NHI Administration, being added (A name that has been deleted by HealthNZ cannot be added i.e. family name, given(1) and given(2) match a name with a ‘deleted’ status).
* A request must not result in modification of information confirmed by authorised Agency (“registered” information).
* A request must update the source of information only when the information is also provided.
* An update which results in an attribute Status of Registered must only be submitted via an authorised Agency update.
* A request may modify active patient information for which evidence has been sighted (“verified” information). 
* Can modify a verified source to another verified source or verified to Registered.
 
* A Patient must have one, and only one, Active Name which is preferred.
* An existing name must be active to be updated.
* A non-preferred name may be made inactive (an inactive name is not returned in web service responses)
* A Patient may have a maximum of 200 active Names.

-------

* **Replace-name errors.** 
* **Patient NHI and version number are required.**
* **Version number is incorrect.**
* **Patient Name Set ID provided is invalid or inactive**
* **The name already exists for this patient.**
* **The name requested has been removed from the patient record by NHI administration.**
* **name-information-source is required when name is present.**
* **name can only be set to a ‘Registered’ value by an authorised Agency.**
* **A Patient must not have more than 200 active names.**
* **The patient name is not active and cannot be updated.**
* **Cannot update a source to a lower level of proof. Can modify a verified source to another verified source or verified to Registered.**
* **Information set to registered cannot be updated please contact NHI administration for more information.**
 

### Inactivate-name Overview

* Allows an authorised user to remove a name from the set of Patient Names returned to users

**Inactivate-name - Processing steps:**

1. The user selects a patients name (that already exists on NHI) to become inactive.
1. The integrating application sends an HTTP Post request using the $inactivate-name operation to the NHI E.g. Post<Endpoint>/Patient/$inactivate-name.
1. The request is validated - ALT: Validation failure. Operation Outcome resource returned.
1. The name is made inactive on the patient record and is not returned on any future requests.
1. The updated patient record is returned with an HTTP 200 ok response.
1. The integrating application displays the updated patient details to the user.

#### Inactivate-name - In Parameters 

* Parameter name: nhi
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The patients nhi number
* Parameter name: version-id
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The current patient version number
* Parameter name: inactivate-id
  * Parameter type: valueInteger
  * Mandatory / Optional: Mandatory
  * Description: The id for the name to be made inactive on the patient record

#### Inactivate-name - Behaviour

* The NHI is validated.
* The Patient version-id is validated.
* The inactivate-id is validated.
* If all request parameters are valid the name is made inactive on the patient record and is not returned on future requests.

#### Inactivate-name - Example request

```
{
  "resourceType": "Parameters",
  "id": "example",
  "parameter": [
    {
        "name" : "nhi",
        "valueString" : "ZGD1407"
    },
    {
        "name" : "version-id",
        "valueString" : "3357591"
    },
    {
        "name" : "inactivate-id",
        "valueInteger" : 6
    }
  ]
}


```

#### Inactivate-name - Rules and errors

[For Request rules and errors click here](/general.md#request-rules-and-errors)

##### Inactivate-name rules

* All [create patient name rules](/createPatient.md#create-patient-name-rules) apply, and
* An Inactivate-name request must contain: 
* the live NHI number for the Patient Record.
* the version number of the current Patient Record.
* the inactivate-id (set-id for name being inactivated).
 
* A request must not result in modification of information confirmed by authorised Agency (“registered” information).
* A request may modify active patient information which is not ‘registered’ or verified’ information.
* An existing name must be active to be updated.

-------

* **Inactivate-name errors.** 
* **A valid NHI, preferred ID and version number are required.**
* **Patient Name Set ID provided is invalid or inactive.**
* **Information set to registered cannot be updated please contact NHI administration for more information.**
* **The Patient Name is not active and cannot be updated.**
* **A non-preferred name may be made inactive (an inactive name is not returned in web service responses).**
 

