# Update Eligibility - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* **Update Eligibility**

## Update Eligibility

### Update Eligibility Overview

The update eligibility operation allows an authorised user to update citizenship on a person's identity record.

This includes:

* NZ Citizenship
* NZ Citizenship information source

**Update-eligibility - Processing steps:**

1. The user provides patient details to be updated
1. The integrating application sends an HTTP Post request using the $update-eligibility operation to the NHI E.g. Post<Endpoint>/Patient/$update-eligibility
1. The request is validated - ALT: Validation failure. Operation Outcome resource returned
1. The provided patient attributes are updated
1. The updated record is returned with an HTTP 200 ok response
1. The integrating application displays the updated details to the user

#### Update-eligibility - In Parameters

* Parameter name: nhi
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The patients nhi number
* Parameter name: version-id
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The current patient version number
* Parameter name: nz-citizenship-status
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: The patients NZ citizenship status
* Parameter name: nz-citizenship-source
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: The information source for the patients NZ citizenship status

#### Update-eligibility - Behaviour

* The NHI is validated
* The Patient version-id is validated
* The parameters are validated
* If all request parameters are valid, the attributes are updated on the NHI.

#### Update-eligibility - Example request

```
{
  "resourceType": "Parameters",
  "id": "example",
  "parameter": [
    {
        "name" : "nhi",
        "valueString" : "ZGD9203"
    },
    {
        "name" : "version-id",
        "valueString" : "3321540"
    },
    {
        "name" : "nz-citizenship-status",
        "valueString" : "unknown" 
    },
    {
        "name" : "nz-citizenship-source",
        "valueString" : "NPRF" 
    }
  ]
}

```

#### Update-eligibility - Rules and errors

[For Request rules and errors click here](/general.md#request-rules-and-errors)

##### Patient update-eligibility rules

* An update request must contain: 
* the live NHI number for the Patient Record.
* the version number of the current Patient Record.
 
* An update request may: 
* modify active patient information which is not ‘registered’ information.
* modify active patient information for which evidence has been sighted (“verified” information). Can modify a verified source to another verified source or verified to Registered.
 
* An update request which results in an attribute Status of Registered must only be submitted via an authorised Agency.
* An update request to update the value for a core identity field must also update the information source.
* An update request must update the source of information only when the information is also provided.

##### Update-eligibility nz citizenship rules

* All [create patient NZCitizenship rules apply](/createPatient.md#create-patient-nz-citizenship-rules) and,
* A request to update citizenship must also update citizenship-information-source
* birth-place cannot be updated if source is ‘registered’ (BREG) See Glossary
* birth-place can only be updated to registered by an authorised agency
* A verified birthplace can be updated by another verified source, not by an unverified source.

-------

* **Patient update-eligibility errors** 
* **Patient NHI and version number are required**
* **Version number is incorrect**
* **The NHI Identifier provided is dormant. This record cannot be updated**
 

