# Maintain Contact - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* **Maintain Contact**

## Maintain Contact

### Maintain Contact

The maintain contact operations allow an authorised user to maintain a person's contact information on their identity record.

Three operations are available:

* **add-contact – Set the Preferred Name the person wishes to be identied as**
* **replace-contact – Add a new name to the set of Patient Names for this NHI record**
* **delete-contact – Replace a name that is currently on the patients NHI record**

### Add-contact Overview

* Allows an authorised user to add a contact to a patient's NHI record

#### Add-contact - Processing steps:

1. The user provides the new contact details to be added to the patient's NHI record
1. The integrating application sends an HTTP Post request using the $add-contact operation to the NHI E.g.`Post <Endpoint>/Patient/$add-contact`
1. The request is validated - ALT: Validation failure. Operation Outcome resource returned.
1. The updated patient record is returned with an HTTP 200 ok response.
1. The integrating application displays the updated patient details to the user.

###  Add-contact - In Parameters 

* Parameter name: nhi
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The patient's nhi number
* Parameter name: version-id
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The current patient version number
* Parameter name: use
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: home or mobile
* Parameter name: system
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: phone or email
* Parameter name: value
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: the phone number or email address
* Parameter name: isVerified
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: Verification has been performed to determine that the email or phone number can be used to communicate with the patient (true or false)
* Parameter name: isShared
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: The email address or phone number is shared with other people (true or false)
* Parameter name: isPrivate
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: The email address or phone number may be used to communicate private health information about the individual identified by the NHI

#### Add-contact - Behaviour

* The NHI is validated.
* The Patient version-id is validated.
* The contact details are validated.
* If all request parameters are valid the name.preferred boolean is set to TRUE on the requested name and FALSE on the current preferred name.

#### Add-contact - Example request

[add-contact request](/Parameters-AddContact.md)

#### Add-contact - Rules and errors

[For Request rules and errors click here](/general.md#request-rules-and-errors)

##### Add-contact rules
* Add-contact request must contain:

```
* the live NHI number for the Patient Record.
* the version number of the current Patient Record.
* the contact details

```

* **Add-contact errors.**
* **A valid NHI, preferred ID and version number are required.**

### Replace-contact Overview

* Allows an authorised user to replace patient contact details for this NHI record.

**Replace-contact - Processing steps:**

1. The user provides the new patient contact to be added to the patients NHI record, and the id of the existing contact which is to be replaced.
1. The integrating application sends an HTTP Post request using the $add-name operation to the NHI E.g.`Post <Endpoint>/Patient/$replace-contact`
1. The request is validated - ALT: Validation failure. Operation Outcome resource returned.
1. The updated patient record is returned with an HTTP 200 ok response.
1. The integrating application displays the updated patient details to the user.

#### Replace-contact - In Parameters 

* Parameter name: nhi
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The patients nhi number
* Parameter name: version-id
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The current patient version number
* Parameter name: contact-id
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The id of the contact element to be replaced
* Parameter name: use,system,value,isVerified,isShared
  * Parameter type: as per[ Add-contact - In Parameters](#add-contact-in-parameters)

#### Replace-contact - Behaviour

* The NHI is validated.
* The Patient version-id is validated.
* If all request parameters are valid the old contact is replaced by the new contact.

#### Replace-contact- Example request

[replace-contact request](/Parameters-ReplaceContact.md)

#### Replace-contact - Rules and errors

[For Request rules and errors click here](/general.md#request-rules-and-errors)

##### Replace-contact rules

* All [add-contact rules](/updateContact.md#add-contact---rules-and-errors) apply, and
* An replace-contact request must contain: 
* the live NHI number for the Patient Record.
* the version number of the current Patient Record.
 

-------

* **Replace Contact errors.** 
* **Patient NHI and version number are required.**
* **Version number is incorrect.**
* **The contact-id does not exists for this patient.**
 

### Delete-contact Overview

* Allows an authorised user to delete a patient's contact from the NHI record.

**Delete-contact - Processing steps:**

1. The user provides the id of the contact to be deleted from the NHI E.g. Post<Endpoint>/Patient/$delete-contact.
1. The request is validated - ALT: Validation failure. Operation Outcome resource returned.
1. The updated patient record is returned with an HTTP 200 ok response.
1. The integrating application displays the updated patient details to the user.

#### Delete-contact - In Parameters 

* Parameter name: nhi
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The patients nhi number
* Parameter name: version-id
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The current patient version number
* Parameter name: contact-id
  * Parameter type: valueInteger
  * Mandatory / Optional: Mandatory
  * Description: The id of the contact to be deleted

#### Delete-contact - Behaviour

* The NHI is validated.
* The Patient version-id is validated.
* The contact-id is validated.
* If all request parameters are valid the contact identified in the request will be deleted from the NHI.

#### Delete-contact - Example request

[delete-contact request](/Parameters-DeleteContact.md)

#### Delete-contact - Rules and errors

[For Request rules and errors click here](/general.md#request-rules-and-errors)

##### Delete-contact rules

* An delete-contact request must contain: 
* the live NHI number for the Patient Record.
* the version number of the current Patient Record.
* the contact-id of the contact to be deleted
 

-------

* **Delete contact errors.** 
* **Patient NHI and version number are required.**
* **Version number is incorrect.**
* **The contact-id does not exists for this patient.**
 

