# hl7.org.nz.fhir.ig.nhi#1.6.5: New Zealand NHI IG

## Pages

* [Home](index.md)
* [API](API.md)
* [Compliance Testing Important Information](ComplianceTestingImportantInformation.md)
* [Consumer Facing Application Authentication](ConsumerFacingApplicationAuthentication.md)
* [Consumer Facing Application Authentication Compliance Testing](ConsumerFacingApplicationAuthenticationComplianceTesting.md)
* [Create Patient Compliance Testing](CreatePatientComplianceTesting.md)
* [FAQ](FAQ.md)
* [Get Match And Validate Patient Compliance Testing](GetMatchAndValidatePatientComplianceTesting.md)
* [Onboarding](Onboarding.md)
* [Terms Of Use](TermsOfUse.md)
* [Update Patient Compliance Testing](UpdatePatientComplianceTesting.md)
* [Artifacts Summary](artifacts.md)
* [Business View](businessView.md)
* [Create Patient](createPatient.md)
* [Create Patient Example](createPatientExample.md)
* [Downloads](downloads.md)
* [Extensions](extensions.md)
* [General](general.md)
* [Get Patient](getPatient.md)
* [Glossary](glossary.md)
* [Guidance](guidance.md)
* [Maintain Contact](maintainContact.md)
* [Match Example](matchExample.md)
* [Match Patient](matchPatient.md)
* [Naming Systems](namingSystems.md)
* [Notes](notes.md)
* [Profiles](profiles.md)
* [Terminology](terminology.md)
* [Update Address](updateAddress.md)
* [Update Birth](updateBirth.md)
* [Update Eligibility](updateEligibility.md)
* [Update Identity](updateIdentity.md)
* [Update Name](updateName.md)
* [Validate Patient](validatePatient.md)

## Resources

### ValueSets

* [NHI ContactPoint System Codes](ValueSet-nhi-contact-point-system-code-1.0.md)
* [NHI ContactPoint Use Codes](ValueSet-nhi-contactpoint-use.md)

### Logicals

* [Patient](StructureDefinition-PatientModel.md)

### Complex-type Profiles

* [NHI Address](StructureDefinition-NhiAddress.md)
* [NHI ContactPoint](StructureDefinition-NhiContactPoint.md)

### Resource Profiles

* [Create NHI Patient](StructureDefinition-CreateNhiPatient.md)
* [NHI Patient](StructureDefinition-NhiPatient.md)

### Extensions

* [context](StructureDefinition-Context.md)
* [isPrivate](StructureDefinition-IsPrivate.md)
* [isShared](StructureDefinition-IsShared.md)
* [isVerified](StructureDefinition-IsVerified.md)
* [NzAddressId](StructureDefinition-address-id.md)
* [BirthPlace](StructureDefinition-birth-place.md)
* [OriginalText](StructureDefinition-gender-original-text.md)
* [LastUpdatedDate](StructureDefinition-lastUpdatedDate.md)
* [NameUseExtra](StructureDefinition-name-use-extra.md)
* [NhiAddressDerived](StructureDefinition-nhi-address-derived.md)
* [NhiContactPointExtra](StructureDefinition-nhi-contact-point-extra.md)
* [NotValidatedAddressReason](StructureDefinition-not-validated-address-reason.md)

### CapabilityStatements

* [NhiCapabilityStatement](CapabilityStatement-NhiCapabilityStatement.md)

### ImplementationGuides

* [New Zealand NHI IG](index.md)

### OperationDefinitions

* [Add a contact to a patient's NHI record.](OperationDefinition-Patient-add-contact.md)
* [Add a name to a patient's NHI record.](OperationDefinition-Patient-add-name.md)
* [Create Patient](OperationDefinition-Patient-create.md)
* [Delete a contact from a patient's NHI record.](OperationDefinition-Patient-delete-contact.md)
* [An operation to inactivate a name that is currently active on a patients record.](OperationDefinition-Patient-inactivate-name.md)
* [Find patient matches using MPI based logic](OperationDefinition-Patient-match.md)
* [Remove a patient's postal address.](OperationDefinition-Patient-remove-postal-address.md)
* [Replace a contact on a patient's NHI record.](OperationDefinition-Patient-replace-contact.md)
* [Replace a name on a patient's NHI record.](OperationDefinition-Patient-replace-name.md)
* [Update a patient's address.](OperationDefinition-Patient-set-address.md)
* [Set patient's preferred name](OperationDefinition-Patient-set-preferred-name.md)
* [Update a patient address using an unvalidated address.](OperationDefinition-Patient-set-unvalidated-address.md)
* [Update patient's birth details](OperationDefinition-Patient-update-birth.md)
* [Update patient's death details](OperationDefinition-Patient-update-death.md)
* [An operation to update a patients citizenship information](OperationDefinition-Patient-update-eligibility.md)
* [Update patient's self-identified demographic information](OperationDefinition-Patient-update-identity.md)

### Examples

* [validate-response (Bundle)](Bundle-validate-response.md)
* [AddContact (Parameters)](Parameters-AddContact.md)
* [DeleteContact (Parameters)](Parameters-DeleteContact.md)
* [Match (Parameters)](Parameters-Match.md)
* [validate (Parameters)](Parameters-validate.md)
* [ZAA0792 (Patient)](Patient-ZAA0792.md)
* [ZAT2348 (Patient)](Patient-ZAT2348.md)
* [ZAT2496 (Patient)](Patient-ZAT2496.md)
* [ZJM9397 (Patient)](Patient-ZJM9397.md)
* [ZKC4633 (Patient)](Patient-ZKC4633.md)
* [create1 (Patient)](Patient-create1.md)
* [create2-error- (Patient)](Patient-create2-error-.md)
* [create3-errors (Patient)](Patient-create3-errors.md)
