# Extensions - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* **Extensions**

## Extensions

**Extensions defined in this guide**

* Id: [address-id](StructureDefinition-address-id.md)
  * Url: http://hl7.org.nz/fhir/StructureDefinition/nz-address-id
  * Context of Use: Address
  * Description: Uniquely identifies this address as a physical entity. Will remain constant over time even if address administrative data such as DPID change
  * Purpose: 
* Id: [birth-place](StructureDefinition-birth-place.md)
  * Url: http://hl7.org.nz/fhir/StructureDefinition/birth-place
  * Context of Use: Patient
  * Description: The country where the person was born
  * Purpose: 
* Id: [gender-original-text](StructureDefinition-gender-original-text.md)
  * Url: http://hl7.org.nz/fhir/StructureDefinition/gender-original-text
  * Context of Use: Patient.gender
  * Description: The text that was provided for Gender as it is uncoded
  * Purpose: 
* Id: [is-primary-address](StructureDefinition-is-primary-address.md)
  * Url: http://hl7.org.nz/fhir/StructureDefinition/is-primary-address
  * Context of Use: Address
  * Description: Indicates this is the primary residential address - each patient must have one and only one
  * Purpose: 
* Id: [name-use-extra](StructureDefinition-name-use-extra.md)
  * Url: http://hl7.org.nz/fhir/StructureDefinition/name-use-extra
  * Context of Use: Patient
  * Description: Additional name use codes for NHI names
  * Purpose: 
* Id: [nhi-address-derived](StructureDefinition-nhi-address-derived.md)
  * Url: http://hl7.org.nz/fhir/StructureDefinition/nhi-address-derived
  * Context of Use: Address
  * Description: Address elements that are directly derived from the actual address
  * Purpose: 
* Id: [not-validated-address-reason](StructureDefinition-not-validated-address-reason.md)
  * Url: http://hl7.org.nz/fhir/StructureDefinition/not-validated-address-reason
  * Context of Use: Address
  * Description: The reason why the address has not been validated
  * Purpose: 

