# NHI ContactPoint Use Codes - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NHI ContactPoint Use Codes**

## ValueSet: NHI ContactPoint Use Codes 

| | |
| :--- | :--- |
| *Official URL*:https://nzhts.digital.health.nz/fhir/ValueSet/nhiContactUseType | *Version*:1.6.5 |
| Active as of 2023-01-30 | *Computable Name*:NhiContactPointUse |

 
Types of contact use supported by the NHI 

 **References** 

* [NHI Patient](StructureDefinition-NhiPatient.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "nhi-contactpoint-use",
  "url" : "https://nzhts.digital.health.nz/fhir/ValueSet/nhiContactUseType",
  "version" : "1.6.5",
  "name" : "NhiContactPointUse",
  "title" : "NHI ContactPoint Use Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-01-30T00:00:00+13:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "Types of contact use supported  by the NHI",
  "compose" : {
    "include" : [
      {
        "system" : "http://hl7.org/fhir/contact-point-use"
      }
    ],
    "exclude" : [
      {
        "system" : "http://hl7.org/fhir/contact-point-use",
        "concept" : [
          {
            "code" : "temp"
          },
          {
            "code" : "old"
          },
          {
            "code" : "work"
          }
        ]
      }
    ]
  }
}

```
