# NHI ContactPoint System Codes - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NHI ContactPoint System Codes**

## ValueSet: NHI ContactPoint System Codes 

| | |
| :--- | :--- |
| *Official URL*:https://nzhts.digital.health.nz/fhir/ValueSet/nhi-contact-point-system-code | *Version*:1.6.5 |
| Active as of 2023-01-30 | *Computable Name*:NhiContactPointSystem |

 
System values for a ContactPoint supported by the NHI 

 **References** 

* [NHI Patient](StructureDefinition-NhiPatient.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "nhi-contact-point-system-code-1.0",
  "url" : "https://nzhts.digital.health.nz/fhir/ValueSet/nhi-contact-point-system-code",
  "version" : "1.6.5",
  "name" : "NhiContactPointSystem",
  "title" : "NHI ContactPoint System Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-01-30T00:00:00+13:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "System values for a ContactPoint supported  by the NHI",
  "compose" : {
    "include" : [
      {
        "system" : "http://hl7.org/fhir/contact-point-system",
        "concept" : [
          {
            "code" : "phone"
          },
          {
            "code" : "email"
          }
        ]
      }
    ]
  }
}

```
