# Update Patient Compliance Testing - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* **Update Patient Compliance Testing**

## Update Patient Compliance Testing

#### NHI Patient Maintain Address tests

* Reference: NHI-Maintain-Address-1
  * Purpose – Demonstrate that the: application can replace the** primary residential address **on a patient record with a validated address
  * Input values: * Use selected NHI number
* Locate a validated address to use (this can be done using https://www.nzpost.co.nz/tools/address-postcode-finder) or use Health_UI 
* Add a new ** primary residential address ** to the patient record using the set-addresss operation

  * Expected outcome: Input: Application can validate an address via e-SAM (using suggest or search)Input: An address request can be populated with appropriate informationOutput: The address that is displayed to the end user is the address that is returned in the update response
  * Mandatory: mandatory
* Reference: NHI-Maintain-Address-2
  * Purpose – Demonstrate that the: application can add (or replace) the** postal address **on a patient record with a validated address
  * Input values: * Use selected NHI number
* Locate a validated address to use (this can be done using https://www.nzpost.co.nz/tools/address-postcode-finder) or use Health_UI 
* Add a new ** postal address ** to the patient record using the set-addresss operation

  * Expected outcome: Input: Application can validate an address via e-SAM (using suggest or search)Input: An address request can be populated with appropriate informationOutput: The address that is displayed to the end user is the address that is returned in the update response
  * Mandatory: mandatory
* Reference: NHI-Maintain-Address-3
  * Purpose – Demonstrate that the: application can replace the** primary residential address **on a patient record with an** overseas **unvalidated address
  * Input values: * Use selected NHI number
* Add a new ** primary residential address ** to the patient record using the set-unvalidated-address operation 

  * Expected outcome: Input: An address request can be populated with overseas unvalidated address informationOutput: The address that is displayed to the end user is the address that is returned in the update response
  * Mandatory: mandatory
* Reference: NHI-Maintain-Address-4
  * Purpose – Demonstrate that the: application can replace the** primary residential address **on a patient record with an:*  ** 'unknown' unvalidated address ** 
*  ** 'no fixed abode' unvalidated address ** 
*  ** 'other' unvalidated address ** 

  * Input values: *  Use selected NHI number
* Add a new ** primary residential address ** to the patient record using the $set-unvalidated-address operation
**Do ALL***  ** 'unknown' unvalidated address ** 
*  ** 'no fixed abode' unvalidated address ** 
*  ** 'other' unvalidated address **

  * Expected outcome: Input: An address request can be populated with unvalidated address informationInput: Best Practice is followed for adding addresses[Best Practice Guide](https://www.health.govt.nz/system/files/documents/pages/identity-nhi-user-reference-information-best-practice-advice-sep21_8.pdf)Output: The address that is displayed to the end user is the address that is returned in the update response
  * Mandatory: mandatory
* Reference: NHI-Maintain-Address-5
  * Purpose – Demonstrate that the: application can replace the** primary residential address **on a patient record with an** Address Service Unavailable **unvalidated address
  * Input values: * Use selected NHI number
*  Disable the external Address Service lookup
*  Show Address Service error 
*  Add a new ** primary residential address ** to the patient record using the [$set-unvalidated-address](updateAddress.md)

  * Expected outcome: Input: An address request can be populated with NOSVC unvalidated address informationOutput: The address that is displayed to the end user is the address that is returned in the update response
  * Mandatory: mandatory
* Reference: NHI-Maintain-Address-6
  * Purpose – Demonstrate that the: application can replace the**postal address**on a patient record with an**Address Service Unavailable**unvalidated address
  * Input values: * Use selected NHI number
*  Disable the external Address Service lookup
*  Show Address Service error 
*  Add a new **postal address** to the patient record using the $set-unvalidated-address operation

  * Expected outcome: Input: An address request can be populated with NOSVC unvalidated address informationOutput: The address that is displayed to the end user is the address that is returned in the update response
  * Mandatory: mandatory
* Reference: NHI-Maintain-Address-7
  * Purpose – Demonstrate that the: application can replace the**postal address**on a patient record with an**Overseas**unvalidated address
  * Input values: * Use selected NHI number
*  Add a new **postal address** to the patient record using the $set-unvalidated-address operation

  * Expected outcome: Input: An address request can be populated with overseas unvalidated address informationOutput: The address that is displayed to the end user is the address that is returned in the update response
  * Mandatory: mandatory
* Reference: NHI-Maintain-Address-8
  * Purpose – Demonstrate that the: application can remove the**postal address**on a patient record
  * Input values: * Use selected NHI number
*  Remove the **postal address** from the patient record using the $remove-postal-address operation

  * Expected outcome: Output: The patient record has Postal address removed
  * Mandatory: mandatory
* Reference: NHI-Maintain-Address-9
  * Purpose – Demonstrate that the: application can add an unvalidated address with a building name
  * Input values: * Use selected NHI number
*  Add a new **physical address** to the patient record using the $set-unvalidated-address operation

  * Expected outcome: Input: An address can be populated with a building nameOutput: The address that is displayed to the end user is the address that is returned in the update response
  * Mandatory: mandatory
* Reference: NHI-Maintain-Address-10
  * Purpose – Demonstrate that the: application can add a validated address with a building name
  * Input values: * Use selected NHI number
*  Add a new **physical address** to the patient record using the $set-address operation

  * Expected outcome: Input: An address can be populated with a building nameOutput: The address that is displayed to the end user is the address that is returned in the update response
  * Mandatory: mandatory
* Reference: NHI-Maintain-Address-error-1$set-address
  * Purpose – Demonstrate that the: Application will show the correct error when attempting to add a new address to the provided dormant NHI number
  * Input values: *  NHI: ZAT2518 
*  address-line: 24 Anglesey Place 
*  nz-address-id: 1199146 
*  address-type: physical

  * Expected outcome: Error: EM02004 - The NHI Identifier provided is dormant. This record cannot be updated
  * Mandatory: Mandatory
* Reference: NHI-Maintain-Address-error-2$set-address
  * Purpose – Demonstrate that the: **Not currently implemented**Application will show the correct error when attempting to add the supplied address that has been previously removed from the patient record by NHI administration
  * Input values: *  NHI: ZJM9397 
*  address-line: 24 Anglesea Avenue 
*  nz-address-id: 967406 
*  address-type: physical

  * Expected outcome: Error: EM02004 - The Patient Address requested has been removed from the Patient record by Te Whatu Ora
  * Mandatory: Mandatory
* Reference: NHI-Maintain-Address-error-3$set-address
  * Purpose – Demonstrate that the: Application will show the correct error when attempting to add the following postal address for an undeliverable address
  * Input values: *  NHI: ZJM9397 
*  address-line: 748E Whitemans Valley Road 
*  nz-address-id: 3193368 
*  address-type: postal

  * Expected outcome: Error: EM02209 - A validated mailing address must be an address at which mail can be delivered
  * Mandatory: Mandatory
* Reference: NHI-Maintain-Address-error-4$set-address
  * Purpose – Demonstrate that the: Application will show the correct error when attempting to add an address where the nz address id does not match the first line of the validated address
  * Input values: *  NHI: ZJM9397 
*  address-line: 24 Ranglesey Place 
*  nz-address-id: 1199146 
*  address-type: physical

  * Expected outcome: Error: "address-line must match the espatial value: ..."
  * Mandatory: Mandatory
* Reference: NHI-Maintain-Address-error-5$set-unvalidated-address
  * Purpose – Demonstrate that the: Application will show the correct error when attempting to add the following unvalidated address without a domicile code
  * Input values: *  NHI: ZJM9397 
*  not-validated-address-reason: NOSVC 
*  address-type: physical 
*  address-line-1: 74 Chancellor Street" 
*  address-suburb: Richvale 
*  address-city: Christchurch 
*  address-country-code: NZ 

  * Expected outcome: Error: "Invalid codeset value"This will be updated in an upcming release - EM02210 - An unvalidated residential address must have a notional domicile code
  * Mandatory: Mandatory
* Reference: NHI-Maintain-Address-error-6$set-unvalidated-address
  * Purpose – Demonstrate that the: Application will show the correct error when attempting to add an address with invalid characters to the supplied patient
  * Input values: *  NHI: ZJM9397 
*  not-validated-address-reason: OTHER 
*  address-type: physical 
*  address-line-1: 11 L$nnet Street 
*  address-suburb: Taihape 
*  address-city: Taihape 
*  address-domicile-code: 4720 
*  address-country-code: NZ 

  * Expected outcome: Error: "Invalid request body"
  * Mandatory: Mandatory
* Reference: NHI-Maintain-Address-error-7$set-unvalidated-address
  * Purpose – Demonstrate that the: Application will show the correct error when attempting to add an address that does not contain address line 1
  * Input values: *  NHI: ZJM9397 
*  not-validated-address-reason: OTHER 
*  address-type: physical 
*  address-line-2: 11 Linnet Street 
*  address-suburb: Taihape 
*  address-city: Taihape 
*  address-domicile-code: 4720 
*  address-country-code: NZ 

  * Expected outcome: Error: "Patient address-line-1 is required"
  * Mandatory: Optional
* Reference: NHI-Maintain-Address-error-8$set-unvalidated-address
  * Purpose – Demonstrate that the: Application will show the correct error when attempting to add an address missing a not validated reason
  * Input values: *  NHI: ZJM9397 
*  address-type: physical 
*  address-line-1: 11 Linnet Street 
*  address-suburb: Taihape 
*  address-city: Taihape 
*  address-domicile-code: 4720 
*  address-country-code: NZ 

  * Expected outcome: Error: "Address not validated reason is required"
  * Mandatory: optional

#### NHI Patient Maintain Name tests

* Reference: NHI-$add-name-1
  * Purpose – Demonstrate that the: application can add a name to a patient record
  * Input values: Add a name to the selected NHI from list above with:* a family name; and
* a given name; and
* one or more other given name(s); and
* preferred set to true; and
* name use 'nickname'; and
* a name prefix; and
* a name source (e.g. a passport – ‘PPRT’)

  * Expected outcome: Input:* A fictitious name with name parts described can be added to the patient record
Output:* The name is presented to the user with appropraite name parts populated

  * Mandatory: mandatory
* Reference: NHI-$add-name-2
  * Purpose – Demonstrate that the: application can add a name to a patient record
  * Input values: Add a name to the selected NHI from list above with:* a family name only (no given name); and
* preferred set to false; and
* a name source (e.g. a birth certificate – ‘BRCT’)

  * Expected outcome: Input:*  A fictitious name with name parts described can be added to the patient record 
Output:*  The name is presented to the user with appropraite name parts populated 

  * Mandatory: mandatory
* Reference: NHI-$add-name-3
  * Purpose – Demonstrate that the: application can add a name to a patient record
  * Input values: Add a name to the selected NHI from list above with:* a given name only (no family name); and
* preferred set to false; and
* a name source (e.g. a birth certificate – ‘BRCT’)

  * Expected outcome: Input:*  A fictitious name with name parts described can be added to the patient record 
Output:*  The name is presented to the user with appropraite name parts populated 

  * Mandatory: mandatory
* Reference: NHI-$replace-name-1
  * Purpose – Demonstrate that the: application can replace a name with the patients preferred name
  * Input values: Replace a non-preferred name on a selected NHI from list above with a fictitious name that includes:* a family name; and
* a given name; and
* one or more other given name(s); and
* preferred set to true; and
* name use 'maiden'; and
* a name prefix; and
* a name source (e.g. a passport – ‘PPRT’)

  * Expected outcome: Input:*  A name can be replaced with a fictitious name 
Output:*  The preferred name that is displayed to the end user is the name that was selected in the operation with all name parts 
*  The replaced name is not returned to the user

  * Mandatory: mandatory
* Reference: NHI-$inactivate-name-1
  * Purpose – Demonstrate that the: application can inactivate a patients name
  * Input values: Inactivate an unverified, non-preferred name on a selected NHI from list above
  * Expected outcome: Input:*  Use $inactivate-name operation
Output:*  The selected name is made inctive and not returned to the user

  * Mandatory: mandatory
* Reference: NHI-$set-preferred-name-1
  * Purpose – Demonstrate that the: application can set the patients preferred name
  * Input values: * Use NHI number ZAY5581
* Do a Get Patient request to see active patient names
* Change the preferred name from the current name to another active name for the patient

  * Expected outcome: Input:*  An application can select a Patients preferred name from the active names list 
Output:*  The preferred name that is displayed to the end user is the name that was selected in the operation
*  The name is presented to the user with all name parts

  * Mandatory: mandatory
* Reference: NHI-update-name-error-1$add-name
  * Purpose – Demonstrate that the: application can display an error when the patient version is not current
  * Input values: * Requires two users to update a name on the provided patient record
* Use selected NHI number
* User one retrieves a patient record (to retrieve the current patient version) and starts adding a name to the record and then pauses
* User two retrieves the patient record and adds a fictitious name to the record
* User one then completes their update to the name and should receive the error message

  * Expected outcome: Output: EM02007 "Version number is incorrect"
  * Mandatory: mandatory
* Reference: NHI-update-name-error-2$add-name
  * Purpose – Demonstrate that the: application can display an error when the NHI provided is dormant
  * Input values: Attempt to add a fictitious name to NHI ZDV8901
  * Expected outcome: Output: EM02004 "The NHI Identifier provided is dormant. This record cannot be updated"
  * Mandatory: mandatory
* Reference: NHI-update-name-error-3$add-name
  * Purpose – Demonstrate that the: application can display an error when the patient has too many names
  * Input values: Attempt a add a fictitious name to NHI ZDJ6518* Given Names: John Charles
*  Family Name: Achilles

  * Expected outcome: Output: EM02105 "A Patient must not have more than 200 active names"
  * Mandatory: mandatory
* Reference: NHI-update-name-error-4$add-name
  * Purpose – Demonstrate that the: application can display an error when an attempt to add a name that exists as an active name for that patient
  * Input values: Attempt to add the name below to NHI ZKE9687* Given: RA
* Family: Lumbago

  * Expected outcome: Output: EM07222 "The Patient name already exists for this Patient"
  * Mandatory: mandatory
* Reference: NHI-update-name-error-5$add-name
  * Purpose – Demonstrate that the: application can display an error when adding a name that has been deleted from the patient record
  * Input values: Attempt to add the name below to ZAD0152*  Given Name: Amy
*  Family Name: Johnson

  * Expected outcome: Output: EM07008 - "The Patient name requested has been removed from the Patient record by NHI administration"
  * Mandatory: mandatory
* Reference: NHI-update-name-error-6$add-name
  * Purpose – Demonstrate that the: application can display an error when an invalid source is provided
  * Input values: Attempt to add a fictitious name to ZAA1578 with a registered source* source = BREG (Birth Register)

  * Expected outcome: Output: EM07229 - "The patient name can only be set to a registered value by an authorised agency"
  * Mandatory: mandatory
* Reference: NHI-update-name-error-7$add-name
  * Purpose – Demonstrate that the: application can display an error when a Babyof name is supplied with a use other than 'temp' and a source other than 'NPRF'
  * Input values: Attempt to add a fictitious babyof name to the patient ZDM4902*  Name use = nickname 
*  source = PPRT 

  * Expected outcome: Output: EM07225 - "name-use-extra is conditional on source = NPRF and name use = temp"
  * Mandatory: mandatory
* Reference: NHI-update-name-error-8$add-name
  * Purpose – Demonstrate that the: application can display an error when no given and family name is present
  * Input values: Attempt to add a fictitious name to the patient ZDM4902* Name use = nickname
* Source = PPRT
* Don't insert a family or given name

  * Expected outcome: Output: EM02101 - "A Patient name must contain either a given or family name, a preferred name flag and an information source"
  * Mandatory: mandatory
* Reference: NHI-update-name-error-9$add-name
  * Purpose – Demonstrate that the: application can display an error when no information source
  * Input values: Attempt to add a fictitious name to the patient ZDM4902* Name use = nickname
* Don't insert a information-source

  * Expected outcome: Output: EM02101 - "A Patient name must contain either a given or family name, a preferred name flag and an information source."
  * Mandatory: mandatory
* Reference: NHI-update-name-error-10$add-name
  * Purpose – Demonstrate that the: application can display an error when no preferred-name-flag
  * Input values: Attempt to add a fictitious name to the patient ZDM4902* Name use = nickname
* source = PPRT
* don't insert a preferred-name flag

  * Expected outcome: Output: EM02101 - "A Patient name must contain either a given or family name, a preferred name flag and an information source."
  * Mandatory: optional
* Reference: NHI-update-name-error-11$add-name
  * Purpose – Demonstrate that the: application can display an error when the given or family name contains special characters e.g. # @ %
  * Input values: Attempt to add a fictitious name (with special character) to the patient. ZAZ1913
  * Expected outcome: Output: "Invalid request body"
  * Mandatory: mandatory
* Reference: NHI-update-name-error-12$add-name
  * Purpose – Demonstrate that the: application can display an error when a given or family name begins with a number e.g. 1Smith
  * Input values: Attempt to add a fictitious name (with a number as the first character) to the patient ZCV7765
  * Expected outcome: Output: EM02107 "A Patient’s given and family name must start with a letter of the alphabet or an apostrophe"
  * Mandatory: mandatory
* Reference: NHI-update-name-error-13$add-name
  * Purpose – Demonstrate that the: application can display an error when a given or family name contains only whitespace/s
  * Input values: Attempt to add a name (containing only whitespace) to the patient ZDC0959
  * Expected outcome: Output: EM02110 "Each populated Patient Name field must contain at least one letter"
  * Mandatory: mandatory
* Reference: NHI-update-name-error-14$replace-name
  * Purpose – Demonstrate that the: application can display an error when an attempt to replace a verified name with an unverified
  * Input values: Attempt to replace the verified name to the patient ZKE9687, with a fictitious unverified name*  Source = NPRF 

  * Expected outcome: Output: EM0XXXX - "Cannot update a source to a lower level of proof"
  * Mandatory: mandatory
* Reference: NHI-update-name-error-15$inactivate-name
  * Purpose – Demonstrate that the: application can display an error when a registered name is modified
  * Input values: Attempt to inactivate the name with source BREG on patient ZKE9393 (Given Name: Jonathan Joseph. Family Name: Savage)
  * Expected outcome: Output: EM0XXXX "Information set to registered cannot be updated contact NHI administration"
  * Mandatory: mandatory
* Reference: NHI-update-name-error-16$inactivate-name
  * Purpose – Demonstrate that the: application can display an error when attempting to inactivate an 'inactive name'
  * Input values: Attempt to inactivate the name below on the Patient ZKF7027* Given Name: CJ 
* Family Name: Minit
* Set Id: "11" 
* Note: inactive names won't appear on the patient record so use set id to attempt to inactivate 

  * Expected outcome: Output: EM07223 "The 'Patient Name' is not active and cannot be updated"
  * Mandatory: optional
* Reference: NHI-update-name-error-17$inactivate-name
  * Purpose – Demonstrate that the: application can display an error when an attempt is made to inactivate a preferred name
  * Input values: Attempt to inactivate the preferred name below from Patient ZBJ3544* Given Name: Rosemary 
* Family Name: Alexander

  * Expected outcome: Output: EM02104 "An active Patient Preferred Name must not be deleted"
  * Mandatory: mandatory
* Reference: NHI-update-name-error-18$inactivate-name
  * Purpose – Demonstrate that the: application can display an error when an attempt is made to inactivate a name with a registered source
  * Input values: Attempt to inactivate the name below from Patient ZDW1872* Given Name: Michaela
* Family Name: Aldom

  * Expected outcome: Output: EM07230 "Patient Name has been validated by a public Agency, and cannot be updated"
  * Mandatory: mandatory

#### NHI Patient Maintain 'Core' tests

* Reference: NHI-update-core-1$update-identityEthnicity
  * Purpose – Demonstrate that the: application can correctly update ethnicity values on a patient's record
  * Input values: Update the set of ethnicity information based on the responses to the standard ethnicity collection question for the selected NHI number![](update-core-1.png)
  * Expected outcome: Output:*  The application can update the patients ethnicity information
Patient’s ethnicity after update should be:*  11111 
*  21111 
*  31111

  * Mandatory: mandatory
* Reference: NHI-update-core-2$update-identityEthnicity
  * Purpose – Demonstrate that the: application can correctly update ethnicity values on a patient's record
  * Input values: Update the set of ethnicity information based on the responses to the standard ethnicity collection question for the selected NHI number![](update-core-2.png)
  * Expected outcome: Output:*  The application can update the patients ethnicity information 
Patient’s ethnicity after update should be:*  11111 
*  34111 
*  51120 
*  4211 

  * Mandatory: mandatory
* Reference: NHI-update-core-3$update-identityEthnicity
  * Purpose – Demonstrate that the: application can correctly update an unidentifiable response to the standard ethnicity collection question.
  * Input values: Update the set of ethnicity information based on the responses to the standard ethnicity collection question for the selected NHI number![](update-core-3.png)
  * Expected outcome: Output:*  The application can update the patients ethnicity information 
Patient’s ethnicity after update should be:*  97777 

  * Mandatory: mandatory
* Reference: NHI-update-core-4$update-identityEthnicity
  * Purpose – Demonstrate that the: application can correctly update ethnicity values on a patient's record
  * Input values: Update the set of ethnicity information based on the responses to the standard ethnicity collection question for the selected NHI number![](update-core-4.png)
  * Expected outcome: Output:*  The application can update the patients ethnicity information 
Patient’s ethnicity after update should be:*  12211
*  12920

  * Mandatory: mandatory
* Reference: NHI-update-core-5$update-identityEthnicity
  * Purpose – Demonstrate that the: application can correctly update ethnicity values on a patient's record
  * Input values: Update the set of ethnicity information based on the responses to the standard ethnicity collection question for the selected NHI number![](update-core-5.png)
  * Expected outcome: Output:*  The application can update the patients ethnicity information 
Patient’s ethnicity after update should be:*  61118 

  * Mandatory: mandatory
* Reference: NHI-update-core-6$update-identity-errorEthnicity
  * Purpose – Demonstrate that the: application can display an error when ethnicity information invalidcontains multiple residual codes (9xxxx)
  * Input values: Update the ethnicity information for Patient: ZAA0261Ethnicities to use:*  97777 (response unidentifiable) 
*  and 99999 (not stated)

  * Expected outcome: Output: EM02301 - "A Patient must have at least one valid ethnicity code, only one instance of each selected ethnicity, and no more than one ‘unspecified’ ethnicity code"
  * Mandatory: mandatory
* Reference: NHI-update-core-7$update-identity-errorEthnicity
  * Purpose – Demonstrate that the: application can display an error when ethnicity information invalidset of supplied ethnicities that includes a duplicate ethnicity
  * Input values: Update the ethnicity information for Patient: ZAA1063Ethnicities to use:* 32100 (Cook Islands Maori) and,
* 12948 (South African) and,
* 32100 (Cook Islands Maori)

  * Expected outcome: Output: EM02301 - "A Patient must have at least one valid ethnicity code, only one instance of each selected ethnicity, and no more than one ‘unspecified’ ethnicity code"
  * Mandatory: mandatory
* Reference: NHI-update-core-8$update-identityGender
  * Purpose – Demonstrate that the: application can correctly update a gender value on a patient's record
  * Input values: Update the gender for Patient: ZAA1063*  Do a Get patient request 
*  Change gender from current gender to one of the four acceptable gender codes

  * Expected outcome: Output:*  Patients gender coded updated and presented to user 

  * Mandatory: mandatory
* Reference: NHI-update-core-9$update-identityGender
  * Purpose – Demonstrate that the: application can correctly update the gender value and gender-original-text on a patient record
  * Input values: Update the gender for Patient: ZAA1063* Do a Get patient request 
* Change gender from current gender to one of the four acceptable gender codes, include an original text response that a patient might submit 

  * Expected outcome: Output:* Patients gender coded and gender original text updated and presented to user

  * Mandatory: mandatory
* Reference: NHI-update-core-10$update-identity-errorGender
  * Purpose – Demonstrate that the: application can display an error when gender-original-text updated without a gender value
  * Input values: Update the gender-original-text for Patient: ZAA1063
  * Expected outcome: Output: EM07201 - "Is a required field - Patient.gender"
  * Mandatory: mandatory
* Reference: NHI-update-core-11$update-eligibility
  * Purpose – Demonstrate that the: application can correctly update citizenship on a patient's identity record
  * Input values: Update the citizenship for Patient: ZAA1063 from current value to*  Status - unknown or no 
*  source - NPRF 

  * Expected outcome: Output:* Citizenship is updated on the patient record 
* The patient record clearly shows citizenship status and source 

  * Mandatory: mandatory
* Reference: NHI-update-core-12$update-eligibility
  * Purpose – Demonstrate that the: application can correctly update citizenship on a patient's identity record
  * Input values: Update the citizenship for Patient: ZKF6683*  Citizenship = yes 
*  Source = change to another verified source

  * Expected outcome: Output:*  Citizenship is updated on the patient record 
* The patient record clearly shows citizenship status and source 

  * Mandatory: mandatory
* Reference: NHI-update-eligibility-error-1
  * Purpose – Demonstrate that the: application can display an error when attempting to add a registered source for citizenship
  * Input values: Attempt replace citizenship for Patient: ZKF6683*  Citizenship = yes 
*  Attempt to add source = DIA 

  * Expected outcome: Output: EM07229 - The citizenship information source can only be set to a registered value by an authorised agency"
  * Mandatory: mandatory
* Reference: NHI-update-eligibility-error-2
  * Purpose – Demonstrate that the: application can display an error when an attempt to replace a verified to unverified source for citizenship
  * Input values: Attempt replace citizenship for Patient: ZKF6683*  Citizenship = yes 
*  Attempt to add source = NPRF 

  * Expected outcome: Output: EM0XXXX - "Cannot update a source to a lower level of proof"
  * Mandatory: mandatory
* Reference: NHI-update-eligibility-error-3
  * Purpose – Demonstrate that the: application can display an error when an attempt to replace a citizenship that has a registered source
  * Input values: Attempt to replace citizenship on NHI ZKF6691*  Citizenship = yes 
*  Attempt to add a verified or non-verified source 

  * Expected outcome: Output: "EM07230 - The patient's citizenship has been validated by a public Agency, and cannot be updated"
  * Mandatory: mandatory

