# NotValidatedAddressReason - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NotValidatedAddressReason**

## Extension: NotValidatedAddressReason 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org.nz/fhir/StructureDefinition/not-validated-address-reason | *Version*:1.6.5 |
| Active as of 2026-02-09 | *Computable Name*:NotValidatedAddressReason |

The reason why the address has not been validated

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [NHI Address](StructureDefinition-NhiAddress.md)
* Examples for this Extension: [Patient/ZAT2348](Patient-ZAT2348.md), [Patient/ZAT2496](Patient-ZAT2496.md), [Patient/ZJM9397](Patient-ZJM9397.md) and [Patient/ZKC4633](Patient-ZKC4633.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.org.nz.fhir.ig.nhi|current/StructureDefinition/not-validated-address-reason)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-not-validated-address-reason.csv), [Excel](StructureDefinition-not-validated-address-reason.xlsx), [Schematron](StructureDefinition-not-validated-address-reason.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "not-validated-address-reason",
  "url" : "http://hl7.org.nz/fhir/StructureDefinition/not-validated-address-reason",
  "version" : "1.6.5",
  "name" : "NotValidatedAddressReason",
  "status" : "active",
  "date" : "2026-02-09T22:59:55+00:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "The reason why the address has not been validated",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Address"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "definition" : "The reason why the address has not been validated"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org.nz/fhir/StructureDefinition/not-validated-address-reason"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://nzhts.digital.health.nz/fhir/ValueSet/nhi-address-not-validated-reason-code"
        }
      }
    ]
  }
}

```
