# NhiContactPointExtra - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NhiContactPointExtra**

## Extension: NhiContactPointExtra 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org.nz/fhir/ig/nhi/StructureDefinition/nhi-contact-point-extra | *Version*:1.6.5 |
| Active as of 2026-02-09 | *Computable Name*:NhiContactPointExtra |

**Context of Use**

**Usage info**

**Usages:**

* This Extension is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.org.nz.fhir.ig.nhi|current/StructureDefinition/nhi-contact-point-extra)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-nhi-contact-point-extra.csv), [Excel](StructureDefinition-nhi-contact-point-extra.xlsx), [Schematron](StructureDefinition-nhi-contact-point-extra.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "nhi-contact-point-extra",
  "url" : "http://hl7.org.nz/fhir/ig/nhi/StructureDefinition/nhi-contact-point-extra",
  "version" : "1.6.5",
  "name" : "NhiContactPointExtra",
  "status" : "active",
  "date" : "2026-02-09T22:59:55+00:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Telecom"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension"
      },
      {
        "id" : "Extension.extension:IsVerified",
        "path" : "Extension.extension",
        "sliceName" : "IsVerified",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:IsVerified.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "IsVerified"
      },
      {
        "id" : "Extension.extension:IsShared",
        "path" : "Extension.extension",
        "sliceName" : "IsShared",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:IsShared.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "IsShared"
      },
      {
        "id" : "Extension.extension:IsPrivate",
        "path" : "Extension.extension",
        "sliceName" : "IsPrivate",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:IsPrivate.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "IsPrivate"
      },
      {
        "id" : "Extension.extension:Context",
        "path" : "Extension.extension",
        "sliceName" : "Context",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:Context.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "Context"
      },
      {
        "id" : "Extension.extension:LastUpdatedDate",
        "path" : "Extension.extension",
        "sliceName" : "LastUpdatedDate",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:LastUpdatedDate.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "LastUpdatedDate"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org.nz/fhir/ig/nhi/StructureDefinition/nhi-contact-point-extra"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
