# NameUseExtra - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NameUseExtra**

## Extension: NameUseExtra 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org.nz/fhir/StructureDefinition/name-use-extra | *Version*:1.6.5 |
| Active as of 2026-02-09 | *Computable Name*:NameUseExtra |

Additional name use codes for NHI names

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [NHI Patient](StructureDefinition-NhiPatient.md)
* Examples for this Extension: [Patient/ZKC4633](Patient-ZKC4633.md) and [Patient/create3-errors](Patient-create3-errors.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.org.nz.fhir.ig.nhi|current/StructureDefinition/name-use-extra)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-name-use-extra.csv), [Excel](StructureDefinition-name-use-extra.xlsx), [Schematron](StructureDefinition-name-use-extra.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "name-use-extra",
  "url" : "http://hl7.org.nz/fhir/StructureDefinition/name-use-extra",
  "version" : "1.6.5",
  "name" : "NameUseExtra",
  "status" : "active",
  "date" : "2026-02-09T22:59:55+00:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "Additional name use codes for NHI names",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "HumanName"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "definition" : "Additional name use codes for NHI names"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org.nz/fhir/StructureDefinition/name-use-extra"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nzhts.digital.health.nz/fhir/ValueSet/nhi-name-use-extra-code"
        }
      }
    ]
  }
}

```
