# OriginalText - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **OriginalText**

## Extension: OriginalText 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org.nz/fhir/StructureDefinition/gender-original-text | *Version*:1.6.5 |
| Active as of 2026-02-09 | *Computable Name*:OriginalText |

The uncoded original text that was provided by the patient as their Gender

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [NHI Patient](StructureDefinition-NhiPatient.md)
* Examples for this Extension: [Patient/ZJM9397](Patient-ZJM9397.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.org.nz.fhir.ig.nhi|current/StructureDefinition/gender-original-text)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-gender-original-text.csv), [Excel](StructureDefinition-gender-original-text.xlsx), [Schematron](StructureDefinition-gender-original-text.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "gender-original-text",
  "url" : "http://hl7.org.nz/fhir/StructureDefinition/gender-original-text",
  "version" : "1.6.5",
  "name" : "OriginalText",
  "status" : "active",
  "date" : "2026-02-09T22:59:55+00:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "The uncoded original text that was provided by the patient as their Gender",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Patient.gender"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "definition" : "The uncoded original text that was provided by the patient as their Gender"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org.nz/fhir/StructureDefinition/gender-original-text"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
