# BirthPlace - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BirthPlace**

## Extension: BirthPlace 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org.nz/fhir/StructureDefinition/birth-place | *Version*:1.6.5 |
| Active as of 2026-02-09 | *Computable Name*:BirthPlace |

The country where the person was born

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [NHI Patient](StructureDefinition-NhiPatient.md)
* Examples for this Extension: [Parameters/Match](Parameters-Match.md), [Patient/ZAT2496](Patient-ZAT2496.md), [Patient/ZJM9397](Patient-ZJM9397.md), [Patient/create1](Patient-create1.md)... Show 2 more, [Patient/create2-error-](Patient-create2-error-.md) and [Patient/create3-errors](Patient-create3-errors.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.org.nz.fhir.ig.nhi|current/StructureDefinition/birth-place)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-birth-place.csv), [Excel](StructureDefinition-birth-place.xlsx), [Schematron](StructureDefinition-birth-place.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "birth-place",
  "url" : "http://hl7.org.nz/fhir/StructureDefinition/birth-place",
  "version" : "1.6.5",
  "name" : "BirthPlace",
  "status" : "active",
  "date" : "2026-02-09T22:59:55+00:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "The country where the person was born",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Patient"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "definition" : "The country where the person was born"
      },
      {
        "id" : "Extension.extension:country",
        "path" : "Extension.extension",
        "sliceName" : "country",
        "definition" : "The birth country.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:country.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:country.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "country"
      },
      {
        "id" : "Extension.extension:country.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nzhts.digital.health.nz/fhir/ValueSet/country-code"
        }
      },
      {
        "id" : "Extension.extension:place-of-birth",
        "path" : "Extension.extension",
        "sliceName" : "place-of-birth",
        "definition" : "No description",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:place-of-birth.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:place-of-birth.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "place-of-birth"
      },
      {
        "id" : "Extension.extension:place-of-birth.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Extension.extension:source",
        "path" : "Extension.extension",
        "sliceName" : "source",
        "definition" : "The source of information concerning the country of birth",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:source.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:source.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "source"
      },
      {
        "id" : "Extension.extension:source.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nzhts.digital.health.nz/fhir/ValueSet/country-of-birth-source-code"
        }
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org.nz/fhir/StructureDefinition/birth-place"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
