# NHI ContactPoint - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NHI ContactPoint**

## Data Type Profile: NHI ContactPoint 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org.nz/fhir/StructureDefinition/nhi-contact-point | *Version*:1.6.5 |
| Active as of 2026-02-09 | *Computable Name*:NhiContactPoint |

 
Additional attributes for managing patient contact information 

**Usages:**

* Use this DataType Profile: [NHI Patient](StructureDefinition-NhiPatient.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.org.nz.fhir.ig.nhi|current/StructureDefinition/NhiContactPoint)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-NhiContactPoint.csv), [Excel](StructureDefinition-NhiContactPoint.xlsx), [Schematron](StructureDefinition-NhiContactPoint.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "NhiContactPoint",
  "url" : "http://hl7.org.nz/fhir/StructureDefinition/nhi-contact-point",
  "version" : "1.6.5",
  "name" : "NhiContactPoint",
  "title" : "NHI ContactPoint",
  "status" : "active",
  "date" : "2026-02-09T22:59:55+00:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "Additional attributes for managing patient contact information",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "ContactPoint",
  "baseDefinition" : "http://hl7.org.nz/fhir/StructureDefinition/NzContactpoint",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ContactPoint.extension:cp-purpose",
        "path" : "ContactPoint.extension",
        "sliceName" : "cp-purpose",
        "max" : "0"
      },
      {
        "id" : "ContactPoint.extension:isVerified",
        "path" : "ContactPoint.extension",
        "sliceName" : "isVerified",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org.nz/fhir/StructureDefinition/isVerified"]
          }
        ]
      },
      {
        "id" : "ContactPoint.extension:isShared",
        "path" : "ContactPoint.extension",
        "sliceName" : "isShared",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org.nz/fhir/StructureDefinition/isShared"]
          }
        ]
      },
      {
        "id" : "ContactPoint.extension:isPrivate",
        "path" : "ContactPoint.extension",
        "sliceName" : "isPrivate",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org.nz/fhir/StructureDefinition/isPrivate"]
          }
        ]
      },
      {
        "id" : "ContactPoint.extension:context",
        "path" : "ContactPoint.extension",
        "sliceName" : "context",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org.nz/fhir/StructureDefinition/context"]
          }
        ]
      },
      {
        "id" : "ContactPoint.extension:lastUpdatedDate",
        "path" : "ContactPoint.extension",
        "sliceName" : "lastUpdatedDate",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org.nz/fhir/StructureDefinition/lastUpdatedDate"]
          }
        ]
      }
    ]
  }
}

```
