# NHI Address - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NHI Address**

## Data Type Profile: NHI Address 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org.nz/fhir/StructureDefinition/NhiAddress | *Version*:1.6.5 |
| Active as of 2026-02-09 | *Computable Name*:NhiAddress |

 
Adds additional, NHI specific extensions 

**Usages:**

* Use this DataType Profile: [NHI Patient](StructureDefinition-NhiPatient.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.org.nz.fhir.ig.nhi|current/StructureDefinition/NhiAddress)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-NhiAddress.csv), [Excel](StructureDefinition-NhiAddress.xlsx), [Schematron](StructureDefinition-NhiAddress.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "NhiAddress",
  "url" : "http://hl7.org.nz/fhir/StructureDefinition/NhiAddress",
  "version" : "1.6.5",
  "name" : "NhiAddress",
  "title" : "NHI Address",
  "status" : "active",
  "date" : "2026-02-09T22:59:55+00:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "Adds additional, NHI specific extensions",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "vcard",
      "uri" : "http://w3.org/vcard",
      "name" : "vCard Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Address",
  "baseDefinition" : "http://hl7.org.nz/fhir/StructureDefinition/NzAddress",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Address.extension:notValidatedAddressReason",
        "path" : "Address.extension",
        "sliceName" : "notValidatedAddressReason",
        "short" : "The reason an address was not validated",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org.nz/fhir/StructureDefinition/not-validated-address-reason"
            ]
          }
        ]
      },
      {
        "id" : "Address.extension:nz-address-id",
        "path" : "Address.extension",
        "sliceName" : "nz-address-id",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org.nz/fhir/StructureDefinition/nz-address-id"]
          }
        ]
      },
      {
        "id" : "Address.extension:nz-address-derived",
        "path" : "Address.extension",
        "sliceName" : "nz-address-derived",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org.nz/fhir/StructureDefinition/nhi-address-derived"
            ]
          }
        ]
      },
      {
        "id" : "Address.use",
        "path" : "Address.use",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nzhts.digital.health.nz/fhir/ValueSet/nhiaddressUse"
        }
      },
      {
        "id" : "Address.type",
        "path" : "Address.type",
        "short" : "postal | physical",
        "definition" : "Distinguishes between Residential (physical) and Postal (mailing) addresses",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nzhts.digital.health.nz/fhir/ValueSet/addressType"
        }
      },
      {
        "id" : "Address.district",
        "path" : "Address.district",
        "max" : "0"
      },
      {
        "id" : "Address.state",
        "path" : "Address.state",
        "max" : "0"
      },
      {
        "id" : "Address.country",
        "path" : "Address.country",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nzhts.digital.health.nz/fhir/ValueSet/country-code"
        }
      },
      {
        "id" : "Address.period",
        "path" : "Address.period",
        "max" : "0"
      }
    ]
  }
}

```
