# Create NHI Patient - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Create NHI Patient**

## Resource Profile: Create NHI Patient 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org.nz/fhir/StructureDefinition/CreateNhiPatient | *Version*:1.6.5 |
| Active as of 2026-02-09 | *Computable Name*:CreateNhiPatient |

 
The information to be supplied when requesting that a new Patient resource be created in the NHI. 

 
Describe information to be supplied when requesting that a new Patient resource be created in the NHI 

**Usages:**

* Examples for this Profile: [Patient/create1](Patient-create1.md), [Patient/create2-error-](Patient-create2-error-.md) and [Patient/create3-errors](Patient-create3-errors.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.org.nz.fhir.ig.nhi|current/StructureDefinition/CreateNhiPatient)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-CreateNhiPatient.csv), [Excel](StructureDefinition-CreateNhiPatient.xlsx), [Schematron](StructureDefinition-CreateNhiPatient.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CreateNhiPatient",
  "url" : "http://hl7.org.nz/fhir/StructureDefinition/CreateNhiPatient",
  "version" : "1.6.5",
  "name" : "CreateNhiPatient",
  "title" : "Create NHI Patient",
  "status" : "active",
  "date" : "2026-02-09T22:59:55+00:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "The information to be supplied when requesting that a new  Patient resource be created in the NHI.",
  "purpose" : "Describe information to be supplied when requesting that a new  Patient resource be created in the NHI",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://hl7.org.nz/fhir/StructureDefinition/NhiPatient",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient",
        "constraint" : [
          {
            "key" : "EM02106",
            "severity" : "error",
            "human" : "A Patient must have an active Preferred Name",
            "expression" : "Patient.name.extension.where((url = 'http://hl7.org/fhir/StructureDefinition/iso21090-preferred') and (valueBoolean=true)).count()=1",
            "source" : "http://hl7.org.nz/fhir/StructureDefinition/CreateNhiPatient"
          },
          {
            "key" : "EM02201",
            "severity" : "error",
            "human" : "A Patient must have a primary residential address",
            "expression" : "Patient.address.where(  (use = 'home') and (type = 'physical')).count()=1",
            "source" : "http://hl7.org.nz/fhir/StructureDefinition/CreateNhiPatient"
          },
          {
            "key" : "EM02101",
            "severity" : "error",
            "human" : "A Patient name must contain either a given or family name",
            "expression" : "Patient.name.all(given.exists() and family.exists())",
            "source" : "http://hl7.org.nz/fhir/StructureDefinition/CreateNhiPatient"
          },
          {
            "key" : "EM07225",
            "severity" : "error",
            "human" : "If name-use-extra is supplied name-use must be temp, and source NPRF",
            "expression" : "name.where(use='temp').exists() implies (extension.where((url='http://hl7.org.nz/fhir/StructureDefinition/information-source') and (valueCodeableConcept.coding.code ='NPRF')).exists())",
            "source" : "http://hl7.org.nz/fhir/StructureDefinition/CreateNhiPatient"
          },
          {
            "key" : "EM07212",
            "severity" : "error",
            "human" : "birthdate must be after 1 January 1900, and not a future date",
            "expression" : "(birthDate > @1900-01-01) and (birthDate < now())",
            "source" : "http://hl7.org.nz/fhir/StructureDefinition/CreateNhiPatient"
          },
          {
            "key" : "EM07212-1",
            "severity" : "error",
            "human" : "Date of Death cannot be a future date",
            "expression" : "deceasedDateTime < now()",
            "source" : "http://hl7.org.nz/fhir/StructureDefinition/CreateNhiPatient"
          },
          {
            "key" : "EM07215",
            "severity" : "error",
            "human" : "Date of Death must be greater than, or equal to Date of Birth",
            "expression" : "deceasedDateTime >= birthDate",
            "source" : "http://hl7.org.nz/fhir/StructureDefinition/CreateNhiPatient"
          }
        ]
      },
      {
        "id" : "Patient.implicitRules",
        "path" : "Patient.implicitRules",
        "max" : "0"
      },
      {
        "id" : "Patient.language",
        "path" : "Patient.language",
        "max" : "0"
      },
      {
        "id" : "Patient.contained:GP",
        "path" : "Patient.contained",
        "sliceName" : "GP",
        "max" : "0"
      },
      {
        "id" : "Patient.extension",
        "path" : "Patient.extension",
        "min" : 2
      },
      {
        "id" : "Patient.extension:ethnicity",
        "path" : "Patient.extension",
        "sliceName" : "ethnicity",
        "min" : 1
      },
      {
        "id" : "Patient.extension:nzCitizen",
        "path" : "Patient.extension",
        "sliceName" : "nzCitizen",
        "min" : 1
      },
      {
        "id" : "Patient.extension:nzCitizen.extension",
        "path" : "Patient.extension.extension",
        "min" : 2
      },
      {
        "id" : "Patient.extension:nzCitizen.extension:status",
        "path" : "Patient.extension.extension",
        "sliceName" : "status",
        "min" : 1
      },
      {
        "id" : "Patient.extension:nzCitizen.extension:status.value[x]",
        "path" : "Patient.extension.extension.value[x]",
        "min" : 1
      },
      {
        "id" : "Patient.extension:nzCitizen.extension:status.value[x]:valueCodeableConcept",
        "path" : "Patient.extension.extension.value[x]",
        "sliceName" : "valueCodeableConcept",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "Patient.extension:nzCitizen.extension:source",
        "path" : "Patient.extension.extension",
        "sliceName" : "source",
        "min" : 1
      },
      {
        "id" : "Patient.extension:nzCitizen.extension:source.value[x]",
        "path" : "Patient.extension.extension.value[x]",
        "min" : 1
      },
      {
        "id" : "Patient.extension:nzCitizen.extension:source.value[x]:valueCodeableConcept",
        "path" : "Patient.extension.extension.value[x]",
        "sliceName" : "valueCodeableConcept",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "Patient.extension:dhb",
        "path" : "Patient.extension",
        "sliceName" : "dhb",
        "max" : "0"
      },
      {
        "id" : "Patient.extension:birthPlace",
        "path" : "Patient.extension",
        "sliceName" : "birthPlace"
      },
      {
        "id" : "Patient.extension:birthPlace.extension",
        "path" : "Patient.extension.extension",
        "min" : 2
      },
      {
        "id" : "Patient.extension:birthPlace.extension:country",
        "path" : "Patient.extension.extension",
        "sliceName" : "country",
        "min" : 1
      },
      {
        "id" : "Patient.extension:birthPlace.extension:source",
        "path" : "Patient.extension.extension",
        "sliceName" : "source",
        "min" : 1
      },
      {
        "id" : "Patient.extension:birthPlace.extension:source.value[x]",
        "path" : "Patient.extension.extension.value[x]",
        "min" : 1
      },
      {
        "id" : "Patient.identifier:NHI",
        "path" : "Patient.identifier",
        "sliceName" : "NHI",
        "max" : "0"
      },
      {
        "id" : "Patient.name",
        "path" : "Patient.name",
        "min" : 1,
        "max" : "1",
        "constraint" : [
          {
            "key" : "EM07225",
            "severity" : "error",
            "human" : "If name-use-extra is supplied name-use must be temp, and source NPRF",
            "expression" : "name.where(use='temp').exists() implies (extension.where((url='http://hl7.org.nz/fhir/StructureDefinition/information-source') and (valueCodeableConcept.coding.code ='NPRF')).exists())",
            "source" : "http://hl7.org.nz/fhir/StructureDefinition/CreateNhiPatient"
          }
        ]
      },
      {
        "id" : "Patient.name.extension",
        "path" : "Patient.name.extension",
        "min" : 2
      },
      {
        "id" : "Patient.name.extension:information-source",
        "path" : "Patient.name.extension",
        "sliceName" : "information-source",
        "min" : 1
      },
      {
        "id" : "Patient.name.extension:information-source.value[x]",
        "path" : "Patient.name.extension.value[x]",
        "min" : 1
      },
      {
        "id" : "Patient.name.extension:information-source.value[x]:valueCodeableConcept",
        "path" : "Patient.name.extension.value[x]",
        "sliceName" : "valueCodeableConcept",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "Patient.name.prefix",
        "path" : "Patient.name.prefix",
        "max" : "1"
      },
      {
        "id" : "Patient.telecom",
        "path" : "Patient.telecom",
        "max" : "0"
      },
      {
        "id" : "Patient.gender",
        "path" : "Patient.gender",
        "min" : 1
      },
      {
        "id" : "Patient.birthDate",
        "path" : "Patient.birthDate",
        "min" : 1
      },
      {
        "id" : "Patient.birthDate.extension",
        "path" : "Patient.birthDate.extension",
        "min" : 1
      },
      {
        "id" : "Patient.birthDate.extension:information-source",
        "path" : "Patient.birthDate.extension",
        "sliceName" : "information-source",
        "min" : 1
      },
      {
        "id" : "Patient.birthDate.extension:information-source.value[x]",
        "path" : "Patient.birthDate.extension.value[x]",
        "min" : 1
      },
      {
        "id" : "Patient.birthDate.extension:information-source.value[x]:valueCodeableConcept",
        "path" : "Patient.birthDate.extension.value[x]",
        "sliceName" : "valueCodeableConcept",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "Patient.deceased[x].extension",
        "path" : "Patient.deceased[x].extension",
        "min" : 1
      },
      {
        "id" : "Patient.deceased[x].extension:information-source",
        "path" : "Patient.deceased[x].extension",
        "sliceName" : "information-source",
        "min" : 1
      },
      {
        "id" : "Patient.deceased[x].extension:information-source.value[x]",
        "path" : "Patient.deceased[x].extension.value[x]",
        "min" : 1
      },
      {
        "id" : "Patient.deceased[x].extension:information-source.value[x]:valueCodeableConcept",
        "path" : "Patient.deceased[x].extension.value[x]",
        "sliceName" : "valueCodeableConcept",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "Patient.address",
        "path" : "Patient.address",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Patient.address.use",
        "path" : "Patient.address.use",
        "min" : 1
      },
      {
        "id" : "Patient.address.line",
        "path" : "Patient.address.line",
        "max" : "2"
      },
      {
        "id" : "Patient.generalPractitioner",
        "path" : "Patient.generalPractitioner",
        "max" : "0"
      }
    ]
  }
}

```
