# context - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **context**

## Extension: context 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org.nz/fhir/StructureDefinition/context | *Version*:1.6.5 |
| Active as of 2026-02-09 | *Computable Name*:Context |

Additional information about the context of use of this contact

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [NHI ContactPoint](StructureDefinition-NhiContactPoint.md)
* Examples for this Extension: [Patient/ZKC4633](Patient-ZKC4633.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.org.nz.fhir.ig.nhi|current/StructureDefinition/Context)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Context.csv), [Excel](StructureDefinition-Context.xlsx), [Schematron](StructureDefinition-Context.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Context",
  "url" : "http://hl7.org.nz/fhir/StructureDefinition/context",
  "version" : "1.6.5",
  "name" : "Context",
  "title" : "context",
  "status" : "active",
  "date" : "2026-02-09T22:59:55+00:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "Additional information about the context of use of this contact",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Element"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "context",
        "definition" : "Additional information about the context of use of this contact"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org.nz/fhir/StructureDefinition/context"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
