# ZAT2348 - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ZAT2348**

## Example Patient: ZAT2348

version: 3368229

Profile: [NHI Patient](StructureDefinition-NhiPatient.md)

Laura Smith-Martin Female, DoB: 1970-07-14 ( https://standards.digital.health.nz/ns/nhi-id#NHI#ZAT2348 (use: official, ))

-------

| | |
| :--- | :--- |
| Deceased: | 2016-10-18 |
| Contact Detail | NO FIXED ABODE (home) |
| Links: | * General Practitioner: [PractitionerRole: period = 2019-10-30 00:00:00+1300 --> 2022-10-30 00:00:00+1300](#hcZAT2348/20006579)
 |
| NZ Citizenship: | * source: Passport
* status: No
 |
| [NZ Ethnicity](https://fhir.org.nz/ig/base/StructureDefinition-nz-ethnicity.html) | * New Zealand European
* Spanish
 |

-------

**Contained Resource**

-------

**period**: 2019-10-30 00:00:00+1300 --> 2022-10-30 00:00:00+1300

**organization**: [Organization/G08550-C](Organization/G08550-C)



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "ZAT2348",
  "meta" : {
    "versionId" : "3368229",
    "profile" : ["http://hl7.org.nz/fhir/StructureDefinition/NhiPatient"]
  },
  "contained" : [
    {
      "resourceType" : "PractitionerRole",
      "id" : "20006579",
      "period" : {
        "start" : "2019-10-30T00:00:00+13:00",
        "end" : "2022-10-30T00:00:00+13:00"
      },
      "organization" : {
        "reference" : "Organization/G08550-C"
      }
    }
  ],
  "extension" : [
    {
      "url" : "http://hl7.org.nz/fhir/StructureDefinition/nz-ethnicity",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://standards.digital.health.nz/ns/ethnic-group-level-4-code",
            "version" : "2.0",
            "code" : "11111",
            "display" : "New Zealand European"
          }
        ],
        "text" : "New Zealand European"
      }
    },
    {
      "url" : "http://hl7.org.nz/fhir/StructureDefinition/nz-ethnicity",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://standards.digital.health.nz/ns/ethnic-group-level-4-code",
            "version" : "2.0",
            "code" : "12939",
            "display" : "Spanish"
          }
        ],
        "text" : "Spanish"
      }
    },
    {
      "extension" : [
        {
          "url" : "source",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/information-source-code",
                "version" : "1.0.0",
                "code" : "PPRT",
                "display" : "Passport"
              }
            ],
            "text" : "Passport"
          }
        },
        {
          "url" : "status",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/nz-citizenship-status-code",
                "version" : "1.1.0",
                "code" : "no",
                "display" : "No"
              }
            ],
            "text" : "No"
          }
        }
      ],
      "url" : "http://hl7.org.nz/fhir/StructureDefinition/nz-citizenship"
    }
  ],
  "identifier" : [
    {
      "use" : "official",
      "system" : "https://standards.digital.health.nz/ns/nhi-id",
      "value" : "ZAT2348",
      "assigner" : {
        "reference" : "Organization/G00001-G"
      }
    }
  ],
  "name" : [
    {
      "id" : "11",
      "extension" : [
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/information-source",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/information-source-code",
                "version" : "1.0.0",
                "code" : "NPRF",
                "display" : "Proof not Sighted"
              }
            ],
            "text" : "Proof not Sighted"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-preferred",
          "valueBoolean" : false
        }
      ],
      "family" : "Smith-Martin",
      "given" : ["Laura"],
      "prefix" : ["MS"]
    },
    {
      "id" : "13",
      "extension" : [
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/information-source",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/information-source-code",
                "version" : "1.0.0",
                "code" : "NPRF",
                "display" : "Proof not Sighted"
              }
            ],
            "text" : "Proof not Sighted"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-preferred",
          "valueBoolean" : false
        }
      ],
      "family" : "Othername",
      "given" : ["Rose"],
      "prefix" : ["MRS"]
    },
    {
      "id" : "18",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-preferred",
          "valueBoolean" : true
        }
      ],
      "family" : "MARTIN",
      "given" : ["LAURA", "ROSE"]
    },
    {
      "id" : "22",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-preferred",
          "valueBoolean" : false
        }
      ],
      "family" : "Moh",
      "given" : ["Petal"]
    }
  ],
  "gender" : "female",
  "birthDate" : "1970-07-14",
  "_birthDate" : {
    "extension" : [
      {
        "url" : "http://hl7.org.nz/fhir/StructureDefinition/information-source",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://standards.digital.health.nz/ns/information-source-code",
              "version" : "1.0.0",
              "code" : "NPRF",
              "display" : "Proof not Sighted"
            }
          ],
          "text" : "Proof not Sighted"
        }
      }
    ]
  },
  "deceasedDateTime" : "2016-10-18",
  "_deceasedDateTime" : {
    "extension" : [
      {
        "url" : "http://hl7.org.nz/fhir/StructureDefinition/information-source",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://standards.digital.health.nz/ns/information-source-code",
              "version" : "1.0.0",
              "code" : "DREG",
              "display" : "Death Register"
            }
          ],
          "text" : "Death Register"
        }
      }
    ]
  },
  "address" : [
    {
      "id" : "27",
      "extension" : [
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/not-validated-address-reason",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/address-not-validated-reason-code",
                "version" : "1.1",
                "code" : "NFAB",
                "display" : "No Fixed Abode"
              }
            ],
            "text" : "No Fixed Abode"
          }
        },
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/domicile-code",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/domicile-code",
                "code" : "D091",
                "display" : "Capital and Coast District Health Board"
              }
            ],
            "text" : "Capital and Coast District Health Board"
          }
        }
      ],
      "use" : "home",
      "type" : "physical",
      "line" : ["NO FIXED ABODE"]
    }
  ],
  "generalPractitioner" : [
    {
      "reference" : "#20006579"
    }
  ]
}

```
