# Update patient's self-identified demographic information - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Update patient's self-identified demographic information**

## OperationDefinition: Update patient's self-identified demographic information 

| | |
| :--- | :--- |
| *Official URL*:https://nhi-ig.hip.digital.health.nz/OperationDefinition/update-identity | *Version*:1.6.5 |
| Draft as of 2023-06-12 | *Computable Name*:Update Identity |

 
Update patient's self-identified demographic information. 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "Patient-update-identity",
  "url" : "https://nhi-ig.hip.digital.health.nz/OperationDefinition/update-identity",
  "version" : "1.6.5",
  "name" : "Update Identity",
  "title" : "Update patient's self-identified demographic information",
  "status" : "draft",
  "kind" : "operation",
  "experimental" : false,
  "date" : "2023-06-12T12:47:40+10:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "Update patient's  self-identified demographic information.",
  "affectsState" : true,
  "code" : "update-identity",
  "comment" : "The NHI is validated, the versionId is validated, the parameters validated. If all request parameters are valid the included items are updated on the Patients NHI record.",
  "resource" : ["Patient"],
  "system" : false,
  "type" : false,
  "instance" : true,
  "parameter" : [
    {
      "name" : "nhi",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The Patient's nhi number",
      "type" : "string"
    },
    {
      "name" : "version-id",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The current value of the patient resources meta.versionId",
      "type" : "string"
    },
    {
      "name" : "gender",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Patient's gender code",
      "type" : "string"
    },
    {
      "name" : "gender-original-text",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Patient's gender text response",
      "type" : "string"
    },
    {
      "name" : "ethnicity-1",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Patient's ethnicty code",
      "type" : "string"
    },
    {
      "name" : "ethnicity-2",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Patient's ethnicty code",
      "type" : "string"
    },
    {
      "name" : "ethnicity-3",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Patient's ethnicty code",
      "type" : "string"
    },
    {
      "name" : "ethnicity-4",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Patient's ethnicty code",
      "type" : "string"
    },
    {
      "name" : "ethnicity-5",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Patient's ethnicty code",
      "type" : "string"
    },
    {
      "name" : "ethnicity-6",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Patient's ethnicty code",
      "type" : "string"
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "The updated patient resource",
      "type" : "Patient"
    },
    {
      "name" : "failure",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "Error response",
      "type" : "OperationOutcome"
    }
  ]
}

```
