# Update a patient address using an unvalidated address. - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Update a patient address using an unvalidated address.**

## OperationDefinition: Update a patient address using an unvalidated address. 

| | |
| :--- | :--- |
| *Official URL*:https://nhi-ig.hip.digital.health.nz/OperationDefinition/set-unvalidated-address | *Version*:1.6.5 |
| Draft as of 2023-06-12 | *Computable Name*:Set Unvalidated Address |

 
Update a patient address using an unvalidated address. 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "Patient-set-unvalidated-address",
  "url" : "https://nhi-ig.hip.digital.health.nz/OperationDefinition/set-unvalidated-address",
  "version" : "1.6.5",
  "name" : "Set Unvalidated Address",
  "title" : "Update a patient address using an unvalidated address.",
  "status" : "draft",
  "kind" : "operation",
  "experimental" : false,
  "date" : "2023-06-12T12:47:40+10:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "Update a patient address using an unvalidated address.",
  "affectsState" : true,
  "code" : "set-unvalidated-address",
  "comment" : "The patient address is updated with an unvalidated address.",
  "resource" : ["Patient"],
  "system" : false,
  "type" : false,
  "instance" : true,
  "parameter" : [
    {
      "name" : "nhi",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The Patient's nhi number",
      "type" : "string"
    },
    {
      "name" : "version-id",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The current value of the patient resources meta.versionId",
      "type" : "string"
    },
    {
      "name" : "not-validated-address-reason",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The reason the address could not be validated",
      "type" : "string"
    },
    {
      "name" : "address-type",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "Must be physical or postal",
      "type" : "string"
    },
    {
      "name" : "address-line-1",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The first line of the address",
      "type" : "string"
    },
    {
      "name" : "address-line-2",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "The first line of the address",
      "type" : "string"
    },
    {
      "name" : "address-building-name",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Building name if required as additional address information, not returned by eSAM",
      "type" : "string"
    },
    {
      "name" : "address-suburb",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "type" : "string"
    },
    {
      "name" : "address-city",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "type" : "string"
    },
    {
      "name" : "address-postal-code",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "type" : "string"
    },
    {
      "name" : "address-country-code",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Must be supplied when not-validated-address-reason = OSEA and must not be ‘NZ’. When not-validated-address-reason not = OSEA and country-code is supplied it must be ‘NZ’ ",
      "type" : "string"
    },
    {
      "name" : "address-domicile-code",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "When supplied it must be a valid code in domicile-code valueset. When not supplied, the suburb and city are used to derive a domicile code from the streets file. If a suburb/city combination is not found in the streets file an error is returned  (note the client end-user can then enter a domicile code or client system can supply a default district domicile code)",
      "type" : "string"
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "The updated patient resource",
      "type" : "Patient"
    },
    {
      "name" : "failure",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "Error response",
      "type" : "OperationOutcome"
    }
  ]
}

```
