# Replace a contact on a patient's NHI record. - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Replace a contact on a patient's NHI record.**

## OperationDefinition: Replace a contact on a patient's NHI record. 

| | |
| :--- | :--- |
| *Official URL*:https://nhi-ig.hip.digital.health.nz/OperationDefinition/replace-contact | *Version*:1.6.5 |
| Draft as of 2023-06-12 | *Computable Name*:Replace Contact |

 
An operation to replace a contact on a patient's NHI record 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "Patient-replace-contact",
  "url" : "https://nhi-ig.hip.digital.health.nz/OperationDefinition/replace-contact",
  "version" : "1.6.5",
  "name" : "Replace Contact",
  "title" : "Replace a contact on a patient's NHI record.",
  "status" : "draft",
  "kind" : "operation",
  "experimental" : false,
  "date" : "2023-06-12T12:47:40+10:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "An operation to replace a contact on a patient's NHI record",
  "affectsState" : true,
  "code" : "replace-contact",
  "comment" : "The NHI is validated, the versionId is validated, the parameters validated. If all request parameters are valid the new contact is added to the nhi record.",
  "resource" : ["Patient"],
  "system" : false,
  "type" : false,
  "instance" : true,
  "parameter" : [
    {
      "name" : "nhi",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The Patient's nhi number",
      "type" : "string"
    },
    {
      "name" : "version-id",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The current value of the patient resources meta.versionId",
      "type" : "string"
    },
    {
      "name" : "contact-id",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The id of the contact to be replaced",
      "type" : "string"
    },
    {
      "name" : "use",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "home or mobile",
      "type" : "string"
    },
    {
      "name" : "system",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "phone or email",
      "type" : "string"
    },
    {
      "name" : "value",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "the phone number or email address",
      "type" : "string"
    },
    {
      "name" : "isVerified",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Verification has  been performed to determine that the email or phone number can be used to communicate with the patient (true or false)",
      "type" : "boolean"
    },
    {
      "name" : "isShared",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "The email address or phone number is shared with other people (true or false)",
      "type" : "boolean"
    },
    {
      "name" : "isPrivate",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "The email address or phone number may be used to communicate private health information about the individual identified by the NHI",
      "type" : "boolean"
    },
    {
      "name" : "context",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Additional information about the context of use of this contact",
      "type" : "string"
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "The updated patient resource",
      "type" : "Patient"
    },
    {
      "name" : "failure",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "Error response",
      "type" : "OperationOutcome"
    }
  ]
}

```
