# Find patient matches using MPI based logic - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Find patient matches using MPI based logic**

## OperationDefinition: Find patient matches using MPI based logic 

| | |
| :--- | :--- |
| *Official URL*:https://nhi-ig.hip.digital.health.nz/OperationDefinition/Patient-match | *Version*:1.6.5 |
| Draft as of 2023-06-12 | *Computable Name*:Match |

 
A Master Patient Index ([MPI](http://en.wikipedia.org/wiki/Enterprise_master_patient_index) ) is a service used to manage patient identification in a context where multiple patient databases exist. Healthcare applications and middleware use the MPI to match patients between the databases, and to store new patient details as they are encountered. MPIs are highly specialized applications, often tailored extensively to the institution's particular mix of patients. MPIs can also be run on a regional and national basis. 
To ask an MPI to match a patient, clients use the "$match" operation, which accepts a patient resource which may be only partially complete. The data provided is interpreted as an MPI input and processed by an algorithm of some kind that uses the data to determine the most appropriate matches in the patient set. Note that different MPI matching algorithms have different required inputs. The generic $match operation does not specify any particular algorithm, nor a minimum set of information that must be provided when asking for an MPI match operation to be performed, but many implementations will have a set of minimum information, which may be declared in their definition of the $match operation by specifying a profile on the resource parameter, indicating which properties are required in the search. The patient resource submitted to the operation does not have to be complete, nor does it need to pass validation (i.e. mandatory fields don't need to be populated), but it does have to be a valid instance, as it is used as the reference data to match against. 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "Patient-match",
  "url" : "https://nhi-ig.hip.digital.health.nz/OperationDefinition/Patient-match",
  "version" : "1.6.5",
  "name" : "Match",
  "title" : "Find patient matches using MPI based logic",
  "status" : "draft",
  "kind" : "operation",
  "experimental" : false,
  "date" : "2023-06-12T12:47:40+10:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "A Master Patient Index ([MPI](http://en.wikipedia.org/wiki/Enterprise_master_patient_index)\n   ) is a service used to manage patient identification in a context where multiple patient\n   databases exist. Healthcare applications and middleware use the MPI to match patients\n   between the databases, and to store new patient details as they are encountered. MPIs\n   are highly specialized applications, often tailored extensively to the institution's particular\n   mix of patients. MPIs can also be run on a regional and national basis.  \n\nTo ask an MPI to match a patient, clients use the &quot;$match&quot; operation, which\n   accepts a patient resource which may be only partially complete. The data provided is\n   interpreted as an MPI input and processed by an algorithm of some kind that uses the data\n   to determine the most appropriate matches in the patient set.  Note that different MPI\n   matching algorithms have different required inputs. The generic $match operation does\n   not specify any particular algorithm, nor a minimum set of information that must be provided\n   when asking for an MPI match operation to be performed, but many implementations will\n   have a set of minimum information, which may be declared in their definition of the $match\n   operation by specifying a profile on the resource parameter, indicating which properties\n   are required in the search.  The patient resource submitted to the operation does not\n   have to be complete, nor does it need to pass validation (i.e. mandatory fields don't\n   need to be populated), but it does have to be a valid instance, as it is used as the reference\n   data to match against.",
  "affectsState" : false,
  "code" : "match",
  "comment" : "The response is a bundle containing a patient record (validate) or records (match). For match the records are ordered from most likely to least likely. If there are no patient matches an empty search set with no error will be returned. All patient records SHALL have a search score from 0 to 1, where 1 is the most certain match, along with  \"match-grade\" that indicates the MPI's position on the match quality.",
  "resource" : ["Patient"],
  "system" : false,
  "type" : true,
  "instance" : false,
  "parameter" : [
    {
      "name" : "resource",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "Use this to provide an entire set of patient details for the MPI to match against (e.g. POST a patient record to Patient/$match).",
      "type" : "Patient"
    },
    {
      "name" : "onlyCertainMatches",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "When set to TRUE = Validate, When set to FALSE = NHI Search",
      "type" : "boolean"
    },
    {
      "name" : "count",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "The maximum number of records to return. If no value is provided, the server decides how\n     many matches to return. Note that clients should be careful when using this, as it may\n     prevent probable - and valid - matches from being returned",
      "type" : "integer"
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 1,
      "max" : "1",
      "documentation" : "A bundle containing a set of Patient records that represent possible matches, optionally it may also contain an OperationOutcome with further information about the search results (such as warnings or information messages, such as a count of records that were close but eliminated) If the operation was unsuccessful, then an OperationOutcome may be returned along with a BadRequest status Code (e.g. security issue, or insufficient properties in patient fragment - check against profile)",
      "type" : "Bundle"
    },
    {
      "name" : "failure",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "Error response",
      "type" : "OperationOutcome"
    }
  ]
}

```
