# Add a name to a patient's NHI record. - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Add a name to a patient's NHI record.**

## OperationDefinition: Add a name to a patient's NHI record. 

| | |
| :--- | :--- |
| *Official URL*:https://nhi-ig.hip.digital.health.nz/OperationDefinition/add-name | *Version*:1.6.5 |
| Draft as of 2023-06-12 | *Computable Name*:Add Name |

 
An operation to add a name to a patient's NHI record 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "Patient-add-name",
  "url" : "https://nhi-ig.hip.digital.health.nz/OperationDefinition/add-name",
  "version" : "1.6.5",
  "name" : "Add Name",
  "title" : "Add a name to a patient's NHI record.",
  "status" : "draft",
  "kind" : "operation",
  "experimental" : false,
  "date" : "2023-06-12T12:47:40+10:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "An operation to add a name to a patient's NHI record",
  "affectsState" : true,
  "code" : "add-name",
  "comment" : "The NHI is validated, the versionId is validated, the parameters validated. If all request parameters are valid the new name is added to the nhi record.",
  "resource" : ["Patient"],
  "system" : false,
  "type" : false,
  "instance" : true,
  "parameter" : [
    {
      "name" : "nhi",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The Patient's nhi number",
      "type" : "string"
    },
    {
      "name" : "version-id",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The current value of the patient resources meta.versionId",
      "type" : "string"
    },
    {
      "name" : "use",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "the name use qualifier for a name",
      "type" : "string"
    },
    {
      "name" : "prefix",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "the name prefix",
      "type" : "string"
    },
    {
      "name" : "given-1",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "the first or given name",
      "type" : "string"
    },
    {
      "name" : "given-2",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "the middle or other given name(s)",
      "type" : "string"
    },
    {
      "name" : "family",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "the family name",
      "type" : "string"
    },
    {
      "name" : "preferred",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "attribute used to indicate whether the name is preferred or not",
      "type" : "string"
    },
    {
      "name" : "information-source",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The information source for the patient's name",
      "type" : "string"
    },
    {
      "name" : "nhi-name-use-extra",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "an attribute used to qualify pre-allocated and babyof names",
      "type" : "string"
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "The updated patient resource",
      "type" : "Patient"
    },
    {
      "name" : "failure",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "Error response",
      "type" : "OperationOutcome"
    }
  ]
}

```
