# Onboarding - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* **Onboarding**

## Onboarding

### Who can apply for access?

#### To the test environment:

All health providers listed in [Schedule 2 of the Health Information Privacy Code](https://privacy.org.nz/privacy-act-2020/codes-of-practice/hipc2020/) and software vendors will be given access to all the NHI api operations in the HIP Compliance environment for testing and training after completing the on-boarding process described below.

#### To the production environment:

Access to NHI operations is available to all health providers listed in [Schedule 2 of the Health Information Privacy Code](https://privacy.org.nz/privacy-act-2020/codes-of-practice/hipc2020/)

### On-boarding and Implementation

1. To get started, head to['Consumer onboarding', over at the digital services hub](https://www.tewhatuora.govt.nz/health-services-and-programmes/digital-health/digital-services-hub/consumer-onboarding/). You will need to provide information about your organisation, the product you are developing and the API's you want to integrate with.
* For more information [have a look at the other resources on the Digital Service Hub](https://www.tewhatuora.govt.nz/health-services-and-programmes/digital-health/digital-services-hub/).

1. Once your onboarding request has been approved, you will be provided with the information to start integration. The integration team will be in touch if further information is required.
* You will receive your credentials, access token url, provided scopes, and the compliance environment endpoint.

1. Complete your development and testing.
1. When you are ready for compliance testing, email the[integration team](mailto:integration@tewhatuora.govt.nz)to get a compliance testing template.
1. Submit the results of the compliance tests using this form[HIP Compliance Submission](https://mohapis.atlassian.net/servicedesk/customer/portal/3/group/11/create/129).
1. The integration team will issue a compliance test report. Your application will receive certification to be used in production or additional requirements will need to be met.
* This can be an iterative process, so please get in touch as needed to discuss the compliance testing process.

1. **Each organisation**using your application with NHI integrated services must apply individually for access to the production environment (and recieve their own set of credentials) by completing the production form, please email[NHI Access](mailto:nhi_access@health.govt.nz).

* Please allow at least 5 working days for **compliance environment applications** to be processed.
* Please allow at least 2 weeks for **compliance testing** to be signed off and returned.
* If **Production credentials** are required by a large number of organisations accessing your product, please get in touch to discuss options around bulk credential requests and how we can streamline this process.

### Assistance

Please fill in the [Digital Services Hub Support and Feedback form](https://mohapis.atlassian.net/servicedesk/customer/portal/3/group/35/create/112).

### Business Functions

* Business Functions: Get Patient
  * Description: Get Patient using an NHI number
  * Comments: Returns a patient resource[See Get Patient use case](getPatient.md)
* Business Functions: Get Patient - Enrolled GP
  * Description: Get Patient using an NHI number and include the patients enrolled GP in the response
  * Comments: The patient’s enrolled GP information is returned in the patient resourceThe source for this is the National Enrolment Service (NES)NES Business owner approval required[See Get Patient use case](getPatient.md)[See information on Patient’s Enrolled GP](StructureDefinition-NhiPatient.md#patients-enrolled-general-practice)
* Business Functions: Get Patient - Contact details
  * Description: Get Patient using an NHI number and include the patient’s contact details in the response
  * Comments: The patient’s contact details are returned in the patient resource.The source for this is the National Enrolment Service Patient Preferences.Access to a patient’s contact details in Production will only be granted to Te Whatu Ora business teams that have completed a Privacy Impact Assessment which has been assessed and approved by the Te Whatu Ora privacy team. Business Owners should progress this in parallel with any application development. Production access to contact details will not be granted unless this step has been completed.[See Get Patient use case](getPatient.md)[See information on Patient’s Contact details](StructureDefinition-NhiPatient.md#patients-contact-details)
* Business Functions: Search Patient
  * Description: Search Patient using name, birthdate and other demographics
  * Comments: Returns only the core NHI fields (No enrolled GP or contact details even if the user has the correct permissions.Returns a patient resource[See Match Patient use case](matchPatient.md)
* Business Functions: Maintain Patient
  * Description: Update Patient records
  * Comments: Provided on a limited basis to primary and secondary healthcare providers, and health system data quality teams.Allows access to the following operations:*  [Update Name](updateName.md) 
*  [Update Address](updateAddress.md) 
*  [Update Identity](updateIdentity.md) 
*  [Update Birth](updateBirth.md) 
*  [Update Eligibility](updateEligibility.md) 
Compliance will be issued by operation.For those without access this may be achieved by phoning the Te Whatu Ora contact centre (0800 855 066).
* Business Functions: Create Patient
  * Description: Create Patient records
  * Comments: Provided on a limited basis to primary and secondary healthcare providers.For those without access this may be achieved by phoning the Te Whatu Ora contact centre (0800 855 066).[See Create Patient use case](createPatient.md)
* Business Functions: Validate Patient
  * Description: Validate Patient using an NHI number and patient demographics
  * Comments: [See Validate Patient use case](validatePatient.md)

