# Create Patient Compliance Testing - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* **Create Patient Compliance Testing**

## Create Patient Compliance Testing

#### NHI Create Patient tests

* Reference: NHI-Create-Patient-1
  * Purpose – Demonstrate that the: Application can create a new patient with the minimum set of patient information
  * Input values: Create a patient with a fictitious identity (this can be done using http://www.fakenamegenerator.com/)*  Name 
*  Given name and family name 
*  Source - PPRT
 
*  Address 
*  Validated
 
*  Date of Birth 
*  Date
*  Source - BRCT
 
*  Gender 
*  other
 
*  Ethnicity 
* 32100 (Cook Islands Maori) and,
* 12948 (South African) and,
* 32100 (Cook Islands Maori)
 
*  New Zealand Citizenship Status 
* Status - yes
* Source - BRCT
 

  * Expected outcome: * Input: Minimum set of patient information can be provided 
* Output: New NHI is displayed with minimum dataset
* Output: All patient information can be displayed

  * Mandatory: Mandatory
* Reference: NHI-Create-Patient-2
  * Purpose – Demonstrate that the: Application can create a new patient with the minimum set of patient information
  * Input values: Create a patient with a fictitious identity*  Name 
*  Family only 
*  Source NPRF
 
*  Address 
*  Validated
 
*  Date of Birth 
*  Date
*  Source - NPRF
 
*  Gender 
*  unknown
 
*  Ethnicity - see below 
*  New Zealand Citizenship Status 
* Status - no
* Source - NPRF
 
![](update-core-2.png)
  * Expected outcome: *  Input: Minimum set of patient information can be provided 
* Output: New NHI is displayed with minimum dataset
* Output: All patient information can be displayed

  * Mandatory: Mandatory
* Reference: NHI-Create-Patient-3
  * Purpose – Demonstrate that the: Application can create a new patient with the minimum set of patient information
  * Input values: Create a patient with:*  Name 
*  Given, other given and family 
*  Source NPRF
 
*  Address 
*  Validated
 
*  Date of Birth 
*  Date month and year only
*  Source - NPRF
 
*  Gender 
* code - female
* original-text (optional)
 
*  Ethnicity 
* 97777 (response unidentifiable)
 
*  New Zealand Citizenship Status 
* Status - unknown 
* Source - NPRF
 
Create a fictitious identity (this can be done using http://www.fakenamegenerator.com/)
  * Expected outcome: * Input: Minimum set of patient information can be provided 
* Output: New NHI is displayed with minimum dataset
* Output: All patient information can be displayed

  * Mandatory: Mandatory
* Reference: NHI-Create-Patient-4
  * Purpose – Demonstrate that the: Application can supply birthplace information when creating a patient
  * Input values: Create a patient with the minimum set of patient information and the additional details below* Birthplace 
*  Country of birth 
*  Information source 
*  Place of birth 
 

  * Expected outcome: * Input: Additional identity information can be provided 
* Output: New NHI is displayed with minimum dataset
* Output: All patient information can be displayed

  * Mandatory: Mandatory
* Reference: NHI-Create-Patient-5
  * Purpose – Demonstrate that the: Application can create a patient with an unvalidated patient address
  * Input values: Create a patient with minimum set of patient information, with an unvalidated patient address**Do all**1. OSEA
1. UKWN
1. NFAB
1. NOSVC
1. OTHER

  * Expected outcome: * Input: All unvalidated address reasons can be provided 
* Output: New NHI is displayed with minimum dataset
* Output: All patient information can be displayed

  * Mandatory: Mandatory

#### NHI Create Patient error tests

* Reference: NHI-Create-Patient-error-1Mandatory information
  * Purpose – Demonstrate that the: application will show the correct error when attempting to create a patient with a mandaotory attribute missing
  * Input values: Attempt to create a patient with a piece of mandatory information missing** Do all **1. Name
1. Date of birth
1. Gender
1. Ethnicity
1. NZ Citizenship
1. Address

  * Expected outcome: Error: EM07201 "Patient name is a required field"Error: EM07201 "Patient Date of birth is a required field"Error: EM07201 "Patient gender is a required field"Error: EM07201 "Patient Ethnicity is a required field"Error: EM07201 "Patient NZ Citizenship is a required field"Error: EM07201 "Patient Address is a required field"
  * Mandatory: Mandatory
* Reference: NHI-Create-Patient-error-2Address
  * Purpose – Demonstrate that the: Application will show the correct error when attempting to create a patient with an eSAM validated address where the nz address id does not match the first line of the validated address
  * Input values: *  address-line: 24 Ranglesey Place 
*  nz-address-id: 1199146 
*  address-type: physical

  * Expected outcome: Error: "address-line must match the espatial value: ..."
  * Mandatory: Mandatory
* Reference: NHI-Create-Patient-error-3Address
  * Purpose – Demonstrate that the: Application will show the correct error when attempting to create a patient with the following unvalidated address without a domicile code
  * Input values: *  not-validated-address-reason: NOSVC 
*  address-type: physical 
*  address-line-1: 74 Chancellor Street" 
*  address-suburb: Richmond 
*  address-city: Christchurch 
*  address-country-code: NZ 

  * Expected outcome: Error: "Invalid codeset value"This will be updated in an upcming release - EM02210 - An unvalidated residential address must have a notional domicile code
  * Mandatory: Mandatory
* Reference: NHI-Create-Patient-error-4Address
  * Purpose – Demonstrate that the: Application will show the correct error when attempting to create a patient with an address with invalid characters
  * Input values: *  not-validated-address-reason: OTHER 
*  address-type: physical 
*  address-line-1: 11 L$nnet Street 
*  address-suburb: Taihape 
*  address-city: Taihape 
*  address-domicile-code: 4720 
*  address-country-code: NZ 

  * Expected outcome: Error: "Invalid request body"
  * Mandatory: Mandatory
* Reference: NHI-Create-Patient-error-5Address
  * Purpose – Demonstrate that the: Application will show the correct error when attempting to create a patient with an address that does not contain address line 1
  * Input values: *  not-validated-address-reason: OTHER 
*  address-type: physical 
*  address-line-2: 11 Linnet Street 
*  address-suburb: Taihape 
*  address-city: Taihape 
*  address-domicile-code: 4720 
*  address-country-code: NZ 

  * Expected outcome: Error: "Patient address-line-1 is required"
  * Mandatory: Optional
* Reference: NHI-Create-Patient-error-6Address
  * Purpose – Demonstrate that the: Application will show the correct error when attempting to create a patient with an address missing a not validated reason
  * Input values: *  address-type: physical 
*  address-line-1: 11 Linnet Street 
*  address-suburb: Taihape 
*  address-city: Taihape 
*  address-domicile-code: 4720 
*  address-country-code: NZ 

  * Expected outcome: Error: "Address not validated reason is required"
  * Mandatory: optional
* Reference: NHI-Create-Patient-error-7Name
  * Purpose – Demonstrate that the: application can display an error when no family name is present
  * Input values: Attempt to create a patient with no family name* Name use = nickname
* Source = PPRT
* Don't insert a family name

  * Expected outcome: Output: EM02101 - "A Patient name must contain a family name, a preferred name flag and an information source"
  * Mandatory: mandatory
* Reference: NHI-Create-Patient-error-8Name
  * Purpose – Demonstrate that the: application can display an error when the given or family name contains special characters e.g. # @ %
  * Input values: Attempt to create a patient with a fictitious name (with special character)
  * Expected outcome: Output: "Invalid request body"
  * Mandatory: mandatory
* Reference: NHI-Create-Patient-error-9Name
  * Purpose – Demonstrate that the: application can display an error when a given or family name begins with a number e.g. 1Smith
  * Input values: Attempt to create a patient with a fictitious name (with a number as the first character)
  * Expected outcome: Output: EM02107 "A Patient’s given and family name must start with a letter of the alphabet or an apostrophe"
  * Mandatory: mandatory
* Reference: NHI-Create-Patient-error-10Name
  * Purpose – Demonstrate that the: application can display an error when a given or family name contains only whitespace/s
  * Input values: Attempt to create a patient with a name (containing only whitespace)
  * Expected outcome: Output: EM02110 "Each populated Patient Name field must contain at least one letter"
  * Mandatory: mandatory
* Reference: NHI-Create-Patient-error-11Name
  * Purpose – Demonstrate that the: application can display an error when no information source
  * Input values: Attempt to create a patient with a fictitious name* Name use = nickname
* source = PPRT
* Don't insert a information-source

  * Expected outcome: Output: EM02101 - "A Patient name must contain either a given or family name, a preferred name flag and an information source."
  * Mandatory: mandatory
* Reference: NHI-Create-Patient-error-12Name
  * Purpose – Demonstrate that the: application can display an error when an invalid source is provided
  * Input values: Attempt to create a patient with a registered name source* source = BREG (Birth Register)

  * Expected outcome: Output: EM07229 - "The patient name can only be set to a registered value by an authorised agency"
  * Mandatory: mandatory
* Reference: NHI-Create-Patient-error-13Name
  * Purpose – Demonstrate that the: application can display an error when no preferred-name-flag
  * Input values: Attempt to create a patient with no preferred flag* Name use = nickname
* source = PPRT
* don't insert a preferred-name flag

  * Expected outcome: Output: EM02101 - "A Patient name must contain either a given or family name, a preferred name flag and an information source."
  * Mandatory: optional
* Reference: NHI-Create-Patient-error-14Name
  * Purpose – Demonstrate that the: application can display an error when preferred-name = false
  * Input values: Attempt to create a patient with preferred flag = false* Name use = nickname
* source = PPRT
* preferred-name = false

  * Expected outcome: Output: EM02101 - "A Patient name must contain either a given or family name, a preferred name and an information source."
  * Mandatory: optional
* Reference: NHI-Create-Patient-error-15Name
  * Purpose – Demonstrate that the: application can display an error when a Babyof name is supplied with a use other than 'temp' and a source other than 'NPRF'
  * Input values: Attempt to create a patient with babyof name*  Name use = nickname 
*  source = PPRT 

  * Expected outcome: Output: EM07225 - "name-use-extra is conditional on source = NPRF and name use = temp"
  * Mandatory: mandatory
* Reference: NHI-Create-Patient-error-16Ethnicity
  * Purpose – Demonstrate that the: application can display an error when attempting to create a patient with invalid ethnicity informationcontains multiple residual codes (9xxxx)
  * Input values: Create a Patient with the ethnicities below:*  97777 (response unidentifiable) 
*  and 99999 (not stated)

  * Expected outcome: Output: EM02301 - "A Patient must have at least one valid ethnicity code, only one instance of each selected ethnicity, and no more than one ‘unspecified’ ethnicity code"
  * Mandatory: mandatory
* Reference: NHI-Create-Patient-error-17Ethnicity
  * Purpose – Demonstrate that the: application can display an error when attempting to create a patient with invalid ethnicity informationset of supplied ethnicities that includes a duplicate ethnicity
  * Input values: Create a Patient with the ethnicities below:* 32100 (Cook Islands Maori) and,
* 12948 (South African) and,
* 32100 (Cook Islands Maori)

  * Expected outcome: Output: EM02301 - "A Patient must have at least one valid ethnicity code, only one instance of each selected ethnicity, and no more than one ‘unspecified’ ethnicity code"
  * Mandatory: mandatory
* Reference: NHI-Create-Patient-error-18Gender
  * Purpose – Demonstrate that the: application can display an error when attempting to create a patient with a gender-original-text and no gender value
  * Input values: Attempt to create a patient with a gender-original-text (and not gender)
  * Expected outcome: Output: EM07201 - "Is a required field - Patient.gender"
  * Mandatory: mandatory
* Reference: NHI-Create-Patient-error-19Citizenship
  * Purpose – Demonstrate that the: application can display an error when attempting to create a patient with a NZ Citizenship information source without a NZ Citizenship status
  * Input values: Choose an NZ Citizenship information source to supply but do not add NZ Citizenship status
  * Expected outcome: The format of the message is invalid (EM01002)
  * Mandatory: Mandatory
* Reference: NHI-Create-Patient-error-20Citizenship
  * Purpose – Demonstrate that the: application can display an error when when attempting to create a patient with a registered Citizenship information source
  * Input values: Attempt to create a patient with a citizenship*  Citizenship = yes 
*  Attempt to add source = DIA 

  * Expected outcome: Output: EM07229 "Patient NZ Citizenship can only be set to a ‘Registered’ value by an authorised agency"
  * Mandatory: mandatory
* Reference: NHI-Create-Patient-error-21Date of birth
  * Purpose – Demonstrate that the: application will show the correct error when attempting to create a patient with a bithdate in the future
  * Input values: Date of birth: A future date
  * Expected outcome: EM07212 - Patient Date of birth cannot be a future date
  * Mandatory: Mandatory
* Reference: NHI-Create-Patient-error-22Date of birth
  * Purpose – Demonstrate that the: application can display an error when when attempting to create a patient with a registered Date of birth information source
  * Input values: Attempt to create a patient with Date of birth source = BREG*  Attempt to add source = BREG 

  * Expected outcome: Output: EM07229 "Patient Date of birth can only be set to a ‘Registered’ value by an authorised agency"
  * Mandatory: mandatory
* Reference: NHI-Create-Patient-error-23Birthplace
  * Purpose – Demonstrate that the: Application will show the correct error when attempting to create a patient with a place of birth but no country of birth
  * Input values: Place of Birth: LondonDo not supply a country of birth
  * Expected outcome: EM07202 - A place of birth must only be populated if a country of birth is populated
  * Mandatory: Mandatory
* Reference: NHI-Create-Patient-error-24Birthplace
  * Purpose – Demonstrate that the: Application will show the correct error when attempting to create a patient with no information source
  * Input values: *  Place of Birth: Whangarei 
*  Country of Birth: New Zealand 
*  Source: Do not add a source

  * Expected outcome: EM07202 - A place of birth must only be populated if a place of birth source is populated
  * Mandatory: Mandatory
* Reference: NHI-Create-Patient-error-25Birthplace
  * Purpose – Demonstrate that the: Application will show the correct error when attempting to create a patient with no information source
  * Input values: *  Source: PPRT

  * Expected outcome: EM07202 - A place of birth source must only be populated if birth locality information is populated
  * Mandatory: Mandatory

#### NHI Create Patient - death date - future scope

* Reference: NHI-Create-Patient-date-death
  * Purpose – Demonstrate that the: application can create a patient with a date of death
  * Input values: Create a patient with date of death
  * Expected outcome: * Input: date of death can be included when creating patient
* Output: New NHI is displayed with minimum dataset
* Output: NHI clearly shows patient deceased
*  Output: Information source added as: TBC 

  * Mandatory: Mandatory
* Reference: NHI-Create-Patient-death-date-error-1
  * Purpose – Demonstrate that the: application will show the correct error when attempting to create a patient with a date of birth after the date of death supplied
  * Input values: *  Date of birth: Todays date 
*  Date of death = Todays date -1 

  * Expected outcome: EM07215 - Patient Date of Death must be greater than, or equal to Patient Date of Birth
  * Mandatory: Mandatory
* Reference: NHI-Create-Patient-death-date-error-2
  * Purpose – Demonstrate that the: application will show the correct error when attempting to create a patient with a date of death in the future
  * Input values: *  Date of death = future date 
*  Source: TBC 

  * Expected outcome: EM07212 - Patient Date of Death date cannot be a future date
  * Mandatory: Mandatory
* Reference: NHI-Create-Patient-death-date-error-3
  * Purpose – Demonstrate that the: application will show the correct error when attempting to create a patient with a date of death with no source
  * Input values: *  Date of death = todays date 
*  Source: Don't add a source 

  * Expected outcome: EM07202 - A date of death must only be populated if a date of death source is populated
  * Mandatory: Mandatory

