# Compliance Testing Important Information - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* **Compliance Testing Important Information**

## Compliance Testing Important Information

### Compliance testing process

Provide the following details in a test report and email to [integration@health.govt.nz](mailto:integration@health.govt.nz).

1. Tester details 
 a. Organisation Name 
 b. Application name and version 
 c. NHI IG Version 
 d. Test Script version 
 e. FHIR release version (Get(Endpoint)/metadata) 
 f. Testing start date and time and end date and time 
 g. Tester name and contact details 
 h. List of operations included in your integration (eg GET Patient, Search(Match) Patient)
1. For each test supply screen shots of the user interface for:
* the input data as entered in the integrating application (“the application”)
* the output: 
* any error messages presented by the application
* the confirmation or result of the request presented by the application
 
* For update operations the state of the record pre-request should be included.
* **Note**: If non-interactive, please provide JSON request (update / create) or response (get/search).

1. For each test supply a timestamp when each request is sent.

### Test Data

To access a list of NHI test identifiers follow [this link](https://www.tewhatuora.govt.nz/our-health-system/digital-health/health-identity/information-for-it-vendors-and-developers/#national-health-index-nhi). For a set of current formant identifiers and look for heading **NHI Test identifiers** and for new format NHI test identifiers see **NHI records Mod23**.

### Compliance tests

Not all compliance tests in this implementation guide will be appropriate for every application. If there are tests that do not apply please discuss this with the integration team and where appropriate write a description in the compliance test submission why the particular test does not apply.

**Mandatory vs Optional tests**

* If there are tests below that are labelled mandatory but do fit the application's use case then please let us know why.
* Some tests are labelled **mandatory if**. These tests are Mandatory only if you are using this piece of data for your use case.

To request a template for the compliance tests either add a comment to your onboarding request form or reach out using the [Enquiry form](https://mohapis.atlassian.net/servicedesk/customer/portal/3/group/35/create/112).

#### Security and Audit Assessment

* Reference: Security 1
  * Purpose: Credentials match those issued to the testing organisationand their orgID and appID are auditing correctly
  * Input values: Checked against all tests
  * Expected outcome: Te Whatu Ora will check internal logs
  * Mandatory: Mandatory
* Reference: Security 2
  * Purpose: Sending user ID is an end user ID or an hpi-person-id (CPN)
  * Input values: Checked against all tests
  * Expected outcome: Te Whatu Ora will check internal logs
  * Mandatory: Mandatory
* Reference: Security 3
  * Purpose: Sending user ID changes when different end users are initiating the request (Please make sure a seperate user creates a request)
  * Input values: Checked against all tests
  * Expected outcome: Te Whatu Ora will check internal logs
  * Mandatory: Mandatory
* Reference: Security 4
  * Purpose: Each request has a unique request id in the X-Correlation-Id fieldIf present this will be returned in the response
  * Input values: Checked against all tests
  * Expected outcome: Te Whatu Ora will check internal logs
  * Mandatory: Recommended

#### General tests

* Reference: General-1
  * Purpose – Demonstrate that the: Application can handle an HTTP 429 error in a graceful way
  * Input values: The application reaches its usage plan limit and is returned an HTTP 429 error.[See Usage plans](general.md#usage-plans)
  * Expected outcome: The application will retry several times with an exponentially increasing delay
  * Mandatory / Optional / Recommended: Recommended
* Reference: General-2
  * Purpose – Demonstrate that the: Application can present the NHI terms of use to individual user's when the integrating application first goes live for an Organisation. A reference terms of use is supplied, or the NHI terms of use can be included as part of the application's terms of use.
  * Input values: [See Terms Of Use](TermsOfUse.md)
  * Expected outcome: * The application will display terms of use to the end user
* The application must store the end users acceptance of the terms

  * Mandatory / Optional / Recommended: Recommended

#### Extra Tests for New NHI number format

* Reference: NHI-Extra-1
  * Purpose: Get new format NHIapplication behaves appropriately when a new format NHI number is produced
  * Input values: * ZXE24NV
* ZUA48EH
* ZUT01RG

  * Expected outcome: * Output: 
* Application does not error
* Minimum identity information is displayed for the patient
 

  * Mandatory: Optional
* Reference: NHI-Extra-2
  * Purpose: Get dormant-1application behaves appropriately when a request for a dormant new format NHI number returns a 'live' older format NHI number
  * Input values: * ZNK28DJ

  * Expected outcome: *  Input: user can enter new format NHI 
*  Output 
* application should return live record 'ZKP3424'
* application does not error when an older format NHI is returned.
* Notification to the user that the requested NHI was dormant and the live NHI has been returned
 

  * Mandatory: Optional
* Reference: NHI-Extra-3
  * Purpose: Get dormant-2application behaves appropriately when a request for a dormat older format NHI number returns a 'live' new format NHI number
  * Input values: * ZWX5200

  * Expected outcome: *  Input: user can enter the older format NHI 
*  Output 
* application should return live record 'ZXE24NV'
* application does not error when an older format NHI is returned.
* Notification to the user that the requested NHI was dormant and the live NHI has been returned
 

  * Mandatory: Optional
* Reference: NHI-Extra-4
  * Purpose: Search / Match new format NHIapplication behaves appropriately when a new format NHI number is returned in a search response
  * Input values: Use an NHI Search / Match request to retrieve patients below* ZXE24NV
* ZUA48EH
* ZUT01RG

  * Expected outcome: * Input: Search criteria can be entered
* Output: 
* Application does not error when new formt NHI returned
* Minimum identity information is displayed for the patient
 

  * Mandatory: Optional
* Reference: NHI-Extra-5
  * Purpose: Create new format NHIapplication can create a patient with a new format NHI number
  * Input values: * Family Name: NEWNHI
* Add all other relevant ficticious data

  * Expected outcome: *  Input: Create a new format NHI with Family name above 
*  Output: 
* Application can create a patient successfully
* Application does not error
 

  * Mandatory: Optional
* Reference: NHI-Extra-6
  * Purpose: Update new format NHIapplication can update a patient with a new format NHI number
  * Input values: * Use NHI created above and update relevant attributes depending on use case 
* Birthdate
* Birthplace
* Gender
* Ethnicity
* Name
* Address
* NZ Citizenship status
 

  * Expected outcome: *  Input: User can input information to update
*  Output: 
* Application can update a new format NHI successfully
* Application does not error
 

  * Mandatory: Optional
* Reference: NHI-Extra-7
  * Purpose: Get enrolment for new formatapplication can return enrolment information for a new format NHI
  * Input values: * ZXE24NV

  * Expected outcome: *  Input: user can enter new format NHI 
*  Output: application can display enrolment information for new format NHI

  * Mandatory: Optional
* Reference: NHI-Extra-8
  * Purpose: Create enrolment for new formatapplication can create an enrolment for a new format NHI number
  * Input values: * ZTL39SK
* ZWB84LW
* ZQF54PV

  * Expected outcome: *  Input: user can create an enrolment for a new format NHI 
*  Output: enrolment created successfully

  * Mandatory: Optional
* Reference: NHI-Extra-9
  * Purpose: Update enrolment for new formatapplication can update an enrolment for a new format NHI number
  * Input values: *  update one of the enrolments created above, do all relevant tests:
* Service Practitioner
* Re-enrolment date 
* Qualified encounter date 
* Termination Reason 

  * Expected outcome: *  Input: user can update an enrolment for a new format NHI 
*  Output: enrolment updated successfully

  * Mandatory: Optional
* Reference: NHI-Extra-10
  * Purpose: Get Medical Warning for new formatapplication can return Medical Warning information for a new format NHI
  * Input values: * ZAK21MS
* ZYC49PX

  * Expected outcome: *  Input: user can enter new format NHI 
*  Output: application can display Medical Warning information for new format NHI

  * Mandatory: Optional
* Reference: NHI-Extra-11
  * Purpose: Create Medical Warning for new formatapplication can create a Medical Warning for a new format NHI number
  * Input values: * ZTL39SK
* ZWB84LW
* ZQF54PV

  * Expected outcome: *  Input: user can create a Medical Warning for a new format NHI 
*  Output: Medical Warning created successfully

  * Mandatory: Optional
* Reference: NHI-Extra-12
  * Purpose: Update Medical Warning for new formatapplication can update a Medical Warning for a new format NHI number
  * Input values: *  update one of the Medical Warnings created above

  * Expected outcome: *  Input: User can update a Medical Warning for a new format NHI 
*  Output: Medical Warning updated successfully

  * Mandatory: Optional
* Reference: NHI-Extra-13
  * Purpose: Get Health Care Event for new format NHIapplication can return Health Care Events for a new format NHI
  * Input values: * ZDP92ZR
* ZVE74QH

  * Expected outcome: *  Input: user can enter new format NHI 
*  Output: application can display Health Care Events for new format NHI

  * Mandatory: Optional

