# NhiCapabilityStatement - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NhiCapabilityStatement**

## CapabilityStatement: NhiCapabilityStatement 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org.nz/fhir/ig/nhi/CapabilityStatement/NhiCapabilityStatement | *Version*:1.6.5 |
| Draft as of 2020-04-21 | *Computable Name*: |

 
A FHIR API in front of the New Zealand NHI 

 [Raw OpenAPI-Swagger Definition file](NhiCapabilityStatement.openapi.json) | [Download](NhiCapabilityStatement.openapi.json) 



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "NhiCapabilityStatement",
  "url" : "http://hl7.org.nz/fhir/ig/nhi/CapabilityStatement/NhiCapabilityStatement",
  "version" : "1.6.5",
  "status" : "draft",
  "date" : "2020-04-21",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "A FHIR API in front of the New Zealand NHI",
  "kind" : "instance",
  "implementation" : {
    "description" : "HPI system"
  },
  "fhirVersion" : "4.0.1",
  "format" : ["json"],
  "patchFormat" : ["json"],
  "implementationGuide" : ["http://hl7.org.nz/fhir/StructureDefinition/NHI"],
  "rest" : [
    {
      "mode" : "server",
      "resource" : [
        {
          "type" : "Patient",
          "profile" : "http://hl7.org.nz/fhir/StructureDefinition/NhiPatient",
          "interaction" : [
            {
              "code" : "read",
              "documentation" : "GET,[base]/Patient/[nhi-id], Retrieve a Patient resource by Id , patient:Patient.r system/Patient.r"
            }
          ],
          "operation" : [
            {
              "name" : "match",
              "definition" : "http://hl7.org/fhir/OperationDefinition/Patient-match",
              "documentation" : "POST, [base]/Patient/$match, <b>Match</b>: with In parameter <code>onlyCertainMatches=0</code> (False) the operation will search the NHI by demographics using fuzzy logic. Returns a bundle of results with match scores.  <br/><b>Validate:</b> with In parameter <code>onlyCertainMatches=1</code> (True) the operation will validate known patient demographic details against an NHI number. Returns a bundle of results with one patient resource that only includes the live nhi-id.,  system/Patient.s system/Patient.v"
            },
            {
              "name" : "set-preferred-name",
              "definition" : "https://nhi-ig.hip.digital.health.nz/OperationDefinition/set-preferred-name",
              "documentation" : "POST, [base]/Patient/$set-preferred-name, Set the patient's preferred name,patient:Patient.u system/Patient.u"
            },
            {
              "name" : "set-address",
              "definition" : "https://nhi-ig.hip.digital.health.nz/OperationDefinition/set-address",
              "documentation" : "POST, [base]/Patient/$set-address,Update a patient's address, patient:Patient.u system/Patient.u"
            },
            {
              "name" : "set-unvalidated-address",
              "definition" : "https://nhi-ig.hip.digital.health.nz/OperationDefinition/set-unvalidated-address",
              "documentation" : "POST, [base]/Patient/$set-unvalidated-address, Allows a user to replace a physical address OR add or replace a postal address with an unvalidated address,system/Patient.u"
            },
            {
              "name" : "remove-postal-address",
              "definition" : "https://nhi-ig.hip.digital.health.nz/OperationDefinition/remove-postal-address",
              "documentation" : "POST, [base]/Patient/$remove-postal-address, Remove a patient's postal address,patient:Patient.u system/Patient.u"
            },
            {
              "name" : "update-birth",
              "definition" : "https://nhi-ig.hip.digital.health.nz/OperationDefinition/update-birth",
              "documentation" : "POST, [base]/Patient/$update-birth, Update a patient's birth information,  system/Patient.u"
            },
            {
              "name" : "update-identity",
              "definition" : "https://nhi-ig.hip.digital.health.nz/OperationDefinition/update-identity",
              "documentation" : "POST, [base]/Patient/$update-identity, An operation to update a patient's identity details.,  patient:Patient.u  system/Patient.u "
            },
            {
              "name" : "add-name",
              "definition" : "https://nhi-ig.hip.digital.health.nz/OperationDefinition/add-name",
              "documentation" : "POST, [base]/Patient/$add-name, Add a name to a patient's NHI record, system/Patient.u"
            },
            {
              "name" : "replace-name",
              "definition" : "https://nhi-ig.hip.digital.health.nz/OperationDefinition/replace-name",
              "documentation" : "POST, [base]/Patient/$replace-name, An operation to replace a name on a patient's record, system/Patient.u"
            },
            {
              "name" : "inactivate-name",
              "definition" : "https://nhi-ig.hip.digital.health.nz/OperationDefinition/inactivate-name",
              "documentation" : "POST, [base]/Patient/$inactivate-name, Inactivate a name that is currently active on a patients record ,system/Patient.u"
            },
            {
              "name" : "update-eligibility",
              "definition" : "https://nhi-ig.hip.digital.health.nz/OperationDefinition/update-eligibility",
              "documentation" : "POST, [base]/Patient/$update-eligibility, Update a patient's citizenship information, system/Patient.u"
            },
            {
              "name" : "create",
              "definition" : "https://nhi-ig.hip.digital.health.nz/OperationDefinition/create-patient",
              "documentation" : "POST, [base]/Patient/$create,Create a new patient record in the NHI, system/Patient.c "
            },
            {
              "name" : "add-contact",
              "definition" : "https://nhi-ig.hip.digital.health.nz/OperationDefinition/add-contact",
              "documentation" : "POST, [base]/Patient/$add-contact, add a contact to a patient's NHI record, system/Patient.u"
            },
            {
              "name" : "replace-contact",
              "definition" : "https://nhi-ig.hip.digital.health.nz/OperationDefinition/replace-contact",
              "documentation" : "POST, [base]/Patient/$replace-contact,  replace a contact on a patient's NHI record, system/Patient.u"
            },
            {
              "name" : "delete-contact",
              "definition" : "https://nhi-ig.hip.digital.health.nz/OperationDefinition/delete-contact",
              "documentation" : "POST, [base]/Patient/$delete-contact, Delete a contact from a patient's NHI record, system/Patient.u"
            }
          ]
        }
      ]
    }
  ]
}

```
