# Update Identity - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* **Update Identity**

## Update Identity

### Update Identity Overview

The update identity operation allow an authorised user to update the self-identified attributes on a persons identity record.

This includes:

* Gender
* Ethnicity
* Pronoun - future scope
* Language - future scope
* Iwi affiliation - future scope

**Update-identity - Processing steps:**

1. The user provides patient details to be updated
1. The integrating application sends an HTTP Post request using the $update-identity operation to the NHI E.g. Post<Endpoint>/Patient/$update-identity
1. The request is validated - ALT: Validation failure. Operation Outcome resource returned
1. The provided patient attributes are updated
1. The updated record is returned with an HTTP 200 ok response
1. The integrating application displays the updated details to the user

#### Update-identity - In Parameters

* Parameter name: nhi
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The patients nhi number
* Parameter name: version-id
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The current patient version number
* Parameter name: gender
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: The patients gender code
* Parameter name: gender-original-text
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: The gender text response provided by the patient
* Parameter name: ethnicity-1
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: The patients ethnicityup to six
* Parameter name: ethnicity-2
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: The patients ethnicityup to six
* Parameter name: ethnicity-3
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: The patients ethnicityup to sixpopulted in ascending order
* Parameter name: ethnicity-4
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: The patients ethnicity
* Parameter name: ethnicity-5
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: The patients ethnicity
* Parameter name: ethnicity-6
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: The patients ethnicity

#### Update-identity - Behaviour

* The NHI is validated
* The Patient version-id is validated
* The parameters are validated
* If all request parameters are valid, the attributes are updated on the NHI.

#### Update-identity - Example request

```
{
  "resourceType": "Parameters",
  "id": "example",
  "parameter": [
    {
        "name" : "nhi",
        "valueString" : "ZGD9203"
    },
    {
        "name" : "version-id",
        "valueString" : "3321540"
    },
    {
        "name" : "gender",
        "valueString" : "female"
    },
    {
        "name" : "gender-original-text",
        "valueString" : "wahine"
    },
    {
        "name" : "ethnicity-1",
        "valueString" : "21111"
    },
    {
        "name" : "ethnicity-2",
        "valueString" : "12113"
    },
    {
        "name" : "ethnicity-3",
        "valueString" : "12116"
    },
    {
        "name" : "ethnicity-4",
        "valueString" : "12411"
    },
    {
        "name" : "ethnicity-5",
        "valueString" : "12913"
    },
    {
        "name" : "ethnicity-6",
        "valueString" : "12114"
    }
  ]
}


```

#### Update-identity - Rules and errors

[For Request rules and errors click here](/general.md#request-rules-and-errors)

##### Patient update-identity rules

* An update request must contain: 
* the live NHI number for the Patient Record
* the version number of the current Patient Record
 
* An update request must not delete/inactivate mandatory information.
* An update request may: 
* Populate the request parameter with the required value(s) to modify the existing NHI value for that parameter
* Not populate the request parameter to retain the existing NHI value for that parameter
 

##### Update-identity Gender rules

* All [create patient gender rules apply](/createPatient.md#create-patient-gender-rules) and,
* An update request will replace the current gender code or gender original text.

##### Update-identity Ethnicity rules

* All [create patient ethnicity rules apply](/createPatient.md#create-patient-ethnicity-rules) and,
* A full set of ethnicities is required for an update and will replace the current set.

-------

* **Patient update-identity errors** 
* **Patient NHI and version number are required**
* **Version number is incorrect**
* **A Patient must have at least one valid ethnicity code, only one instance of each selected ethnicity, and no more than one ‘unspecified’ ethnicity code**
 

