# Update Address - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* **Update Address**

## Update Address

### Update Address Overview

The update address operations allow an authorised user to update a persons address on a persons identity record

Update address has three sub-operations available:

* **Set-address** - Allows a user to replace a physical address OR add or replace a postal address with an eSAM validated address
* **Set-unvalidated-address** - Allows a user to replace a physical or add or replace a postal address with an unvalidated address
* **Remove-postal-address** - Allows a user to remove a postal adddress from a persons identity record.

### Set-address

* Allows a user to replace a physical address OR add or replace a postal address with an eSAM validated address

**Set-address - Processing steps:**

1. The user provides details for a new address to add
1. The system requests address validation from the address validation service
1. eSAM returns a validated address - Alt: Address not found
1. The integrating application sends an HTTP Post request using the $set-address operation to the NHI E.g. Post<Endpoint>/Patient/$set-address
1. The request is validated - ALT: Validation failure. Operation Outcome resource returned
1. The new address is added to the NHI and the existing address made inactive
1. The updated patient record is returned with an HTTP 200 ok response
1. The integrating application displays the updated patient details to the user

#### Set-address - In Parameters

* Parameter name: nhi
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The patients nhi number
* Parameter name: version-id
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The current patient version number
* Parameter name: address-type
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: postal or physical
* Parameter name: nz-address-id
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: eSAM validated address id
* Parameter name: address-line
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: first line of the address as returned by eSAM
* Parameter name: address-building-name
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: The building name, this is additional information and is not returned as part of the eSAM address

#### Set-address - Behaviour

* The NHI is validated
* The Patient version-id is validated
* The parameters are validated
* The eSAM details are retrieved for the nz-address-id supplied
* If the eSAM address returned matches the address-line supplied, the new address is added to the NHI and the existing address made inactive

#### Set-address - Example request

```
{
  "resourceType": "Parameters",
  "id": "example",
  "parameter": [
    {
        "name" : "nhi",
        "valueString" : "ZGD9203"
    },
    {
        "name" : "version-id",
        "valueString" : "3321540"
    },
     {
        "name" : "address-type",
        "valueString" : "physical"
    },
    {
        "name" : "nz-address-id",
        "valueString" : "2843216"
    },
    {
        "name" : "address-line",
        "valueString" : "20 Aitken Street"
    },
        {
        "name" : "address-building-name",
        "valueString" : "Freyberg House"
    }
  ]
}


```

#### Set-address - Rules and errors

[For Request rules and errors click here](/general.md#request-rules-and-errors)

##### Patient set-address rules

* All [create patient address rules apply](/createPatient.md#create-patient-address-rules), and
* A Patient Update request must contain the live NHI number for the Patient Record
* A system must source the most recent Patient Record from the NHI before creating a request to update the Patient record
* A request must not result in information, removed from a Patient Record by the NHI Administration team being added

-------

* **Patient set-address errors** 
* **Patient NHI, version number, address type and address-id are all required**
* **Version number is incorrect**
* **address type must be a postal or physical**
* **address-line must match the espatial value: <value>**
 

### Set-unvalidated-address

* Allows a user to replace a physical or add or replace a postal address with an unvalidated address

**Set-unvalidated-address - Processing steps:**

1. The user provides details for a new address to add
1. The integrating application sends an HTTP Post request using the $set-unvalidated-address operation to the NHI E.g. Post<Endpoint>/Patient/$set-unvalidated-address
1. The request is validated - ALT: Validation failure. Operation Outcome resource returned
1. The new address is added to the NHI and the existing address made inactive
1. The updated patient record is returned with an HTTP 200 ok response
1. The integrating application displays the updated patient details to the user

#### Set-unvalidated-address - In Parameters

* Parameter name: nhi
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The patients nhi number
* Parameter name: version-id
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The current patient version number
* Parameter name: not-validated-address-reason
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: 
* Parameter name: address-type
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: postal or physical
* Parameter name: address-building-name
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: 
* Parameter name: address-line-1
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: first line of the address
* Parameter name: address-line-2
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: second line of the address
* Parameter name: address-suburb
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: 
* Parameter name: address-city
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: 
* Parameter name: address-postal-code
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: 
* Parameter name: address-country-code
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: 
* Parameter name: address-domicile-code
  * Parameter type: valueString
  * Mandatory / Optional: Optional*
  * Description: See conditions below

#### Address domicile code - conditions

* If a domicile code is supplied, this is added to the address, if not supplied the suburb and city are used to derive a domicile code from the streets file. If a suburb/city combination is not found in the streets file an error is returned.

#### Set-unvalidated-address - Behaviour

* The NHI is validated
* The Patient versionId is validated
* The parameters are validated
* With a succcesful address add, the new address is added to the NHI and the existing address made inactive

#### Set-unvalidated-address - Example request

```
{
  "resourceType": "Parameters",
  "id": "example",
  "parameter": [
    {
        "name" : "nhi",
        "valueString" : "ZAD2481"
    },
    {
        "name" : "version-id",
        "valueString" : "19232"
    },
     {
        "name" : "not-validated-address-reason",
        "valueString" : "OSEA"
    },
    {
        "name" : "address-type",
        "valueString" : "physical"
    },
    {
        "name" : "address-building-name",
        "valueString" : "Building 11"
    },
    {
        "name" : "address-line-1",
        "valueString" : "67 nowhere street"
    },
    {
        "name" : "address-line-2",
        "valueString" : "nowhere"
    },
 {
        "name" : "address-suburb",
        "valueString" : "darksideodthetracks"
    },
 {
        "name" : "address-city",
        "valueString" : "darkside"
    },
 {
        "name" : "address-postal-code",
        "valueString" : "60606"
    },
     {
        "name" : "address-country-code",
        "valueString" : "NZ"
    }
  ]
}


```

#### Set-unvalidated-address - Rules and errors

[For Request rules and errors click here](/general.md#request-rules-and-errors)

##### Patient set-unvalidated-address rules

* All [create patient address rules apply](/createPatient.md#create-patient-address-rules), and
* A Patient Update request must contain the live NHI number for the Patient Record
* A system must source the most recent Patient Record from the NHI before creating a request to update the Patient record
* A request must not result in information, removed from a Patient Record by the NHI Administration team being added

-------

* **Patient set-unvalidated-address errors** 
* **Patient NHI, version number, address type and address-id are all required**
* **Version number is incorrect**
* **address type must be a postal or physical**
* **address-line must match the espatial value: <value>**
 

### Remove-postal-address

* Allows a user to remove a postal adddress from a persons identity record.

**Remove-postal-address - Processing steps:**

1. The user requests to remove a postal address
1. The integrating application sends an HTTP Post request using the $remove-postal-address operation to the NHI E.g. Post<Endpoint>/Patient/$remove-postal-address
1. The request is validated - ALT: Validation failure. Operation Outcome resource returned
1. The postal address is made inactive
1. The updated patient record is returned with an HTTP 200 ok response
1. The integrating application displays the updated patient details to the user

#### Remove-postal-address - In Parameters

* Parameter name: nhi
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The patients nhi number
* Parameter name: version-id
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The current patient version number

#### Remove-postal-address - Behaviour

* The NHI is validated
* The Patient version-id is validated
* The postal address on the nhi record is made inactive

#### Remove-postal-address - Example request

```
{
  "resourceType": "Parameters",
  "id": "example",
  "parameter": [
    {
        "name" : "nhi",
        "valueString" : "ZAD2481"
    },
    {
        "name" : "version-id",
        "valueString" : "19232"
    }
  ]
}


```

#### Remove-postal-address - Rules and errors

[For Request rules and errors click here](/general.md#request-rules-and-errors)

##### Patient remove-postal-address rules

* All [create patient address rules apply](/createPatient.md#create-patient-address-rules), and
* A Patient Update request must contain the live NHI number for the Patient Record
* A system must source the most recent Patient Record from the NHI before creating a request to update the Patient record

-------

* **Patient remove-postal-address errors** 
* **Patient NHI, version number, address type and address-id are all required**
* **Version number is incorrect**
 

