# Get Patient - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* **Get Patient**

## Get Patient

### Get Patient

#### Overview

The get patient operation allows an authorised user to retrieve a Patient record when a Patients NHI number is known

**Get Patient processing steps:**

1. The user supplies an nhi-id for a patient to be looked up.
1. The integrating application sends an HTTP GET request for the Patient resource using the nhi-id to identify the patient whose information is being requested. E.g. GET<Endpoint>/Patient/ZZZ0008
1. The request is validated - ALT: Validation failure. Operation Outcome resource returned
1. The Patient resource is retrieved from the NHI - ALT: Patient resource not found. Operation Outcome resource returned

1. The response containing the Patient resource is returned - ALT: Where an nhi-id is dormant, a response containing the patient details for the live nhi-id is returned

* Behaviour: 
* The local system sends a request to the NHI with a patient NHI number (nhi-id)
* The NHI locates the nhi-id and returns either the current patient record for the nhi-id (where nhi-id is live) or the current patient data for the linked live nhi-id (where the nhi-id is dormant).
 

#### Get Patient Rules and errors

[For Request rules and errors click here](/general.md#request-rules-and-errors)

* **Get Patient rules** 
* A Patient read request must include a valid nhi-id
 
* **Get Patient errors** 
* **"Invalid nhi-id" (HTTP 404 Not found, Error, Processing)**
 

