# Artifacts Summary - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [NhiCapabilityStatement](CapabilityStatement-NhiCapabilityStatement.md) | A FHIR API in front of the New Zealand NHI |

### Behavior: Operation Definitions 

These are custom operations that can be supported by and/or invoked by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Add a contact to a patient's NHI record.](OperationDefinition-Patient-add-contact.md) | A custom operation to add a contact to a patient's NHI record |
| [Add a name to a patient's NHI record.](OperationDefinition-Patient-add-name.md) | A custom operation to add a name to a patient's NHI record |
| [An operation to inactivate a name that is currently active on a patients record.](OperationDefinition-Patient-inactivate-name.md) | An operation to inactivate a name that is currently active on a patients record |
| [An operation to update a patients citizenship information](OperationDefinition-Patient-update-eligibility.md) | A custom operation to update a patient's citizenship information. |
| [Delete a contact from a patient's NHI record.](OperationDefinition-Patient-delete-contact.md) | A custom operation to delete a contact on a patient's NHI record |
| [Find patient matches using MPI based logic](OperationDefinition-Patient-match.md) | When an NHI number is not known, a match by demographics can be used to find the patient record. For the patient match service, the name and birthdate are required at a minimum. Other demographics such as gender, birthplace and address can be used to improve the match results. The NHI search uses a probabilistic search and returns results in order of their match score with the highest scoring result returned as the first in the bundle. The more match criteria provided, in as complete a form as is known, the more accurate the results returned will be. It is better to enter the complete name even if spelling is not accurate, than entering just part of the name.  To ask an MPI to match a patient, clients use the &quot;$match&quot; operation, which accepts a patient resource. The patient resource submitted to the operation does not have to be complete, nor does it need to pass validation (i.e. mandatory fields don't need to be populated), but it does have to be a valid instance, as it is used as the reference data to match against. |
| [Patient-create](OperationDefinition-Patient-create.md) | A custom operation to create a patient in the NHI |
| [Remove a patient's postal address.](OperationDefinition-Patient-remove-postal-address.md) | A custom operation to remove a patient's postal address |
| [Replace a contact on a patient's NHI record.](OperationDefinition-Patient-replace-contact.md) | A custom operation to replace a contact on a patient's NHI record |
| [Replace a name on a patient's NHI record.](OperationDefinition-Patient-replace-name.md) | A custom operation to replace a name on a patient's record. |
| [Set patient's preferred name](OperationDefinition-Patient-set-preferred-name.md) | An operation to indicate which of the patient's names is preferred |
| [Update a patient address using an unvalidated address.](OperationDefinition-Patient-set-unvalidated-address.md) | A custom operation to Update a patient address using an unvalidated address. |
| [Update a patient's address.](OperationDefinition-Patient-set-address.md) | A custom operation to update a patient's address. |
| [Update patient's birth details](OperationDefinition-Patient-update-birth.md) | A custom operation to to update a patient's birth details. |
| [Update patient's death details](OperationDefinition-Patient-update-death.md) | A custom operation to to update a patient's death details. |
| [Update patient's self-identified demographic information](OperationDefinition-Patient-update-identity.md) | A custom operation to update a patient's self-identified demographic information. |

### Structures: Logical Models 

These define data models that represent the domain covered by this implementation guide in more business-friendly terms than the underlying FHIR resources.

| | |
| :--- | :--- |
| [Patient](StructureDefinition-PatientModel.md) | Representing a person receiving healthcare |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Create NHI Patient](StructureDefinition-CreateNhiPatient.md) | The information to be supplied when requesting that a new Patient resource be created in the NHI. |
| [NHI Patient](StructureDefinition-NhiPatient.md) | The Patient resource exposed by the NHI. |

### Structures: Data Type Profiles 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [NHI Address](StructureDefinition-NhiAddress.md) | Adds additional, NHI specific extensions |
| [NHI ContactPoint](StructureDefinition-NhiContactPoint.md) | Additional attributes for managing patient contact information |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [BirthPlace](StructureDefinition-birth-place.md) | The country where the person was born |
| [LastUpdatedDate](StructureDefinition-lastUpdatedDate.md) | The date this contact was last updated |
| [NameUseExtra](StructureDefinition-name-use-extra.md) | Additional name use codes for NHI names |
| [NhiAddressDerived](StructureDefinition-nhi-address-derived.md) | Address elements that are directly derived from the address validation service |
| [NhiContactPointExtra](StructureDefinition-nhi-contact-point-extra.md) |  |
| [NotValidatedAddressReason](StructureDefinition-not-validated-address-reason.md) | The reason why the address has not been validated |
| [NzAddressId](StructureDefinition-address-id.md) | Uniquely identifies this address as a physical entity. Will remain constant over time even if address administrative data such as DPID change |
| [OriginalText](StructureDefinition-gender-original-text.md) | The uncoded original text that was provided by the patient as their Gender |
| [context](StructureDefinition-Context.md) | Additional information about the context of use of this contact |
| [isPrivate](StructureDefinition-IsPrivate.md) | The email address or phone number may be used to communicate private health information about the individual identified by the NHI |
| [isShared](StructureDefinition-IsShared.md) | The email address or phone number is shared with other people (true or false) |
| [isVerified](StructureDefinition-IsVerified.md) | The format of the email address or phone number is valid (true or false). |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [NHI ContactPoint System Codes](ValueSet-nhi-contact-point-system-code-1.0.md) | System values for a ContactPoint supported by the NHI |
| [NHI ContactPoint Use Codes](ValueSet-nhi-contactpoint-use.md) | Types of contact use supported by the NHI |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [AddContact](Parameters-AddContact.md) | Example $add-contact Request |
| [DeleteContact](Parameters-DeleteContact.md) | Example $delete-contact Request |
| [Match](Parameters-Match.md) | Example $Match (Find NHI) Request |
| [ZAA0792](Patient-ZAA0792.md) | Example Patient dormant identifier, two addresses |
| [ZAT2348](Patient-ZAT2348.md) | Example Patient - deceased |
| [ZAT2496](Patient-ZAT2496.md) | Example Patient - With linked 'dormant' identifier |
| [ZJM9397](Patient-ZJM9397.md) | Example Patient - with validated residential and mailing addresses |
| [ZKC4633](Patient-ZKC4633.md) | Example Patient - with enrolled GP and contact details |
| [create1](Patient-create1.md) | example patient parameter for $create-patient request |
| [create2-error-](Patient-create2-error-.md) | example patient parameter for $create-patient request - errors no-preferred-name, not address line |
| [create3-errors](Patient-create3-errors.md) | example patient parameter for $create-patient request, errors:name must contain either a given or family name(EM02101),no primary address(EM02201), birthdate < 1900 (EM07212), deceasedDateTime < birthdate(EM07215), Baby of name source not NPRF (EM07225) |
| [validate](Parameters-validate.md) | Example $Match (Validate) Request |
| [validate-response](Bundle-validate-response.md) | Example $Match (Validate) Response |

