# NhiAddressDerived - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NhiAddressDerived**

## Extension: NhiAddressDerived 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org.nz/fhir/StructureDefinition/nhi-address-derived | *Version*:1.6.5 |
| Active as of 2026-02-09 | *Computable Name*:NhiAddressDerived |

Address elements that are directly derived from the address validation service

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [NHI Address](StructureDefinition-NhiAddress.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.org.nz.fhir.ig.nhi|current/StructureDefinition/nhi-address-derived)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-nhi-address-derived.csv), [Excel](StructureDefinition-nhi-address-derived.xlsx), [Schematron](StructureDefinition-nhi-address-derived.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "nhi-address-derived",
  "url" : "http://hl7.org.nz/fhir/StructureDefinition/nhi-address-derived",
  "version" : "1.6.5",
  "name" : "NhiAddressDerived",
  "status" : "active",
  "date" : "2026-02-09T22:59:55+00:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "Address elements that are directly derived from the address validation service",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Address"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "definition" : "Address elements that are directly derived from the address validation service"
      },
      {
        "id" : "Extension.extension:depQuintile",
        "path" : "Extension.extension",
        "sliceName" : "depQuintile",
        "short" : "The deprivation quintile",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:depQuintile.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:depQuintile.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "depQuintile"
      },
      {
        "id" : "Extension.extension:depQuintile.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "decimal"
          }
        ]
      },
      {
        "id" : "Extension.extension:meshBlock",
        "path" : "Extension.extension",
        "sliceName" : "meshBlock",
        "short" : "The meshblock for this address",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:meshBlock.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:meshBlock.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "meshBlock"
      },
      {
        "id" : "Extension.extension:meshBlock.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "decimal"
          }
        ]
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org.nz/fhir/StructureDefinition/nhi-address-derived"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
