# Patient - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient**

## Logical Model: Patient 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org.nz/fhir/ig/nhi/StructureDefinition/PatientModel | *Version*:1.6.5 |
| Active as of 2026-02-09 | *Computable Name*:PatientModel |

 
Representing a person receiving healthcare 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.org.nz.fhir.ig.nhi|current/StructureDefinition/PatientModel)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-PatientModel.csv), [Excel](StructureDefinition-PatientModel.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PatientModel",
  "url" : "http://hl7.org.nz/fhir/ig/nhi/StructureDefinition/PatientModel",
  "version" : "1.6.5",
  "name" : "PatientModel",
  "title" : "Patient",
  "status" : "active",
  "date" : "2026-02-09T22:59:55+00:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "Representing a person receiving healthcare",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org.nz/fhir/ig/nhi/StructureDefinition/PatientModel",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Element",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "PatientModel",
        "path" : "PatientModel",
        "short" : "Patient",
        "definition" : "Representing a person receiving healthcare"
      },
      {
        "id" : "PatientModel.name",
        "path" : "PatientModel.name",
        "short" : "Name of the practitioner",
        "definition" : "Name of the practitioner",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "PatientModel.name.source",
        "path" : "PatientModel.name.source",
        "short" : "The source of the name",
        "definition" : "The source of the name",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientModel.gender",
        "path" : "PatientModel.gender",
        "short" : "The patients administrative gender",
        "definition" : "The patients administrative gender",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/administrative-gender"
        }
      },
      {
        "id" : "PatientModel.gender.originalText",
        "path" : "PatientModel.gender.originalText",
        "short" : "The text from which the gender was derived",
        "definition" : "The text from which the gender was derived",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PatientModel.birthDate",
        "path" : "PatientModel.birthDate",
        "short" : "Date of Birth",
        "definition" : "Date of Birth",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ]
      },
      {
        "id" : "PatientModel.birthDate.source",
        "path" : "PatientModel.birthDate.source",
        "short" : "The source of the Date of Birth",
        "definition" : "The source of the Date of Birth",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientModel.deathDate",
        "path" : "PatientModel.deathDate",
        "short" : "Date of Death",
        "definition" : "Date of Death",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ]
      },
      {
        "id" : "PatientModel.deathDate.source",
        "path" : "PatientModel.deathDate.source",
        "short" : "The source of the Date of Death",
        "definition" : "The source of the Date of Death",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientModel.ethnicity",
        "path" : "PatientModel.ethnicity",
        "short" : "Ethnicity of the provider",
        "definition" : "Ethnicity of the provider",
        "min" : 0,
        "max" : "6",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nzhts.digital.health.nz/fhir/ValueSet/ethnic-group-level-4-code"
        }
      },
      {
        "id" : "PatientModel.nhi",
        "path" : "PatientModel.nhi",
        "short" : "National Health Identifier",
        "definition" : "National Health Identifier",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "PatientModel.citizenship",
        "path" : "PatientModel.citizenship",
        "short" : "NZ Citizenship status",
        "definition" : "NZ Citizenship status",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PatientModel.citizenship.source",
        "path" : "PatientModel.citizenship.source",
        "short" : "The source of the citizenship status",
        "definition" : "The source of the citizenship status",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientModel.birthPlace",
        "path" : "PatientModel.birthPlace",
        "short" : "Place of Birth",
        "definition" : "Place of Birth",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "PatientModel.birthPlace.country",
        "path" : "PatientModel.birthPlace.country",
        "short" : "Country of Birth",
        "definition" : "Country of Birth",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PatientModel.birthPlace.place",
        "path" : "PatientModel.birthPlace.place",
        "short" : "Area within country",
        "definition" : "Area within country",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PatientModel.birthPlace.source",
        "path" : "PatientModel.birthPlace.source",
        "short" : "The source of the Birth Place",
        "definition" : "The source of the Birth Place",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientModel.residency",
        "path" : "PatientModel.residency",
        "short" : "residency status",
        "definition" : "residency status",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PatientModel.residency.source",
        "path" : "PatientModel.residency.source",
        "short" : "The source of the residency status",
        "definition" : "The source of the residency status",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
