# NHI Patient - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NHI Patient**

## Resource Profile: NHI Patient 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org.nz/fhir/StructureDefinition/NhiPatient | *Version*:1.6.5 |
| Active as of 2026-02-09 | *Computable Name*:NhiPatient |

 
The Patient resource exposed by the NHI. 

 
Describe the Patient resource exposed by the NHI 

### Core NHI Profile attributes

The NHI Patient resource represents the nationally held identity data for a patient.

This includes the core NHI Profile attributes:

* name (including alternative names such as maiden names)
* NHI number (live and any dormants)
* address
* date of birth
* gender
* New Zealand citizenship status
* place of birth
* ethnicity
* date of death

The core NHI Profile attributes are returned to all users that have read and/or $match access to the NHI

### Key differences from HL7 FHIR Patient specification

* Ethnicity extension
* NZ Citizenship extension
* Dhb extension
* Birthplace extension
* Name 
* information source extension
* preferred extension
* nhi-name-use-extra extension
 
* Gender original text extension
* Birthdate information source extension
* Deceased date information source extension
* Address 
* nz-geocode extension
* suburb extension
* building-name extension
* domicile-code extension
* notValidatedAddressReason extension
* nz-address-id extension
* nz-address-derived extension
 

### New NHI Number Format and check digit calculation

For more information [click here](https://www.health.govt.nz/our-work/health-identity/national-health-index/upcoming-changes-nhi-numbers) for website links or [click here](https://www.tewhatuora.govt.nz/publications/hiso-100462022-consumer-health-identity-standard/) for the consumer health identity standard, that includes the check digit calculation.

### Patient's General Practice

The details for a patient’s General Practice (GP) are returned in the NHI Patient Profile to users who have permission to access a patient’s National Enrolment Service (NES) information.

This is an additional permission required on your NHI FHIR account.

The NES details are maintained in real time in the NES database, which holds the relationship of a Patient (NHI number), to their GP Practice (hpi-organisation-id), GP clinic (hpi-facility-id) and where available the patient's usual doctor (hpi-person-id / CPN).

Changes to the NES in October 2023 allows a patient’s GP Practice details to be recorded for both patients that are funded and also patients who are registered with a practice but not eligible for PHO funding. This change allows the Get Patient response to return the GP Practice details for both types of patients.

The expiry date for a registered patient is set to 01/01/2100 whereas the expiry date for an enrolled patient is never more than 3 years in the future.

For more information on what is available in the NES FHIR API please see [NES UAT Implementation guide](https://nes-ig.hip-uat.digital.health.nz).

In the NHI the patient's GP is only returned with a read on the resource. It is not returned in the $match response – even if a user has the correct permissions.

The patient version-id does not change when the GP changes. This is because the patient's GP is not held in the NHI but is retrieved from the National Enrolment Service and returned along with the NHI details in the NHI Patient profile. The patient version-id only reflects changes to details held on the NHI.

For information on enrolment history, re-enrolment dates, enrolment status, or the last visit date (qualified encounter date) please subscribe to the NES.

A subset of the NES enrolment information is returned in the NHI FHIR GET response.

Enrolment information is returned in two places in the NHI patient profile:

* the "generalPractitioner" attribute: This is the NES enrolment id.
* the "contained" PractitionerRole resource: This holds the NES enrolment information as described below.

#### NES to FHIR mapping

* FHIR attribute (PractitionerRole Resource): id
  * NES Enrolment Information: The NES enrolment id
  * Description: Unique identifier of the patient's enrolment record.This will change when a patient transfers to a new practice, but will not reflect minor changes within an enrolment.
* FHIR attribute (PractitionerRole Resource): Period.start
  * NES Enrolment Information: enrolment.startDate
  * Description: The date on which the Enrolment starts
* FHIR attribute (PractitionerRole Resource): Period.end
  * NES Enrolment Information: enrolment.expiryDate
  * Description: The future date on which the Enrolment will expire.
* FHIR attribute (PractitionerRole Resource): Practitioner (reference / display)
  * NES Enrolment Information: Practitioner identifier (CPN) and name
  * Description: The hpi-person-id (CPN) and name of the Practitioner who primarily provides the service to the person.
* FHIR attribute (PractitionerRole Resource): Organization (reference / display)
  * NES Enrolment Information: enrolling organisation ID and name
  * Description: The hpi-organisation-id and name of the Organisation who the person enrols with for the Heath Service.
* FHIR attribute (PractitionerRole Resource): Location (reference / display)
  * NES Enrolment Information: Facility ID and name
  * Description: The hpi-facility-id and name of the Facility where the person primarily receives the service.

#### Example of contained resource

```
"contained": [
        {
            "resourceType": "PractitionerRole",
            "id": "525599",
            "period": {
                "start": "2023-01-26T00:00:00+13:00",
                "end": "2026-01-26T00:00:00+13:00"
            },
            "practitioner": {
                "reference": "Practitioner/25ADNX",
                "display": "Dr Nick"
            },
            "organization": {
                "reference": "Organization/GAAAAA-0"
                "display": "Riviera Health Care"
            },
            "location": [
                {
                    "reference": "Location/FZZ862-H",
                    "display": "Dr Nick's Guaranteed Health Clinic"
                }
            ]
        }
    ]

```

### Patient's Contact details

The patient’s contact details are returned in the Patient.telecom attribute to users who have permission to access Patient Preferences. This is an additional permission required on your NHI FHIR account.

The contact details are only returned with a read on the resource. They are not returned in the $match response – even if a user has the correct permissions.

The patient version-id does not change when the patient's contact details change. This is because the patient's contact details are not held in the NHI but are retrieved from the National Enrolment Service and returned along with the NHI details in the NHI Patient profile. The Patient Version-id only reflects changes to details held on the NHI.

The information returned may include:

* 1x email address,
* 1x home phone number,
* 1x mobile phone number

#### Example of Patient contact details

```
    "telecom": [
    {
      "id": "17",
      "system": "email",
      "value": "test.contact@testContact.com",
      "use": "home",
      "extension": [
        {
          "url": "http://hl7.org.nz/fhir/StructureDefinition/isVerified",
          "valueBoolean": true
        },
        {
          "url": "http://hl7.org.nz/fhir/StructureDefinition/isPrivate",
          "valueBoolean": true
        },
        {
          "url": "http://hl7.org.nz/fhir/StructureDefinition/isShared",
          "valueBoolean": false
        },
        {
          "url": "http://hl7.org.nz/fhir/StructureDefinition/context",
          "valueString": "any time"
        },
        {
          "url": "http://hl7.org.nz/fhir/StructureDefinition/lastUpdatedDate",
          "valueDate": "2024-07-21"
        }
      ]
    },
    {
      "id": "18",
      "system": "phone",
      "value": "027 123 4567",
      "use": "mobile",
      "extension": [
        {
          "url": "http://hl7.org.nz/fhir/StructureDefinition/isVerified",
          "valueBoolean": true
        },
        {
          "url": "http://hl7.org.nz/fhir/StructureDefinition/isPrivate",
          "valueBoolean": true
        },
        {
          "url": "http://hl7.org.nz/fhir/StructureDefinition/isShared",
          "valueBoolean": false
        },
        {
          "url": "http://hl7.org.nz/fhir/StructureDefinition/context",
          "valueString": "between 9am and 6pm only"
        }
      ]
    },
    {
      "id": "19",
      "system": "phone",
      "value": "045882334",
      "use": "home",
      "extension": [
        {
          "url": "http://hl7.org.nz/fhir/StructureDefinition/isVerified",
          "valueBoolean": true
        },
        {
          "url": "http://hl7.org.nz/fhir/StructureDefinition/isPrivate",
          "valueBoolean": true
        },
        {
          "url": "http://hl7.org.nz/fhir/StructureDefinition/isShared",
          "valueBoolean": true
        },
        {
          "url": "http://hl7.org.nz/fhir/StructureDefinition/context",
          "valueString": "between 9am and 6pm only"
        },
        {
          "url": "http://hl7.org.nz/fhir/StructureDefinition/lastUpdatedDate",
          "valueDate": "2025-01-17"
        }
      ]
    }
  ]

```

**Usages:**

* Derived from this Profile: [Create NHI Patient](StructureDefinition-CreateNhiPatient.md)
* Examples for this Profile: [Patient/ZAA0792](Patient-ZAA0792.md), [Patient/ZAT2348](Patient-ZAT2348.md), [Patient/ZAT2496](Patient-ZAT2496.md), [Patient/ZJM9397](Patient-ZJM9397.md) and [Patient/ZKC4633](Patient-ZKC4633.md)
* CapabilityStatements using this Profile: [CapabilityStatement[http://hl7.org.nz/fhir/ig/nhi/CapabilityStatement/NhiCapabilityStatement|1.6.5]](CapabilityStatement-NhiCapabilityStatement.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.org.nz.fhir.ig.nhi|current/StructureDefinition/NhiPatient)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-NhiPatient.csv), [Excel](StructureDefinition-NhiPatient.xlsx), [Schematron](StructureDefinition-NhiPatient.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "NhiPatient",
  "url" : "http://hl7.org.nz/fhir/StructureDefinition/NhiPatient",
  "version" : "1.6.5",
  "name" : "NhiPatient",
  "title" : "NHI Patient",
  "status" : "active",
  "date" : "2026-02-09T22:59:55+00:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "The Patient resource exposed by the NHI.",
  "purpose" : "Describe the Patient resource exposed by the NHI",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://hl7.org.nz/fhir/StructureDefinition/NzPatient",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient",
        "constraint" : [
          {
            "key" : "nhi-nz-pat-1",
            "severity" : "error",
            "human" : "only allows certain name name use values",
            "expression" : "Patient.name.where( (use.empty()) or (use='nickname') or (use = 'maiden') or (use = 'temp') )",
            "source" : "http://hl7.org.nz/fhir/StructureDefinition/NhiPatient"
          },
          {
            "key" : "nhi-nz-pat-2",
            "severity" : "error",
            "human" : "home phone 0..1",
            "expression" : "Patient.telecom.where(use='home' and system = 'phone').count() < 2",
            "source" : "http://hl7.org.nz/fhir/StructureDefinition/NhiPatient"
          },
          {
            "key" : "nhi-nz-pat-3",
            "severity" : "error",
            "human" : "mobile phone 0..1",
            "expression" : "Patient.telecom.where(use='mobile' and system = 'phone').count() < 2",
            "source" : "http://hl7.org.nz/fhir/StructureDefinition/NhiPatient"
          },
          {
            "key" : "nhi-nz-pat-4",
            "severity" : "error",
            "human" : "email 0..1",
            "expression" : "Patient.telecom.where(system = 'email').count() < 2",
            "source" : "http://hl7.org.nz/fhir/StructureDefinition/NhiPatient"
          },
          {
            "key" : "nhi-nz-pat-5",
            "severity" : "error",
            "human" : "character restrictions for contact context",
            "expression" : "Patient.telecom.extension[context].valueString.all(matches('^[-a-zA-Z0-9@:%._~#=?&\\/]*$'))",
            "source" : "http://hl7.org.nz/fhir/StructureDefinition/NhiPatient"
          },
          {
            "key" : "nhi-nz-pat-6",
            "severity" : "error",
            "human" : "Contact context must be less than 256 characters",
            "expression" : "Patient.telecom.extension[context].256.all(length()<256)",
            "source" : "http://hl7.org.nz/fhir/StructureDefinition/NhiPatient"
          }
        ]
      },
      {
        "id" : "Patient.contained",
        "path" : "Patient.contained",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "description" : "Slicing to specifiy a PractitionerRole resource may be returned as a contained resource for the Patient's General Practitioner information",
          "rules" : "closed"
        }
      },
      {
        "id" : "Patient.contained:GP",
        "path" : "Patient.contained",
        "sliceName" : "GP",
        "short" : "Contained resource for the Patient's enrolled general Practitioner",
        "definition" : "Contained resource for the General Practice that the patient is enrolled with",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "PractitionerRole"
          }
        ]
      },
      {
        "id" : "Patient.extension:ethnicity",
        "path" : "Patient.extension",
        "sliceName" : "ethnicity",
        "max" : "6"
      },
      {
        "id" : "Patient.extension:ethnicity.value[x]:valueCodeableConcept",
        "path" : "Patient.extension.value[x]",
        "sliceName" : "valueCodeableConcept",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nzhts.digital.health.nz/fhir/ValueSet/ethnic-group-level-4-code|2.0"
        }
      },
      {
        "id" : "Patient.extension:nzCitizen",
        "path" : "Patient.extension",
        "sliceName" : "nzCitizen",
        "short" : "This field indicates New Zealand citizenship status of the patient",
        "definition" : "This field is used to indicate the New Zealand citizenship status of the patient"
      },
      {
        "id" : "Patient.extension:nzCitizen.extension:source",
        "path" : "Patient.extension.extension",
        "sliceName" : "source"
      },
      {
        "id" : "Patient.extension:nzCitizen.extension:source.value[x]:valueCodeableConcept",
        "path" : "Patient.extension.extension.value[x]",
        "sliceName" : "valueCodeableConcept",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nzhts.digital.health.nz/fhir/ValueSet/nz-citizenship-source-code"
        }
      },
      {
        "id" : "Patient.extension:domicile-code",
        "path" : "Patient.extension",
        "sliceName" : "domicile-code",
        "max" : "0"
      },
      {
        "id" : "Patient.extension:pho",
        "path" : "Patient.extension",
        "sliceName" : "pho",
        "max" : "0"
      },
      {
        "id" : "Patient.extension:sex-at-birth",
        "path" : "Patient.extension",
        "sliceName" : "sex-at-birth",
        "max" : "0"
      },
      {
        "id" : "Patient.extension:iwi",
        "path" : "Patient.extension",
        "sliceName" : "iwi",
        "max" : "0"
      },
      {
        "id" : "Patient.extension:birthPlace",
        "path" : "Patient.extension",
        "sliceName" : "birthPlace",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org.nz/fhir/StructureDefinition/birth-place"]
          }
        ]
      },
      {
        "id" : "Patient.identifier",
        "path" : "Patient.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "rules" : "closed"
        }
      },
      {
        "id" : "Patient.identifier.type",
        "path" : "Patient.identifier.type",
        "max" : "0"
      },
      {
        "id" : "Patient.identifier.period",
        "path" : "Patient.identifier.period",
        "max" : "0"
      },
      {
        "id" : "Patient.identifier:NHI",
        "path" : "Patient.identifier",
        "sliceName" : "NHI"
      },
      {
        "id" : "Patient.identifier:NHI.type",
        "path" : "Patient.identifier.type",
        "max" : "0"
      },
      {
        "id" : "Patient.identifier:NHI.period",
        "path" : "Patient.identifier.period",
        "max" : "0"
      },
      {
        "id" : "Patient.active",
        "path" : "Patient.active",
        "max" : "0"
      },
      {
        "id" : "Patient.name.extension",
        "path" : "Patient.name.extension",
        "min" : 1
      },
      {
        "id" : "Patient.name.extension:information-source",
        "path" : "Patient.name.extension",
        "sliceName" : "information-source",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org.nz/fhir/StructureDefinition/information-source"
            ]
          }
        ]
      },
      {
        "id" : "Patient.name.extension:information-source.value[x]:valueCodeableConcept",
        "path" : "Patient.name.extension.value[x]",
        "sliceName" : "valueCodeableConcept",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nzhts.digital.health.nz/fhir/ValueSet/name-source-code"
        }
      },
      {
        "id" : "Patient.name.extension:preferred",
        "path" : "Patient.name.extension",
        "sliceName" : "preferred",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/iso21090-preferred"]
          }
        ]
      },
      {
        "id" : "Patient.name.extension:nhi-name-use-extra",
        "path" : "Patient.name.extension",
        "sliceName" : "nhi-name-use-extra",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org.nz/fhir/StructureDefinition/name-use-extra"]
          }
        ]
      },
      {
        "id" : "Patient.name.use",
        "path" : "Patient.name.use",
        "short" : "temp | nickname | maiden"
      },
      {
        "id" : "Patient.name.text",
        "path" : "Patient.name.text",
        "max" : "0"
      },
      {
        "id" : "Patient.name.given",
        "path" : "Patient.name.given",
        "short" : "Given name and other given name(s)",
        "definition" : "The given name and other given name(s) for the patient",
        "max" : "2"
      },
      {
        "id" : "Patient.name.prefix",
        "path" : "Patient.name.prefix",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nzhts.digital.health.nz/fhir/ValueSet/name-prefix-code"
        }
      },
      {
        "id" : "Patient.name.suffix",
        "path" : "Patient.name.suffix",
        "max" : "0"
      },
      {
        "id" : "Patient.name.period",
        "path" : "Patient.name.period",
        "max" : "0"
      },
      {
        "id" : "Patient.telecom",
        "path" : "Patient.telecom",
        "short" : "The Paient's contact details",
        "max" : "3",
        "type" : [
          {
            "code" : "ContactPoint",
            "profile" : [
              "http://hl7.org.nz/fhir/StructureDefinition/nhi-contact-point"
            ]
          }
        ]
      },
      {
        "id" : "Patient.telecom.system",
        "path" : "Patient.telecom.system",
        "short" : "phone | email",
        "definition" : "The system for this contact point - constrained to phone | email",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nzhts.digital.health.nz/fhir/ValueSet/nhi-contact-point-system-code"
        }
      },
      {
        "id" : "Patient.telecom.use",
        "path" : "Patient.telecom.use",
        "short" : "home | mobile",
        "definition" : "The purpose of this contact point - constrained to home | mobile",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nzhts.digital.health.nz/fhir/ValueSet/nhiContactUseType"
        }
      },
      {
        "id" : "Patient.telecom.rank",
        "path" : "Patient.telecom.rank",
        "max" : "0"
      },
      {
        "id" : "Patient.telecom.period",
        "path" : "Patient.telecom.period",
        "max" : "0"
      },
      {
        "id" : "Patient.gender.extension",
        "path" : "Patient.gender.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Patient.gender.extension:originalText",
        "path" : "Patient.gender.extension",
        "sliceName" : "originalText",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org.nz/fhir/StructureDefinition/gender-original-text"
            ]
          }
        ]
      },
      {
        "id" : "Patient.birthDate.extension",
        "path" : "Patient.birthDate.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Patient.birthDate.extension:information-source",
        "path" : "Patient.birthDate.extension",
        "sliceName" : "information-source",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org.nz/fhir/StructureDefinition/information-source"
            ]
          }
        ]
      },
      {
        "id" : "Patient.birthDate.extension:information-source.value[x]:valueCodeableConcept",
        "path" : "Patient.birthDate.extension.value[x]",
        "sliceName" : "valueCodeableConcept",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nzhts.digital.health.nz/fhir/ValueSet/date-of-birth-source-code"
        }
      },
      {
        "id" : "Patient.deceased[x]",
        "path" : "Patient.deceased[x]",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Patient.deceased[x].extension",
        "path" : "Patient.deceased[x].extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Patient.deceased[x].extension:information-source",
        "path" : "Patient.deceased[x].extension",
        "sliceName" : "information-source",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org.nz/fhir/StructureDefinition/information-source"
            ]
          }
        ]
      },
      {
        "id" : "Patient.deceased[x].extension:information-source.value[x]:valueCodeableConcept",
        "path" : "Patient.deceased[x].extension.value[x]",
        "sliceName" : "valueCodeableConcept",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://nzhts.digital.health.nz/fhir/ValueSet/dod-information-source-code"
        }
      },
      {
        "id" : "Patient.address",
        "path" : "Patient.address",
        "type" : [
          {
            "code" : "Address",
            "profile" : ["http://hl7.org.nz/fhir/StructureDefinition/NhiAddress"]
          }
        ]
      },
      {
        "id" : "Patient.address.line",
        "path" : "Patient.address.line",
        "min" : 1
      },
      {
        "id" : "Patient.maritalStatus",
        "path" : "Patient.maritalStatus",
        "max" : "0"
      },
      {
        "id" : "Patient.multipleBirth[x]",
        "path" : "Patient.multipleBirth[x]",
        "max" : "0"
      },
      {
        "id" : "Patient.photo",
        "path" : "Patient.photo",
        "max" : "0"
      },
      {
        "id" : "Patient.contact",
        "path" : "Patient.contact",
        "max" : "0"
      },
      {
        "id" : "Patient.communication",
        "path" : "Patient.communication",
        "max" : "0"
      },
      {
        "id" : "Patient.generalPractitioner",
        "path" : "Patient.generalPractitioner",
        "short" : "Reference for the Patient's enrolled general Practitioner",
        "definition" : "The reference for the General Practice that the patient is enrolled with",
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/PractitionerRole"]
          }
        ]
      },
      {
        "id" : "Patient.managingOrganization",
        "path" : "Patient.managingOrganization",
        "max" : "0"
      },
      {
        "id" : "Patient.link",
        "path" : "Patient.link",
        "max" : "0"
      }
    ]
  }
}

```
