<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile NzContactPoint
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:ContactPoint</sch:title>
    <sch:rule context="f:ContactPoint">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/contactpoint-purpose']) &lt;= 0">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/contactpoint-purpose': maximum cardinality of 'extension' is 0</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/isVerified']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/isVerified': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/isShared']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/isShared': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/isPrivate']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/isPrivate': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/context']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/context': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/lastUpdatedDate']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/lastUpdatedDate': maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
