# create3-errors - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **create3-errors**

## Example Patient: create3-errors

Profile: [Create NHI Patient](StructureDefinition-CreateNhiPatient.md)

(temp) Male, DoB: 1899-06-05

-------

| | |
| :--- | :--- |
| Deceased: | 1888-10-18 |
| Contact Detail | 74 Chancellor Street Palmerston North 4412 NZ (home) (NZ Suburb: Awapuni) |
| null: | * country: New Zealand
* source: Birth Certificate
 |
| NZ Citizenship: | * status: Yes
* source: Birth Certificate
 |
| [NZ Ethnicity](https://fhir.org.nz/ig/base/StructureDefinition-nz-ethnicity.html) | Māori |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "create3-errors",
  "meta" : {
    "profile" : [
      "http://hl7.org.nz/fhir/StructureDefinition/CreateNhiPatient"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org.nz/fhir/StructureDefinition/nz-ethnicity",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://standards.digital.health.nz/ns/ethnic-group-level-4-code",
            "code" : "21111",
            "display" : "Māori"
          }
        ]
      }
    },
    {
      "extension" : [
        {
          "url" : "status",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/nz-citizenship-status-code",
                "code" : "yes",
                "display" : "Yes"
              }
            ]
          }
        },
        {
          "url" : "source",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/information-source-code",
                "code" : "BRCT",
                "display" : "Birth Certificate"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org.nz/fhir/StructureDefinition/nz-citizenship"
    },
    {
      "extension" : [
        {
          "url" : "country",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "urn:iso:std:iso:3166",
                "code" : "NZ",
                "display" : "New Zealand"
              }
            ]
          }
        },
        {
          "url" : "source",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/information-source-code",
                "code" : "BRCT",
                "display" : "Birth Certificate"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org.nz/fhir/StructureDefinition/birth-place"
    }
  ],
  "name" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/information-source",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/information-source-code",
                "code" : "GREG",
                "display" : "Proof not Sighted"
              }
            ]
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-preferred",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/name-use-extra",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/nhi-name-use-extra-code",
                "code" : "BABYOF"
              }
            ]
          }
        }
      ],
      "use" : "temp"
    }
  ],
  "gender" : "male",
  "birthDate" : "1899-06-05",
  "_birthDate" : {
    "extension" : [
      {
        "url" : "http://hl7.org.nz/fhir/StructureDefinition/information-source",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://standards.digital.health.nz/ns/information-source-code",
              "code" : "HL7",
              "display" : "HL7 applied"
            }
          ]
        }
      }
    ]
  },
  "deceasedDateTime" : "1888-10-18",
  "_deceasedDateTime" : {
    "extension" : [
      {
        "url" : "http://hl7.org.nz/fhir/StructureDefinition/information-source",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://standards.digital.health.nz/ns/information-source-code",
              "code" : "DREG",
              "display" : "Death Register"
            }
          ]
        }
      }
    ]
  },
  "address" : [
    {
      "id" : "2",
      "extension" : [
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/nz-address-id",
          "valueString" : "12345"
        },
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/suburb",
          "valueString" : "Awapuni"
        }
      ],
      "use" : "home",
      "type" : "postal",
      "line" : ["74 Chancellor Street"],
      "city" : "Palmerston North",
      "postalCode" : "4412",
      "country" : "NZ"
    }
  ]
}

```
