# ZKC4633 - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ZKC4633**

## Example Patient: ZKC4633

version: 3384979

Profile: [NHI Patient](StructureDefinition-NhiPatient.md)

Rickey Amalia Aufderhar Female, DoB: 2021-12-29 ( https://standards.digital.health.nz/ns/nhi-id#NHI#ZKC4633 (use: official, ))

-------

| | |
| :--- | :--- |
| Alt. Name: | Baby of Jane Aufderhar (Temp) |
| Contact Detail | * [test.contact@testContact.com](mailto:test.contact@testContact.com)
* ph: 027 123 4567(Mobile)
* ph: 045882334(Home)
* Other Road (home)
 |
| Links: | * General Practitioner: [PractitionerRole: period = 2023-02-21 00:00:00+1300 --> 2026-02-21 00:00:00+1300](#hcZKC4633/20014909)
 |
| NZ Citizenship: | * source: Proof not Sighted
* status: Yes
 |
| [NZ Ethnicity](https://fhir.org.nz/ig/base/StructureDefinition-nz-ethnicity.html) | New Zealand European |

-------

**Contained Resource**

-------

**period**: 2023-02-21 00:00:00+1300 --> 2026-02-21 00:00:00+1300

**practitioner**: [TestOne Prefix-Test](Practitioner/99ZZZS)

**organization**: [Ministry of Health](Organization/G00001-G)

**location**: [Live Facilty](Location/FZZ999-B)



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "ZKC4633",
  "meta" : {
    "versionId" : "3384979",
    "profile" : ["http://hl7.org.nz/fhir/StructureDefinition/NhiPatient"]
  },
  "contained" : [
    {
      "resourceType" : "PractitionerRole",
      "id" : "20014909",
      "period" : {
        "start" : "2023-02-21T00:00:00+13:00",
        "end" : "2026-02-21T00:00:00+13:00"
      },
      "practitioner" : {
        "reference" : "Practitioner/99ZZZS",
        "display" : "TestOne Prefix-Test"
      },
      "organization" : {
        "reference" : "Organization/G00001-G",
        "display" : "Ministry of Health"
      },
      "location" : [
        {
          "reference" : "Location/FZZ999-B",
          "display" : "Live Facilty"
        }
      ]
    }
  ],
  "extension" : [
    {
      "url" : "http://hl7.org.nz/fhir/StructureDefinition/nz-ethnicity",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://standards.digital.health.nz/ns/ethnic-group-level-4-code",
            "version" : "2.0",
            "code" : "11111",
            "display" : "New Zealand European"
          }
        ],
        "text" : "New Zealand European"
      }
    },
    {
      "extension" : [
        {
          "url" : "source",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/information-source-code",
                "version" : "1.0.0",
                "code" : "NPRF",
                "display" : "Proof not Sighted"
              }
            ],
            "text" : "Proof not Sighted"
          }
        },
        {
          "url" : "status",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/nz-citizenship-status-code",
                "version" : "1.1.0",
                "code" : "yes",
                "display" : "Yes"
              }
            ],
            "text" : "Yes"
          }
        }
      ],
      "url" : "http://hl7.org.nz/fhir/StructureDefinition/nz-citizenship"
    }
  ],
  "identifier" : [
    {
      "use" : "official",
      "system" : "https://standards.digital.health.nz/ns/nhi-id",
      "value" : "ZKC4633",
      "assigner" : {
        "reference" : "Organization/G00001-G"
      }
    }
  ],
  "name" : [
    {
      "id" : "10",
      "extension" : [
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/information-source",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/information-source-code",
                "version" : "1.0.0",
                "code" : "NPRF",
                "display" : "Proof not Sighted"
              }
            ],
            "text" : "Proof not Sighted"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-preferred",
          "valueBoolean" : false
        },
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/name-use-extra",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/nhi-name-use-extra-code",
                "code" : "BABYOF",
                "display" : "babyof"
              }
            ]
          }
        }
      ],
      "use" : "temp",
      "family" : "Aufderhar",
      "given" : ["Baby of Jane"]
    },
    {
      "id" : "13",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-preferred",
          "valueBoolean" : true
        }
      ],
      "family" : "Aufderhar",
      "given" : ["Rickey", "Amalia"]
    }
  ],
  "telecom" : [
    {
      "id" : "17",
      "extension" : [
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/isVerified",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/isPrivate",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/isShared",
          "valueBoolean" : false
        },
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/context",
          "valueString" : "any time"
        },
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/lastUpdatedDate",
          "valueDate" : "2024-07-21"
        }
      ],
      "system" : "email",
      "value" : "test.contact@testContact.com",
      "use" : "home"
    },
    {
      "id" : "18",
      "extension" : [
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/isVerified",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/isPrivate",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/isShared",
          "valueBoolean" : false
        },
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/context",
          "valueString" : "between 9am and 6pm only"
        }
      ],
      "system" : "phone",
      "value" : "027 123 4567",
      "use" : "mobile"
    },
    {
      "id" : "19",
      "extension" : [
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/isVerified",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/isPrivate",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/isShared",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/context",
          "valueString" : "between 9am and 6pm only"
        },
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/lastUpdatedDate",
          "valueDate" : "2025-01-17"
        }
      ],
      "system" : "phone",
      "value" : "045882334",
      "use" : "home"
    }
  ],
  "gender" : "female",
  "birthDate" : "2021-12-29",
  "_birthDate" : {
    "extension" : [
      {
        "url" : "http://hl7.org.nz/fhir/StructureDefinition/information-source",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://standards.digital.health.nz/ns/information-source-code",
              "version" : "1.0.0",
              "code" : "NPRF",
              "display" : "Proof not Sighted"
            }
          ],
          "text" : "Proof not Sighted"
        }
      }
    ]
  },
  "address" : [
    {
      "id" : "24",
      "extension" : [
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/not-validated-address-reason",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/address-not-validated-reason-code",
                "version" : "1.1",
                "code" : "OSEA",
                "display" : "Overseas Address"
              }
            ],
            "text" : "Overseas Address"
          }
        },
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/domicile-code",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/domicile-code",
                "code" : "9999",
                "display" : "Overseas resident"
              }
            ],
            "text" : "Overseas resident"
          }
        }
      ],
      "use" : "home",
      "type" : "physical",
      "line" : ["Other Road"]
    }
  ],
  "generalPractitioner" : [
    {
      "reference" : "#20014909"
    }
  ]
}

```
