# Update patient's death details - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Update patient's death details**

## OperationDefinition: Update patient's death details 

| | |
| :--- | :--- |
| *Official URL*:https://nhi-ig.hip.digital.health.nz/OperationDefinition/update-death | *Version*:1.6.5 |
| Draft as of 2023-06-12 | *Computable Name*:Update Death Details |

 
Update patient's death details. 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "Patient-update-death",
  "url" : "https://nhi-ig.hip.digital.health.nz/OperationDefinition/update-death",
  "version" : "1.6.5",
  "name" : "Update Death Details",
  "title" : "Update patient's death details",
  "status" : "draft",
  "kind" : "operation",
  "experimental" : false,
  "date" : "2023-06-12T12:47:40+10:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "Update patient's death details.",
  "affectsState" : true,
  "code" : "update-death",
  "comment" : "The NHI is validated, the versionId is validated, the parameters validated. If all request parameters are valid the included items are updated on the Patients NHI record.",
  "resource" : ["Patient"],
  "system" : false,
  "type" : false,
  "instance" : true,
  "parameter" : [
    {
      "name" : "nhi",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The Patient's nhi number",
      "type" : "string"
    },
    {
      "name" : "version-id",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The current value of the patient resources meta.versionId",
      "type" : "string"
    },
    {
      "name" : "death-date",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "The patient's date of death",
      "type" : "string"
    },
    {
      "name" : "date-of-death-information-source",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The information source for the patient's date of death",
      "type" : "string"
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "The updated patient resource",
      "type" : "Patient"
    },
    {
      "name" : "failure",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "Error response",
      "type" : "OperationOutcome"
    }
  ]
}

```
