# Replace a name on a patient's NHI record. - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Replace a name on a patient's NHI record.**

## OperationDefinition: Replace a name on a patient's NHI record. 

| | |
| :--- | :--- |
| *Official URL*:https://nhi-ig.hip.digital.health.nz/OperationDefinition/replace-name | *Version*:1.6.5 |
| Draft as of 2023-06-12 | *Computable Name*:Replace Name |

 
An operation to to replace a name on a patient's record. 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "Patient-replace-name",
  "url" : "https://nhi-ig.hip.digital.health.nz/OperationDefinition/replace-name",
  "version" : "1.6.5",
  "name" : "Replace Name",
  "title" : "Replace a name on a patient's NHI record.",
  "status" : "draft",
  "kind" : "operation",
  "experimental" : false,
  "date" : "2023-06-12T12:47:40+10:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "An operation to to replace a name on a patient's record.",
  "affectsState" : true,
  "code" : "replace-name",
  "comment" : "The NHI is validated, the versionId is validated, the parameters validated. If all request parameters are valid the new name is added to the nhi record, and the old one is removed.",
  "resource" : ["Patient"],
  "system" : false,
  "type" : false,
  "instance" : true,
  "parameter" : [
    {
      "name" : "nhi",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The Patient's nhi number",
      "type" : "string"
    },
    {
      "name" : "version-id",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The current value of the patient resources meta.versionId",
      "type" : "string"
    },
    {
      "name" : "replace-id",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The id for the name on the nhi to be replaced",
      "type" : "integer"
    },
    {
      "name" : "use",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "the name use qualifier for a name",
      "type" : "string"
    },
    {
      "name" : "prefix",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "the name prefix",
      "type" : "string"
    },
    {
      "name" : "given-1",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "the first or given name",
      "type" : "string"
    },
    {
      "name" : "given-2",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "the middle or other given name(s)",
      "type" : "string"
    },
    {
      "name" : "family",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "the family name",
      "type" : "string"
    },
    {
      "name" : "preferred",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "attribute used to indicate whether the name is preferred or not",
      "type" : "string"
    },
    {
      "name" : "information-source",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "The information source for the patient's name",
      "type" : "string"
    },
    {
      "name" : "nhi-name-use-extra",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "an attribute used to qualify pre-allocated and babyof names",
      "type" : "string"
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "The updated patient resource",
      "type" : "Patient"
    },
    {
      "name" : "failure",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "Error response",
      "type" : "OperationOutcome"
    }
  ]
}

```
