# An operation to inactivate a name that is currently active on a patients record. - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **An operation to inactivate a name that is currently active on a patients record.**

## OperationDefinition: An operation to inactivate a name that is currently active on a patients record. 

| | |
| :--- | :--- |
| *Official URL*:https://nhi-ig.hip.digital.health.nz/OperationDefinition/inactivate-name | *Version*:1.6.5 |
| Draft as of 2023-06-12 | *Computable Name*:Inactivate Name |

 
Inactivate name 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "Patient-inactivate-name",
  "url" : "https://nhi-ig.hip.digital.health.nz/OperationDefinition/inactivate-name",
  "version" : "1.6.5",
  "name" : "Inactivate Name",
  "title" : "An operation to inactivate a name that is currently active on a patients record.",
  "status" : "draft",
  "kind" : "operation",
  "experimental" : false,
  "date" : "2023-06-12T12:47:40+10:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "Inactivate name",
  "affectsState" : true,
  "code" : "inactivate-name",
  "comment" : "The NHI is validated. The version-id is validated. The inactivate-id is validated. If all request parameters are valid the name is made inactive on the patient record.",
  "resource" : ["Patient"],
  "system" : false,
  "type" : false,
  "instance" : true,
  "parameter" : [
    {
      "name" : "nhi",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The Patient's nhi number",
      "type" : "string"
    },
    {
      "name" : "version-id",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The current value of the patient resources meta.versionId",
      "type" : "string"
    },
    {
      "name" : "inactivate-id",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The id of the name element to be inactivated (patient.name.id))",
      "type" : "integer"
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "The updated patient resource",
      "type" : "Patient"
    },
    {
      "name" : "failure",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "Error response",
      "type" : "OperationOutcome"
    }
  ]
}

```
