# Delete a contact from a patient's NHI record. - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Delete a contact from a patient's NHI record.**

## OperationDefinition: Delete a contact from a patient's NHI record. 

| | |
| :--- | :--- |
| *Official URL*:https://nhi-ig.hip.digital.health.nz/OperationDefinition/delete-contact | *Version*:1.6.5 |
| Draft as of 2023-06-12 | *Computable Name*:Delete Contact |

 
An operation to delete a contact on a patient's NHI record 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "Patient-delete-contact",
  "url" : "https://nhi-ig.hip.digital.health.nz/OperationDefinition/delete-contact",
  "version" : "1.6.5",
  "name" : "Delete Contact",
  "title" : "Delete a contact from a patient's NHI record.",
  "status" : "draft",
  "kind" : "operation",
  "experimental" : false,
  "date" : "2023-06-12T12:47:40+10:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "An operation to delete a contact on a patient's NHI record",
  "affectsState" : true,
  "code" : "delete-contact",
  "comment" : "The NHI is validated, the versionId is validated, the parameters validated. If all request parameters are valid the new contact is added to the nhi record.",
  "resource" : ["Patient"],
  "system" : false,
  "type" : false,
  "instance" : true,
  "parameter" : [
    {
      "name" : "nhi",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The Patient's nhi number",
      "type" : "string"
    },
    {
      "name" : "version-id",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The current value of the patient resources meta.versionId",
      "type" : "string"
    },
    {
      "name" : "contact-id",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The id of the telecom element to be deleted",
      "type" : "string"
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "The updated patient resource",
      "type" : "Patient"
    },
    {
      "name" : "failure",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "Error response",
      "type" : "OperationOutcome"
    }
  ]
}

```
