# Consumer Facing Application Authentication - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* **Consumer Facing Application Authentication**

## Consumer Facing Application Authentication

### Background

Te Whatu Ora has implemented a Consumer Facing API Authentication Pattern to allow a person to access and update information held about them using their NHI number. The pattern describes how an end user's NHI can be securely established and communicated to a resource provider via a REST API. This is an implementation of the OAUTH2/OIDC Authorisation Code flow.

The trusted identity provider (idp) is My Health Account (MHA). [For more information click here](https://marketplace.hira.health.nz/digital-services/digital-health-identity-2/)

### Prerequisites

* The person’s NHI must be verified with MHA to a confidence level of at least 3N.
* The API will only grant the end user access to their own NHI information.
* The Client Application must be registered with MHA.
* The Client Application must be permitted SMART patient scopes on the resource being accessed.
* The IdP must issue access tokens with SMART patient scopes
* The IdP must have obtained end user consent prior to issuing the access token.

### Consumer Facing API and the NHI FHIR Service

#### Client Onboarding

The client registration process involves both the NHI FHIR service and the IdP.

* The IdP will provide the client_ID, client_secret and SMART on FHIR scopes.
* The NHI FHIR service will provide an API Key and approve any scopes granted to the client. 
* OAuth2 scopes are granted by the IdP to the client application, not the end user. For more information email the [integration team](mailto:integration@tewhatuora.govt.nz)
 

#### Compliance Testing

Compliance testing will need to be completed for both the idp and the NHI FHIR service. 
 For MHA Compliance information [For more information click here](https://marketplace.hira.health.nz/digital-services/digital-health-identity-2/). 
 To view the NHI FHIR Consumer Facing API Compliance tests [Click here](/ConsumerFacingApplicationAuthenticationComplianceTesting.md).

#### Consumer Facing API - Component View

![](ConsumerFacingAuthComponentView.png)

* **Health Consumer** - a person with an NHI
* **Resource Provider (NHI FHIR API)**- the system that implements the API and provides access to a resource referenceable by NHI (NHI FHIR API).
* **Client Application** - a system that consumes the API on behalf of the health consumer
* **My Health Account** 
* **IDP** - Identity Provider, able to grant access tokens
* **Login** - login UI via which the Health Consumer presents their credential's to MHA in order to establish their identity, and provide their consent to the Client Application
* **User Info** - OIDC endpoint which enables the Resource Provider to obtain the NHI number assigned to the Health Consumer
 

#### Access my NHI

##### Communication View

##### Access my NHI - Important information


For more information on the attributes please see the [NHI FHIR Patient profile](/StructureDefinition-NhiPatient.md)

#### Update my NHI

##### Communication View

##### Update my NHI - Important information


