<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile NhiPatient
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:Patient</sch:title>
    <sch:rule context="f:Patient">
      <sch:assert test="count(f:implicitRules) &lt;= 0">implicitRules: maximum cardinality of 'implicitRules' is 0</sch:assert>
      <sch:assert test="count(f:language) &lt;= 0">language: maximum cardinality of 'language' is 0</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/nz-ethnicity']) &gt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/nz-ethnicity': minimum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/nz-ethnicity']) &lt;= 6">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/nz-ethnicity': maximum cardinality of 'extension' is 6</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/nz-citizenship']) &gt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/nz-citizenship': minimum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/nz-citizenship']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/nz-citizenship': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/dhb']) &lt;= 0">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/dhb': maximum cardinality of 'extension' is 0</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/domicile-code']) &lt;= 0">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/domicile-code': maximum cardinality of 'extension' is 0</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/pho']) &lt;= 0">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/pho': maximum cardinality of 'extension' is 0</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/sex-at-birth']) &lt;= 0">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/sex-at-birth': maximum cardinality of 'extension' is 0</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/nz-iwi']) &lt;= 0">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/nz-iwi': maximum cardinality of 'extension' is 0</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/birth-place']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/birth-place': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:name) &gt;= 1">name: minimum cardinality of 'name' is 1</sch:assert>
      <sch:assert test="count(f:name) &lt;= 1">name: maximum cardinality of 'name' is 1</sch:assert>
      <sch:assert test="count(f:telecom) &lt;= 0">telecom: maximum cardinality of 'telecom' is 0</sch:assert>
      <sch:assert test="count(f:gender) &gt;= 1">gender: minimum cardinality of 'gender' is 1</sch:assert>
      <sch:assert test="count(f:birthDate) &gt;= 1">birthDate: minimum cardinality of 'birthDate' is 1</sch:assert>
      <sch:assert test="count(f:address) &gt;= 1">address: minimum cardinality of 'address' is 1</sch:assert>
      <sch:assert test="count(f:address) &lt;= 1">address: maximum cardinality of 'address' is 1</sch:assert>
      <sch:assert test="count(f:generalPractitioner) &lt;= 0">generalPractitioner: maximum cardinality of 'generalPractitioner' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Patient/f:extension</sch:title>
    <sch:rule context="f:Patient/f:extension">
      <sch:assert test="count(f:extension[@url = 'status']) &gt;= 1">extension with URL = 'status': minimum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'status']) &lt;= 1">extension with URL = 'status': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'source']) &gt;= 1">extension with URL = 'source': minimum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'source']) &lt;= 1">extension with URL = 'source': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:value[x]) &lt;= 0">value[x]: maximum cardinality of 'value[x]' is 0</sch:assert>
      <sch:assert test="count(f:extension[@url = 'country']) &gt;= 1">extension with URL = 'country': minimum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'country']) &lt;= 1">extension with URL = 'country': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'place-of-birth']) &lt;= 1">extension with URL = 'place-of-birth': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'source']) &gt;= 1">extension with URL = 'source': minimum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'source']) &lt;= 1">extension with URL = 'source': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:value[x]) &lt;= 0">value[x]: maximum cardinality of 'value[x]' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Patient/f:extension/f:extension</sch:title>
    <sch:rule context="f:Patient/f:extension/f:extension">
      <sch:assert test="count(f:value[x]) &gt;= 1">value[x]: minimum cardinality of 'value[x]' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Patient/f:identifier</sch:title>
    <sch:rule context="f:Patient/f:identifier">
      <sch:assert test="count(f:system) &gt;= 1">system: minimum cardinality of 'system' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Patient/f:name</sch:title>
    <sch:rule context="f:Patient/f:name">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/information-source']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/information-source': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/StructureDefinition/iso21090-preferred']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/StructureDefinition/iso21090-preferred': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/name-use-extra']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/name-use-extra': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:prefix) &lt;= 1">prefix: maximum cardinality of 'prefix' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Patient/f:telecom</sch:title>
    <sch:rule context="f:Patient/f:telecom">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/contactpoint-purpose']) &lt;= 0">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/contactpoint-purpose': maximum cardinality of 'extension' is 0</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/isVerified']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/isVerified': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/isShared']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/isShared': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/isPrivate']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/isPrivate': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/context']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/context': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/lastUpdatedDate']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/lastUpdatedDate': maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Patient/f:gender</sch:title>
    <sch:rule context="f:Patient/f:gender">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/gender-original-text']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/gender-original-text': maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Patient/f:birthDate</sch:title>
    <sch:rule context="f:Patient/f:birthDate">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/information-source']) &gt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/information-source': minimum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/information-source']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/information-source': maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Patient/f:deceased[x] 1</sch:title>
    <sch:rule context="f:Patient/f:deceased[x]">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/information-source']) &gt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/information-source': minimum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Patient/f:deceased[x]/f:extension 1</sch:title>
    <sch:rule context="f:Patient/f:deceased[x]/f:extension">
      <sch:assert test="count(f:url) &gt;= 1">url: minimum cardinality of 'url' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Patient/f:address</sch:title>
    <sch:rule context="f:Patient/f:address">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/nz-geocode']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/nz-geocode': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/suburb']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/suburb': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/building-name']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/building-name': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/domicile-code']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/domicile-code': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/not-validated-address-reason']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/not-validated-address-reason': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/nz-address-id']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/nz-address-id': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/nhi-address-derived']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/nhi-address-derived': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:use) &gt;= 1">use: minimum cardinality of 'use' is 1</sch:assert>
      <sch:assert test="count(f:line) &lt;= 2">line: maximum cardinality of 'line' is 2</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
