# Somatic Reporting - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* **Somatic Reporting**

## Somatic Reporting

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

This section deals with reporting observations related to cancer genomics. This includes reporting variants found in a tumor specimen, germ-line variants with known links to somatic events such as increasing risk for developing particular cancers, molecular biomarker observations that affect cancer care, and more. Beyond reporting variants and biomarkers, we also provide "implication" profiles to communicate observed links between variants and relevant knowledge bases such as professional guidelines and publications, for diagnostic and therapeutic implications, for predicted oncogenicity, etc. This sort of reporting is particularly prominent when dealing with cancer-related specimens, but can also include transplanted tissue and other forms of mosaicism.

### General guidance

At the heart of a typical somatic report are findings ([variants](StructureDefinition-variant.md), [haplotypes](StructureDefinition-haplotype.md), [genotypes](StructureDefinition-genotype.md), [biomarkers](StructureDefinition-molecular-biomarker.md)) and annotations derived from those findings ([diagnostic implications](StructureDefinition-diagnostic-implication.md), [therapeutic implications](StructureDefinition-therapeutic-implication.md), [predicted molecular consequences](StructureDefinition-molecular-consequence.md), [other genomic annotations](StructureDefinition-genomic-annotation.md)), as shown in the following figure:

> **ToDo Note:**GenomicStudy details tbdThese constructs are assembled within the broader context of the[Genomics Report](StructureDefinition-genomic-report.md), which generally contains information about the[specimen(s)](http://hl7.org/fhir/R5/specimen.html)and providers and organizations involved in the ordering and testing process. The report may also contain details about the[genomic study](http://hl7.org/fhir/R5/genomicstudy.html)analyses used to obtain the findings, as shown in the following figure:

### Building a Somatic Report: An Example

This section provides a walk-through of mapping from an example somatic report to FHIR using the structure definitions and guidance defined in this IG. A somatic report focuses on the implications of a patient's genetics (generally the therapeutic implications of somatic variants). The somatic report is represented as a Genomics Report. The related observations and other resources are referenced by the report. The intention of this section is to provide a "User Guide", based on a specific report example, highlighting how the defined profiles can be used together to encode important relations in somatic reporting.

The following four images are pages 1-4 of a synthetic somatic report that is designed to illustrate a wide range of findings and implications.

### Example FHIR Genomics instances

The somatic GenomicsReport which connects to all the FHIR Genomics instances for this detailed somatic example is [here](DiagnosticReport-somaticReport.md). A mapping spreadsheet is provided [here](https://chat.fhir.org/user_uploads/10155/-05xEKSs8tWp4qE3bCcA_Fvz/Somatic_Report_Only.xlsx). Alternatively, look in the table below for just those profiles of interest. (The numbers in the 'Label' column correspond to the numbers in the figures up above).

> **ToDo Note:**GenomicStudy details tbd.

| Label | Resource / Profile | Description of somatic usage | Example(s) | Example Notes | |——-|——————-|——————————|————|—————| | 1 | [Genomics Report](StructureDefinition-genomic-report.md) | Primary container of the overall report, including a report conclusion. | [somaticReport](DiagnosticReport-somaticReport.md) | | | 2 | [Patient](http://hl7.org/fhir/R5/patient.html) | The genomics report references the subject of the report, usually the patient. | [somaticPatient](Patient-somaticPatient.md) | | | 3 | [Specimen](http://hl7.org/fhir/R5/specimen.html) | The genomics report references specimens that this report is based on. | [tumorSpecimen](Specimen-tumorSpecimen.md), [normalSpecimen](Specimen-normalSpecimen.md) | | | 4 | [Service Request](http://hl7.org/fhir/R5/servicerequest.html) | The genomics report can reference orders that lead to the testing being reported. | [somaticServiceRequest](ServiceRequest-somaticServiceRequest.md) | | | 6 | [Organization](http://hl7.org/fhir/R5/organization.html) | The genomics report is referring to the organization that performed the reported test. | [performingOrganization](Organization-performingOrganization.md) | | | 6 | [Practitioner](http://hl7.org/fhir/R5/practitioner.html) | The genomics report can reference providers in various roles, such as the provider that ordered the test (indirect referencing through the service request), or the providers that perform or supervise the lab testing. | [orderingPractitioner](Practitioner-orderingPractitioner.md), [pathologistPractitioner](Practitioner-pathologistPractitioner.md), [supervisorPractitioner](Practitioner-supervisorPractitioner.md) | | | 8 | [Variant](StructureDefinition-variant.md) | The genomics report can reference variants and other findings identified via testing. | [NOTCH1-uncertain-var](Observation-NOTCH1-uncertain-var.md), [ZFHX3-uncertain-var](Observation-ZFHX3-uncertain-var.md), [MSH2-del-var](Observation-MSH2-del-var.md), [NTHL1-snv-var](Observation-NTHL1-snv-var.md), [STAG2-insertion-var](Observation-STAG2-insertion-var.md), [ATR-insertion-var](Observation-ATR-insertion-var.md), [EGFR-L858R-var](Observation-EGFR-L858R-var.md), [ROS1-Fusion-var](Observation-ROS1-Fusion-var.md) | | | 9 | [Diagnostic Implication](StructureDefinition-diagnostic-implication.md) | The genomics report can include various types of genomic annotations such as diagnostic implications related to identified variants / haplotypes / genotypes / biomarkers. | [NOTCH1-significance](Observation-NOTCH1-significance.md), [ZFHX3-significance](Observation-ZFHX3-significance.md), [MSH2-del-disease](Observation-MSH2-del-disease.md), [NTHL1-snv-disease](Observation-NTHL1-snv-disease.md), [STAG2-insertion-significance](Observation-STAG2-insertion-significance.md), [ATR-insertion-significance](Observation-ATR-insertion-significance.md), [EGFR-L858R-significance](Observation-EGFR-L858R-significance.md), [ROS1-Fusion-disease](Observation-ROS1-Fusion-disease.md) | Variant annotation knowledgebases generally differ in the types of annotations they supply. Different labs can potentially report different annotations. Annotations supplied by a lab can become out of date as genomics knowledge advances. | | 10 | [Therapeutic Implication](StructureDefinition-therapeutic-implication.md) | The genomics report can include various types of genomic annotations such as therapeutic implications related to identified variants / haplotypes / genotypes / biomarkers. | [ROS1-Fusion-therapuTrial](Observation-ROS1-Fusion-therapuTrial.md), [ROS1-Fusion-therapuDrug](Observation-ROS1-Fusion-therapuDrug.md), [EGFR-L858R-therapuDrug1](Observation-EGFR-L858R-therapuDrug1.md), [EGFR-L858R-therapuDrug2](Observation-EGFR-L858R-therapuDrug2.md), [TMB-therapuDrug](Observation-TMB-therapuDrug.md) | | | 11 | [Molecular Consequences](StructureDefinition-molecular-consequence.md) | The genomics report can include various types of genomic annotations such as molecular consequences related to identified variants / haplotypes / genotypes / biomarkers. | [NOTCH1-uncertain-molc](Observation-NOTCH1-uncertain-molc.md), [ZFHX3-uncertain-molc](Observation-ZFHX3-uncertain-molc.md), [MSH2-del-molc](Observation-MSH2-del-molc.md), [NTHL1-snv-molc](Observation-NTHL1-snv-molc.md), [STAG2-insertion-molc](Observation-STAG2-insertion-molc.md), [ATR-insertion-molc](Observation-ATR-insertion-molc.md), [EGFR-L858R-molc](Observation-EGFR-L858R-molc.md), [ROS1-Fusion](Observation-ROS1-Fusion.md) | | | 12 | [Molecular Biomarker](StructureDefinition-molecular-biomarker.md) | The genomics report can reference molecular biomarkers and other findings identified via testing. | [TMBExample](Observation-TMBExample.md), [MSIExample](Observation-MSIExample.md), [PDL1Example](Observation-PDL1Example.md) | | | 13 | [Haplotype](StructureDefinition-haplotype.md) | The genomics report can reference haplotypes and other findings identified via testing. | [HLA-A-haplotype1](Observation-HLA-A-haplotype1.md), [HLA-A-haplotype2](Observation-HLA-A-haplotype2.md), [HLA-B-haplotype1](Observation-HLA-B-haplotype1.md), [HLA-B-haplotype2](Observation-HLA-B-haplotype2.md), [HLA-C-haplotype1](Observation-HLA-C-haplotype1.md), [HLA-C-haplotype2](Observation-HLA-C-haplotype2.md) | |  | 14 | [GenomicStudy](http://hl7.org/fhir/R5/genomicstudy.html) | The genomics report can reference details of the genomic study/studies that were performed in order to identify variants / haplotypes / genotypes / biomarkers. Each referenced genomic study can be comprised of one or more genomic study analyses that detail the testing procedures performed. | … | Genomic study is optional, and provides a means of conveying detailed aspects of the performed procedure(s). | | 14 | [Genomics Data File](StructureDefinition-genomic-data-file.md) | Genomic study data can include explicit pointers to raw data files used or generated by the analyses. | [WES-UncallableRegions-GRCh38 (BED file)](DocumentReference-WES-UncallableRegions-GRCh38.md), [somaticVCFfile (VCF file)](DocumentReference-somaticVCFfile.md), [FullGenome-GRCh38 (BED file)](DocumentReference-FullGenome-GRCh38.md) | Raw genomic data files such as VCF generally contain far more data than that communicated in the report. BED files can precisely define regions of the genome that were studied or deemed uncallable. |

### Additional somatic-specific examples

* [Full transaction bundle](Bundle-bundle-oncologyexamples-r4.md) containing a Genomics DiagnosticReport referencing, Patient, Practitioner, Specimen, with Tumor Mutational Burden and MSI Status Observations, Variant Observations for JAK2/KDR/ERBB4 SNV analyses, and 4 derived Therapeutic Implication Observations.
* [Multiple Oncology Variant Report Example](Bundle-bundle-oncology-report-example.md) Oncology Example Report with 12 reported somatic variants
* [Melanoma implication](Bundle-bundle-oncology-diagnostic.md) Small example report with 1 reported variant and diagnostic implication.

