# hl7.fhir.uv.genomics-reporting#4.0.0-ballot: Genomics Reporting Implementation Guide

## Pages

* [Home Page](index.md)
* [General Genomic Reporting](general.md)
* [Appendix B: Clinical Genomic Apps](cgapps.md)
* [Pharmacogenomic Reporting](pharmacogenomics.md)
* [Genomic Background](background.md)
* [Appendix G: Molecular Sequence](molecularsequence.md)
* [Genomic Operations](operations.md)
* [Appendix A: Relation to v2 reporting](v2.md)
* [Useful Downloads](downloads.md)
* [Appendix H: Grouping Guidance](groupingguidance.md)
* [Appendix I: Glossary](glossary.md)
* [Artifact List](artifacts.md)
* [Appendix F: Conversion from FHIR Core STU3](conversion.md)
* [Somatic Reporting](somatics.md)
* [Histocompatibility and Immunogenetic Reporting](histocompatibility.md)
* [Appendix D: Query Guidance](usecases.md)
* [Appendix C: HL7 Domain Analysis Model](domain.md)
* [Variant Reporting](sequencing.md)
* [Change Log](changes.md)
* [Appendix E: External Coding Systems](codings.md)

## Resources

### CodeSystems

* [ClinVar Evidence Level Example Codes](CodeSystem-clinvar-evidence-level-custom-cs.md)
* [Coded Annotation Type Codes](CodeSystem-coded-annotation-types-cs.md)
* [Knowledge Base Codes](CodeSystem-knowledge-base-cs.md)
* [Molecular Biomarker Ontology Codes](CodeSystem-molecular-biomarker-ontology-cs.md)
* [PharmGKB Evidence Level Example Codes](CodeSystem-pharmgkb-evidence-level-custom-cs.md)
* [Sequence Phase Relationship Codes](CodeSystem-sequence-phase-relationship-cs.md)
* [To Be Determined Codes](CodeSystem-tbd-codes-cs.md)
* [Variant Confidence Status Codes](CodeSystem-variant-confidence-status-cs.md)

### ValueSets

* [Coded Annotation Types](ValueSet-coded-annotation-types-vs.md)
* [Condition Inheritance Patterns](ValueSet-condition-inheritance-mode-vs.md)
* [DNA Change Type](ValueSet-dna-change-type-vs.md)
* [Evidence Level Examples](ValueSet-evidence-level-example-vs.md)
* [Functional Effect Value Set](ValueSet-functional-effect-vs.md)
* [Genetic Therapeutic Implications](ValueSet-genetic-therapeutic-implications-vs.md)
* [HUGO Gene Nomenclature Committee Gene Names (HGNC)](ValueSet-hgnc-vs.md)
* [Human Genome Variation Society (HGVS) Nomenclature](ValueSet-hgvs-vs.md)
* [Knowledge Base Version Codes](ValueSet-knowledge-base-version-vs.md)
* [Molecular Biomarker Categories](ValueSet-molecular-biomarker-category-vs.md)
* [Molecular Biomarker Codes](ValueSet-molecular-biomarker-code-vs.md)
* [Molecular Consequence Value Set](ValueSet-molecular-consequence-vs.md)
* [Sequence Phase Relationships](ValueSet-sequence-phase-relationship-vs.md)
* [To Be Determined Value Set](ValueSet-tbd-codes-vs.md)
* [Variant Confidence Status](ValueSet-variant-confidence-status-vs.md)

### Complex-type Profiles

* [Coded Annotation](StructureDefinition-coded-annotation.md)

### Resource Profiles

* [Diagnostic Implication](StructureDefinition-diagnostic-implication.md)
* [Genomic Finding](StructureDefinition-finding.md)
* [Followup Recommendation](StructureDefinition-followup-recommendation.md)
* [Genomic Annotation](StructureDefinition-genomic-annotation.md)
* [Genomic Base](StructureDefinition-genomic-base.md)
* [Genomic Data File](StructureDefinition-genomic-data-file.md)
* [Genomic Report](StructureDefinition-genomic-report.md)
* [Genotype](StructureDefinition-genotype.md)
* [Haplotype](StructureDefinition-haplotype.md)
* [Genomic Implication](StructureDefinition-implication.md)
* [Medication Recommendation](StructureDefinition-medication-recommendation.md)
* [Molecular Biomarker](StructureDefinition-molecular-biomarker.md)
* [Molecular Consequence](StructureDefinition-molecular-consequence.md)
* [Sequence Phase Relationship](StructureDefinition-sequence-phase-relationship.md)
* [Therapeutic Implication](StructureDefinition-therapeutic-implication.md)
* [Variant](StructureDefinition-variant.md)

### Extensions

* [Annotation Code](StructureDefinition-annotation-code.md)
* [Genomic Report Note](StructureDefinition-genomic-report-note.md)
* [Genomic Risk Assessment](StructureDefinition-genomic-risk-assessment.md)
* [KnowledgebaseAncestryGroup](StructureDefinition-knowledgebase-ancestry-group.md)
* [Medication Assessed reference to a FHIR resource](StructureDefinition-medication-assessed-reference.md)
* [Recommended Action](StructureDefinition-recommended-action.md)
* [Repeat Motif Order](StructureDefinition-repeat-motif-order.md)
* [Therapy Assessed reference to a FHIR resource](StructureDefinition-therapy-assessed-reference.md)

### ConceptMaps

* [DNA Change Type Map](ConceptMap-dna-change-type-map.md)

### ImplementationGuides

* [Genomics Reporting Implementation Guide](index.md)

### OperationDefinitions

* [Find Population Diagnostic Implications](OperationDefinition-find-population-dx-implications.md)
* [Find Population Molecular Consequences](OperationDefinition-find-population-molecular-consequences.md)
* [Find Population Specific Haplotypes](OperationDefinition-find-population-specific-haplotypes.md)
* [Find Population Specific Variants](OperationDefinition-find-population-specific-variants.md)
* [Find Population Structural Intersecting Variants](OperationDefinition-find-population-structural-intersecting-variants.md)
* [Find Population Structural Subsuming Variants](OperationDefinition-find-population-structural-subsuming-variants.md)
* [Find Population Treatment Implications](OperationDefinition-find-population-tx-implications.md)
* [Find Study Metadata](OperationDefinition-find-study-metadata.md)
* [Find Subject Diagnostic Implications](OperationDefinition-find-subject-dx-implications.md)
* [Find Subject Haplotypes](OperationDefinition-find-subject-haplotypes.md)
* [Find Subject Molecular Consequences](OperationDefinition-find-subject-molecular-consequences.md)
* [Find Subject Specific Haplotypes](OperationDefinition-find-subject-specific-haplotypes.md)
* [Find Subject Specific Variants](OperationDefinition-find-subject-specific-variants.md)
* [Find Subject Structural Intersecting Variants](OperationDefinition-find-subject-structural-intersecting-variants.md)
* [Find Subject Structural Subsuming Variants](OperationDefinition-find-subject-structural-subsuming-variants.md)
* [Find Subject Treatment Implications](OperationDefinition-find-subject-tx-implications.md)
* [Find Subject Variants](OperationDefinition-find-subject-variants.md)

### Examples

* [bundle-CG-IG-HLA-FullBundle-01 (Bundle)](Bundle-bundle-CG-IG-HLA-FullBundle-01.md)
* [bundle-CYP2C19 (Bundle)](Bundle-bundle-CYP2C19.md)
* [bundle-cgexample-withGrouping (Bundle)](Bundle-bundle-cgexample-withGrouping.md)
* [bundle-cgexample (Bundle)](Bundle-bundle-cgexample.md)
* [bundle-complexVariant-nonHGVS (Bundle)](Bundle-bundle-complexVariant-nonHGVS.md)
* [bundle-compound-heterozygote (Bundle)](Bundle-bundle-compound-heterozygote.md)
* [bundle-oncology-diagnostic (Bundle)](Bundle-bundle-oncology-diagnostic.md)
* [bundle-oncology-report-example (Bundle)](Bundle-bundle-oncology-report-example.md)
* [bundle-oncologyexamples-r4-withGrouping (Bundle)](Bundle-bundle-oncologyexamples-r4-withGrouping.md)
* [bundle-oncologyexamples-r4 (Bundle)](Bundle-bundle-oncologyexamples-r4.md)
* [bundle-pgxexample (Bundle)](Bundle-bundle-pgxexample.md)
* [bundle-sequence-phase-relation-CYP2C19 (Bundle)](Bundle-bundle-sequence-phase-relation-CYP2C19.md)
* [triodenovo-software (Device)](Device-triodenovo-software.md)
* [GenomicReportExample01 (DiagnosticReport)](DiagnosticReport-GenomicReportExample01.md)
* [PGxGenomicReportEMERGE-withGrouping (DiagnosticReport)](DiagnosticReport-PGxGenomicReportEMERGE-withGrouping.md)
* [PGxGenomicReportEMERGE (DiagnosticReport)](DiagnosticReport-PGxGenomicReportEMERGE.md)
* [diagnosticreport-hla-glstring-r4 (DiagnosticReport)](DiagnosticReport-diagnosticreport-hla-glstring-r4.md)
* [somaticReport (DiagnosticReport)](DiagnosticReport-somaticReport.md)
* [CNVAnalysis-called (DocumentReference)](DocumentReference-CNVAnalysis-called.md)
* [FullGenome-GRCh38 (DocumentReference)](DocumentReference-FullGenome-GRCh38.md)
* [SimpleVariantAnalysis-called (DocumentReference)](DocumentReference-SimpleVariantAnalysis-called.md)
* [UncallableRegions (DocumentReference)](DocumentReference-UncallableRegions.md)
* [WES-FullSequencedRegion-GRCh38 (DocumentReference)](DocumentReference-WES-FullSequencedRegion-GRCh38.md)
* [WES-UncallableRegions-GRCh38 (DocumentReference)](DocumentReference-WES-UncallableRegions-GRCh38.md)
* [genomicFileFatherBAM (DocumentReference)](DocumentReference-genomicFileFatherBAM.md)
* [genomicFileMotherBAM (DocumentReference)](DocumentReference-genomicFileMotherBAM.md)
* [genomicFileProbandBAM (DocumentReference)](DocumentReference-genomicFileProbandBAM.md)
* [genomicFileProbandVCF (DocumentReference)](DocumentReference-genomicFileProbandVCF.md)
* [genomicVCFfile-cnv (DocumentReference)](DocumentReference-genomicVCFfile-cnv.md)
* [genomicVCFfile-simple (DocumentReference)](DocumentReference-genomicVCFfile-simple.md)
* [somaticVCFfile (DocumentReference)](DocumentReference-somaticVCFfile.md)
* [PGXGenomicStudy (GenomicStudy)](GenomicStudy-PGXGenomicStudy.md)
* [genomicstudy-trio2 (GenomicStudy)](GenomicStudy-genomicstudy-trio2.md)
* [lungMass (GenomicStudy)](GenomicStudy-lungMass.md)
* [somaticStudy (GenomicStudy)](GenomicStudy-somaticStudy.md)
* [MedicationStatementWarfarin (MedicationStatement)](MedicationStatement-MedicationStatementWarfarin.md)
* [ATR-insertion-molc (Observation)](Observation-ATR-insertion-molc.md)
* [ATR-insertion-significance (Observation)](Observation-ATR-insertion-significance.md)
* [ATR-insertion-var (Observation)](Observation-ATR-insertion-var.md)
* [AnnotationExample (Observation)](Observation-AnnotationExample.md)
* [EGFR-L858R-molc (Observation)](Observation-EGFR-L858R-molc.md)
* [EGFR-L858R-significance (Observation)](Observation-EGFR-L858R-significance.md)
* [EGFR-L858R-therapuDrug1 (Observation)](Observation-EGFR-L858R-therapuDrug1.md)
* [EGFR-L858R-therapuDrug2 (Observation)](Observation-EGFR-L858R-therapuDrug2.md)
* [EGFR-L858R-var (Observation)](Observation-EGFR-L858R-var.md)
* [ExampleGermlineCNV (Observation)](Observation-ExampleGermlineCNV.md)
* [ExampleGermlineDEL (Observation)](Observation-ExampleGermlineDEL.md)
* [ExampleGermlineINV (Observation)](Observation-ExampleGermlineINV.md)
* [ExampleSomaticCNV (Observation)](Observation-ExampleSomaticCNV.md)
* [ExampleSomaticDEL (Observation)](Observation-ExampleSomaticDEL.md)
* [ExampleSomaticINV (Observation)](Observation-ExampleSomaticINV.md)
* [Genotype-Clinical-Trial-Example-using-haplotypes (Observation)](Observation-Genotype-Clinical-Trial-Example-using-haplotypes.md)
* [GenotypeExample1 (Observation)](Observation-GenotypeExample1.md)
* [GenotypeExamplePharmVar (Observation)](Observation-GenotypeExamplePharmVar.md)
* [GrouperEx01 (Observation)](Observation-GrouperEx01.md)
* [GrouperEx02 (Observation)](Observation-GrouperEx02.md)
* [GrouperEx03 (Observation)](Observation-GrouperEx03.md)
* [HER2byImmuneStainExample (Observation)](Observation-HER2byImmuneStainExample.md)
* [HER2byImmunoassayExample (Observation)](Observation-HER2byImmunoassayExample.md)
* [HLA-A-haplotype1 (Observation)](Observation-HLA-A-haplotype1.md)
* [HLA-A-haplotype2 (Observation)](Observation-HLA-A-haplotype2.md)
* [HLA-B-haplotype1 (Observation)](Observation-HLA-B-haplotype1.md)
* [HLA-B-haplotype2 (Observation)](Observation-HLA-B-haplotype2.md)
* [HLA-C-haplotype1 (Observation)](Observation-HLA-C-haplotype1.md)
* [HLA-C-haplotype2 (Observation)](Observation-HLA-C-haplotype2.md)
* [HaplotypeExamplePharmVar01 (Observation)](Observation-HaplotypeExamplePharmVar01.md)
* [HaplotypeExamplePharmVar02 (Observation)](Observation-HaplotypeExamplePharmVar02.md)
* [HaplotypeSet-Clinical-Trial-Example-1of2 (Observation)](Observation-HaplotypeSet-Clinical-Trial-Example-1of2.md)
* [HaplotypeSet-Clinical-Trial-Example-2of2 (Observation)](Observation-HaplotypeSet-Clinical-Trial-Example-2of2.md)
* [ISCN-CMLExample (Observation)](Observation-ISCN-CMLExample.md)
* [ISCN-CMLImplication (Observation)](Observation-ISCN-CMLImplication.md)
* [ISCN-NormalExample (Observation)](Observation-ISCN-NormalExample.md)
* [MSH2-del-disease (Observation)](Observation-MSH2-del-disease.md)
* [MSH2-del-molc (Observation)](Observation-MSH2-del-molc.md)
* [MSH2-del-var (Observation)](Observation-MSH2-del-var.md)
* [MSIExample (Observation)](Observation-MSIExample.md)
* [MicrosatelliteInstabilityExample01 (Observation)](Observation-MicrosatelliteInstabilityExample01.md)
* [MultipleRepeatExpansions (Observation)](Observation-MultipleRepeatExpansions.md)
* [NOTCH1-significance (Observation)](Observation-NOTCH1-significance.md)
* [NOTCH1-uncertain-molc (Observation)](Observation-NOTCH1-uncertain-molc.md)
* [NOTCH1-uncertain-var (Observation)](Observation-NOTCH1-uncertain-var.md)
* [NTHL1-snv-disease (Observation)](Observation-NTHL1-snv-disease.md)
* [NTHL1-snv-molc (Observation)](Observation-NTHL1-snv-molc.md)
* [NTHL1-snv-var (Observation)](Observation-NTHL1-snv-var.md)
* [PDL1Example (Observation)](Observation-PDL1Example.md)
* [Pgx-geno-1001 (Observation)](Observation-Pgx-geno-1001.md)
* [Pgx-geno-1002 (Observation)](Observation-Pgx-geno-1002.md)
* [Pgx-geno-1003 (Observation)](Observation-Pgx-geno-1003.md)
* [Pgx-var-1011 (Observation)](Observation-Pgx-var-1011.md)
* [Pgx-var-1012 (Observation)](Observation-Pgx-var-1012.md)
* [Pgx-var-1013 (Observation)](Observation-Pgx-var-1013.md)
* [Pgx-var-1014 (Observation)](Observation-Pgx-var-1014.md)
* [Pgx-var-1015 (Observation)](Observation-Pgx-var-1015.md)
* [Pgx-var-1016 (Observation)](Observation-Pgx-var-1016.md)
* [Pgx-var-1017 (Observation)](Observation-Pgx-var-1017.md)
* [Pgx-var-1018 (Observation)](Observation-Pgx-var-1018.md)
* [Pgx-var-1019 (Observation)](Observation-Pgx-var-1019.md)
* [Pgx-var-1020 (Observation)](Observation-Pgx-var-1020.md)
* [Pgx-var-1021 (Observation)](Observation-Pgx-var-1021.md)
* [PolyGenicDiagnosticImpExample (Observation)](Observation-PolyGenicDiagnosticImpExample.md)
* [ROS1-Fusion-disease (Observation)](Observation-ROS1-Fusion-disease.md)
* [ROS1-Fusion-therapuDrug (Observation)](Observation-ROS1-Fusion-therapuDrug.md)
* [ROS1-Fusion-therapuTrial (Observation)](Observation-ROS1-Fusion-therapuTrial.md)
* [ROS1-Fusion-var (Observation)](Observation-ROS1-Fusion-var.md)
* [ROS1-Fusion (Observation)](Observation-ROS1-Fusion.md)
* [RepeatExpansion (Observation)](Observation-RepeatExpansion.md)
* [SNVexample (Observation)](Observation-SNVexample.md)
* [STAG2-insertion-molc (Observation)](Observation-STAG2-insertion-molc.md)
* [STAG2-insertion-significance (Observation)](Observation-STAG2-insertion-significance.md)
* [STAG2-insertion-var (Observation)](Observation-STAG2-insertion-var.md)
* [SequencePhaseRelationExample1 (Observation)](Observation-SequencePhaseRelationExample1.md)
* [TMB-therapuDrug (Observation)](Observation-TMB-therapuDrug.md)
* [TMBExample (Observation)](Observation-TMBExample.md)
* [Therapeutic-Implication-Clinical-Trial-2 (Observation)](Observation-Therapeutic-Implication-Clinical-Trial-2.md)
* [Therapeutic-Implication-Clinical-Trial-Somatic (Observation)](Observation-Therapeutic-Implication-Clinical-Trial-Somatic.md)
* [TherapeuticImplicationExample1 (Observation)](Observation-TherapeuticImplicationExample1.md)
* [TumorMutationBurdenExample01 (Observation)](Observation-TumorMutationBurdenExample01.md)
* [TxImp01 (Observation)](Observation-TxImp01.md)
* [TxImp02 (Observation)](Observation-TxImp02.md)
* [TxImp03 (Observation)](Observation-TxImp03.md)
* [TxImp04 (Observation)](Observation-TxImp04.md)
* [TxImp05 (Observation)](Observation-TxImp05.md)
* [TxImp06 (Observation)](Observation-TxImp06.md)
* [Variant-Somatic-Clinical-Trial (Observation)](Observation-Variant-Somatic-Clinical-Trial.md)
* [VariantExample (Observation)](Observation-VariantExample.md)
* [VariantExample1 (Observation)](Observation-VariantExample1.md)
* [VariantExample2 (Observation)](Observation-VariantExample2.md)
* [ZFHX3-significance (Observation)](Observation-ZFHX3-significance.md)
* [ZFHX3-uncertain-molc (Observation)](Observation-ZFHX3-uncertain-molc.md)
* [ZFHX3-uncertain-var (Observation)](Observation-ZFHX3-uncertain-var.md)
* [diagnosticImplication-interact-smn1-smn2 (Observation)](Observation-diagnosticImplication-interact-smn1-smn2.md)
* [genotype-hla-a-glstring-r4 (Observation)](Observation-genotype-hla-a-glstring-r4.md)
* [haplotype-hla-a-1-r4 (Observation)](Observation-haplotype-hla-a-1-r4.md)
* [molec-conseq1 (Observation)](Observation-molec-conseq1.md)
* [molec-conseq2 (Observation)](Observation-molec-conseq2.md)
* [molec-conseq3 (Observation)](Observation-molec-conseq3.md)
* [molec-conseq4 (Observation)](Observation-molec-conseq4.md)
* [obs-idh-ex (Observation)](Observation-obs-idh-ex.md)
* [obs1-interact-smn1-smn2 (Observation)](Observation-obs1-interact-smn1-smn2.md)
* [obs2-interact-smn1-smn2 (Observation)](Observation-obs2-interact-smn1-smn2.md)
* [pop-allele-freq (Observation)](Observation-pop-allele-freq.md)
* [therapuDrug1-interact-smn1-smn2 (Observation)](Observation-therapuDrug1-interact-smn1-smn2.md)
* [therapuDrug2-interact-smn1-smn2 (Observation)](Observation-therapuDrug2-interact-smn1-smn2.md)
* [therapuDrug3-interact-smn1-smn2 (Observation)](Observation-therapuDrug3-interact-smn1-smn2.md)
* [variant-with-molec-consequences (Observation)](Observation-variant-with-molec-consequences.md)
* [Some lab (Organization)](Organization-ExampleLab.md)
* [some lab (Organization)](Organization-ExampleOrg.md)
* [My Test Pathology Laboratories (Organization)](Organization-performingOrganization.md)
* [FindALLPopulationSpecificVariantsOutput (Parameters)](Parameters-FindALLPopulationSpecificVariantsOutput.md)
* [FindANYPopulationSpecificVariantsOutput (Parameters)](Parameters-FindANYPopulationSpecificVariantsOutput.md)
* [FindPopulationDxImplicationsOutput (Parameters)](Parameters-FindPopulationDxImplicationsOutput.md)
* [FindPopulationMolecConseqOutput (Parameters)](Parameters-FindPopulationMolecConseqOutput.md)
* [FindPopulationSpecificHaplotypesOutput (Parameters)](Parameters-FindPopulationSpecificHaplotypesOutput.md)
* [FindPopulationStructuralIntersectingVariantsOutput (Parameters)](Parameters-FindPopulationStructuralIntersectingVariantsOutput.md)
* [FindPopulationStructuralSubsumingVariantsOutput (Parameters)](Parameters-FindPopulationStructuralSubsumingVariantsOutput.md)
* [FindPopulationTxImplicationsOutput (Parameters)](Parameters-FindPopulationTxImplicationsOutput.md)
* [FindStudyMetadataOutput (Parameters)](Parameters-FindStudyMetadataOutput.md)
* [FindSubjectDxImplicationsOutput (Parameters)](Parameters-FindSubjectDxImplicationsOutput.md)
* [FindSubjectHaplotypesOutput (Parameters)](Parameters-FindSubjectHaplotypesOutput.md)
* [FindSubjectMolecConseqOutput (Parameters)](Parameters-FindSubjectMolecConseqOutput.md)
* [FindSubjectSpecificHaplotypesOutput (Parameters)](Parameters-FindSubjectSpecificHaplotypesOutput.md)
* [FindSubjectSpecificVariantsOutput (Parameters)](Parameters-FindSubjectSpecificVariantsOutput.md)
* [FindSubjectStructuralIntersectingVariantsOutput (Parameters)](Parameters-FindSubjectStructuralIntersectingVariantsOutput.md)
* [FindSubjectStructuralSubsumingVariantsOutput (Parameters)](Parameters-FindSubjectStructuralSubsumingVariantsOutput.md)
* [FindSubjectTxImplicationsOutput (Parameters)](Parameters-FindSubjectTxImplicationsOutput.md)
* [FindSubjectVariantsOutput (Parameters)](Parameters-FindSubjectVariantsOutput.md)
* [CGPatientExample01 (Patient)](Patient-CGPatientExample01.md)
* [ExamplePatient (Patient)](Patient-ExamplePatient.md)
* [HG00403 (Patient)](Patient-HG00403.md)
* [denovoChild (Patient)](Patient-denovoChild.md)
* [denovoFather (Patient)](Patient-denovoFather.md)
* [denovoMother (Patient)](Patient-denovoMother.md)
* [genomicPatient (Patient)](Patient-genomicPatient.md)
* [somaticPatient (Patient)](Patient-somaticPatient.md)
* [orderingPractitioner (Practitioner)](Practitioner-orderingPractitioner.md)
* [pathologistPractitioner (Practitioner)](Practitioner-pathologistPractitioner.md)
* [practitioner02 (Practitioner)](Practitioner-practitioner02.md)
* [supervisorPractitioner (Practitioner)](Practitioner-supervisorPractitioner.md)
* [SequencingProcedure (Procedure)](Procedure-SequencingProcedure.md)
* [GenRiskDiabetesT2 (RiskAssessment)](RiskAssessment-GenRiskDiabetesT2.md)
* [ExampleServiceRequest (ServiceRequest)](ServiceRequest-ExampleServiceRequest.md)
* [GenomicServiceRequestExample01 (ServiceRequest)](ServiceRequest-GenomicServiceRequestExample01.md)
* [eMERGEServiceRequest (ServiceRequest)](ServiceRequest-eMERGEServiceRequest.md)
* [genomicServiceRequest (ServiceRequest)](ServiceRequest-genomicServiceRequest.md)
* [servicerequest-hla-a-r4 (ServiceRequest)](ServiceRequest-servicerequest-hla-a-r4.md)
* [somaticServiceRequest (ServiceRequest)](ServiceRequest-somaticServiceRequest.md)
* [ExampleSpecimen (Specimen)](Specimen-ExampleSpecimen.md)
* [GenomicSpecimenExample01 (Specimen)](Specimen-GenomicSpecimenExample01.md)
* [GenomicSpecimenExample02 (Specimen)](Specimen-GenomicSpecimenExample02.md)
* [genomicSpecimen (Specimen)](Specimen-genomicSpecimen.md)
* [normalSpecimen (Specimen)](Specimen-normalSpecimen.md)
* [specimen-hla-r4 (Specimen)](Specimen-specimen-hla-r4.md)
* [tumorSpecimen (Specimen)](Specimen-tumorSpecimen.md)
* [MedicationRecommendationExample1 (Task)](Task-MedicationRecommendationExample1.md)
* [PGxRecEx01 (Task)](Task-PGxRecEx01.md)
* [PGxRecEx02 (Task)](Task-PGxRecEx02.md)
* [PGxRecEx03 (Task)](Task-PGxRecEx03.md)
* [PGxRecEx04 (Task)](Task-PGxRecEx04.md)
* [PGxRecEx05 (Task)](Task-PGxRecEx05.md)
