# Home Page - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* **Home Page**

## Home Page

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/uv/genomics-reporting/ImplementationGuide/hl7.fhir.uv.genomics-reporting | *Version*:4.0.0-ballot | |
| *IG Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:GenomicsReporting |

### Scope

Genomics is a rapidly evolving area of healthcare that involves complex data structures. There is significant value in sharing this information in a way that is consistent, computable and that can accommodate ongoing evolution of medical science and practice. At present, this implementation guide focuses solely on data structures - what data should be/might be present and how it should be organized. It does not address workflows around how reports are requested, created, approved, routed, delivered, amended, etc.

This guide covers many aspects of genomic data reporting, including:

* Representation of simple discrete variants, structural variants including copy number variants, complex variants as well as gross variations such as extra or missing chromosomes
* Representation of both known variants as well as fully describing de novo variations
* Germline and somatic variations
* Relevance of identified variations from the perspective of disease pathology, pharmacogenomics, transplant suitability (e.g., HLA typing), etc.
* Full and partial DNA sequencing, including whole genome and exome studies

### How to Use this Guide

This implementation guide is organized into a set of sections. All implementers intending to do clinical genomic reporting should read the [General Genomic Reporting](general.md) and the [Variant Reporting](sequencing.md) sections. To understand the key profiles in this IG, as well as their relationship to one another, start with the General Genomics Reporting section. Those new to FHIR should review the Understanding FHIR section below.

The remaining sections provide support for more specialized types of reporting. If your system is involved with genomic reports in a particular area, then read through that section of the implementation guide for further guidance.

| | |
| :--- | :--- |
| [Background](background.md) | Introduces some of the key genomics terms and relationships that should be understood by those implementing this specification. |
| [General Genomic Reporting](general.md) | Overall guidance in using the profiles and transactions defined in this guide. Guidance and examples for the general structure of genomic reports, how to report overall interpretations and how to report genotypes, haplotypes, and different types of variants. |
| [Variant Reporting](sequencing.md) | Guidance on expressing information about variants gleaned from various sequencing approaches including direct sequencing, shotgun sequencing, array-based testing, etc. |
| [Pharmacogenomic Reporting](pharmacogenomics.md) | Guidance and examples related to genomic testing done for the purpose of assessing genomic variations' implication on the use of medications - both for oncology and for general patient treatment. |
| [Somatic Reporting](somatics.md) | Guidance related to genomic testing done on somatic (non-germline) tissues, including assessments of tumors. |
| [Histocompatibility Reporting](histocompatibility.md) | Guidance related to genomic testing done for histocompatibility and immunogenomics assessments, including HLA typing. |

### Guiding principles

This guide adheres to a set of design approaches:

* It is intended to be international in scope and only leverages terminologies which are freely available to all countries.
* It avoids pre-coordinating the type of variant, medication, or other information into the Observation.code as this makes it easier to leverage industry standard terminologies for genomic information (e.g., HGVS) and avoids needing to duplicate this information into observation coding systems such as LOINC.
* It maximizes the use of resources that are in common use by laboratory reporting systems for other clinical areas - specifically [Observation](http://hl7.org/fhir/R5/observation.html) and [DiagnosticReport](http://hl7.org/fhir/R5/diagnosticreport.html). This eases implementation and also reduces the chance of data being lost by systems that might not have been designed to specifically accommodate genomic-related information.
* It minimizes the use of FHIR extensions, also with an objective of reducing the risk of data loss when information is passed to systems that might not explicitly support this implementation guide.
* It uses separate observations for each independently useful assertion. This makes the data discoverable and queryable as seen in the [query guidance](usecases.md). Also review the guidance on the proper usage of [contained](http://hl7.org/fhir/R5/references.html#contained) resources.
* It tries to ensure that data is captured in a manner that's consistent regardless of the type of testing that was done to ensure data can be consistently queried even if captured differently (e.g., variations identified in assay tests are reported in the same manner as those identified through direct sequencing).
* The guide allows for variability in the amount of discrete information captured. Systems are encouraged to populate what discrete elements they can and allows for the possibility of systems populating additional elements as their technical capability and/or time and other resources allow.

Together, these principles should make adoption easier and allow systems to more easily adapt in a compatible way as genomic reporting continues to evolve.

### Previous Specifications

FHIR STU3 included a set of profiles that provided guidance on how to convey genomic orders, results, and observations. Those profiles are superseded by this implementation guide. Guidance for converting from these older profiles is found [here](conversion.md).

### Understanding FHIR

This implementation guide is based on the HL7 [FHIR](http://hl7.org/fhir/R5/index.html) standard. It uses terminology, notations and design principles that are specific to FHIR. Before reading this implementation guide, it's important to be familiar with some of the basic principles of FHIR as well as general guidance on how to read FHIR specifications. Readers who are unfamiliar with FHIR are encouraged to read (or at least skim) the following prior to reading the rest of this implementation guide.

* [FHIR overview](http://hl7.org/fhir/R5/overview.html)
* [Developer's introduction](http://hl7.org/fhir/R5/overview-dev.html)
* (or [Clinical introduction](http://hl7.org/fhir/R5/overview-clinical.html))
* [FHIR data types](http://hl7.org/fhir/R5/datatypes.html)
* [Using codes](http://hl7.org/fhir/R5/terminologies.html)
* [References between resources](http://hl7.org/fhir/R5/references.html)
* [How to read resource & profile definitions](http://hl7.org/fhir/R5/formats.html)
* [Base resource](http://hl7.org/fhir/R5/resource.html)
* [FHIR Validation](http://hl7.org/fhir/R5/validation.html)

It is highly recommended that readers review [Diagnostics Module](http://hl7.org/fhir/R5/diagnostics-module.html) and review the resources that are used as part of this implementation guide, especially [Observation](http://hl7.org/fhir/R5/observation.html), [DiagnosticReport](http://hl7.org/fhir/R5/diagnosticreport.html), and [MolecularSequence](http://hl7.org/fhir/R5/molecularsequence.html).

Importantly, implementers should pay close attention to the considerations in [Associated Observations](http://hl7.org/fhir/R5/diagnosticreport.html#10.3.5.3) and [Observation Grouping](http://hl7.org/fhir/R5/observation.html#obsgrouping) describing proper usage of the relationships `DiagnosticReport.result`, `Observation.hasMember`, and `Observation.derivedFrom`. Consumers of **Genomic diagnostic reports** MUST navigate through all `hasMember` relations, and navigate through `derivedFrom` relationships in order to ensure all clinically relevant information is seen.

Many Observation profiles and components in this guide require sending codes from http://loinc.org. If necessary for implementation (e.g., to map to a local system), equivalent codes from other code systems may **also** be sent, following the [guidance](http://hl7.org/fhir/R5/observation.html#usingcodes) on observation.

Since this Implementation Guide is not targeting a specific country or region, other requirements may be needed for local reporting. Observation instances adhering to other profiles should be built to validate against one of this Implementation Guide's profiles wherever possible. Where incompatibilities may arise, it is most important to align with the codes and values for Observations and their components.

### Extending beyond this Guide

Implementers should use this guide to structure genomics data in an interoperable way. The Clinical Genomics Working Group understands that this guide is not complete, and implementers might identify additional concepts and data elements. Please review this [guidance](general.md#flexibility) for ways to handle those use cases.

### Dependencies



### Global Profiles

*There are no Global profiles defined*

### Cross Version Analysis

### IP Statements

This publication includes IP covered under the following statements.

* Copyrights permitted under terms specified by [Creative Commons Attribution 4.0 International (CC BY 4.0)](https://creativecommons.org/licenses/by/4.0/legalcode) .Consistent with the terms of CC BY 4.0, HL7 is permitted to share, copy and redistribute the material in any medium or format and adapt, remix, transform, and build upon the material for its purposes as long as the CC BY 4.0 license terms are upheld. HL7 must must give appropriate credit, provide a link to the license, and indicate if changes were made. HL7 may do so in any reasonable manner, but not in any way that suggests the licensor endorses HL7 or it's use. And HL7 may not apply legal terms or technological measures that legally restrict others from doing anything the license permits.

* [Mondo Disease Ontology](http://terminology.hl7.org/6.5.0/CodeSystem-MONDO.html): [Bundle/bundle-cgexample](Bundle-bundle-cgexample.md), [Bundle/bundle-cgexample-withGrouping](Bundle-bundle-cgexample-withGrouping.md) and [Observation/obs-idh-ex](Observation-obs-idh-ex.md)


* Information that is created by or for the US government are within the public domain. Public domain information on the National Library of Medicine (NLM) Web pages may be freely distributed and copied. However, it is requested that in any subsequent use of this work, NLM be given appropriate acknowledgment.NOTE: This site contains resources which incorporate material contributed or licensed by individuals, companies, or organizations that may be protected by U.S. and foreign copyright laws. These include, but are not limited to PubMed Central (PMC) (see PMC Copyright Notice via [https://www.ncbi.nlm.nih.gov/pmc/about/copyright/)](https://www.ncbi.nlm.nih.gov/pmc/about/copyright/)), Bookshelf (see Bookshelf Copyright Notice via [https://www.ncbi.nlm.nih.gov/books/about/copyright/)](https://www.ncbi.nlm.nih.gov/books/about/copyright/)), OMIM (see OMIM Copyright Status via [https://omim.org/help/copyright)](https://omim.org/help/copyright)), and PubChem. All persons reproducing, redistributing, or making commercial use of this information are expected to adhere to the terms and conditions asserted by the copyright holder. Transmission or reproduction of protected items beyond that allowed by fair use ([https://www.copyright.gov/fls/fl102.html)(PDF)](https://www.copyright.gov/fls/fl102.html)(PDF)) as defined in the copyright laws requires the written permission of the copyright owners.For information on NCBI's policies and disclaimers for use, see here [https://www.ncbi.nlm.nih.gov/home/about/policies/](https://www.ncbi.nlm.nih.gov/home/about/policies/).

* [ClinVar Variant ID](http://terminology.hl7.org/6.5.0/CodeSystem-ClinVarV.html): [Bundle/bundle-cgexample](Bundle-bundle-cgexample.md), [Bundle/bundle-cgexample-withGrouping](Bundle-bundle-cgexample-withGrouping.md)...Show 10 more,[Bundle/bundle-complexVariant-nonHGVS](Bundle-bundle-complexVariant-nonHGVS.md),[Bundle/bundle-compound-heterozygote](Bundle-bundle-compound-heterozygote.md),[Bundle/bundle-oncology-diagnostic](Bundle-bundle-oncology-diagnostic.md),[Observation/GenotypeExample1](Observation-GenotypeExample1.md),[Observation/HaplotypeSet-Clinical-Trial-Example-1of2](Observation-HaplotypeSet-Clinical-Trial-Example-1of2.md),[Observation/HaplotypeSet-Clinical-Trial-Example-2of2](Observation-HaplotypeSet-Clinical-Trial-Example-2of2.md),[Observation/MSH2-del-var](Observation-MSH2-del-var.md),[Observation/NTHL1-snv-var](Observation-NTHL1-snv-var.md),[Observation/Pgx-geno-1001](Observation-Pgx-geno-1001.md)and[Observation/RepeatExpansion](Observation-RepeatExpansion.md)


* It is a condition of HGNC funding from NIH and the Welcome Trust that the nomenclature and information provided is freely available to all. Anyone may use the HGNC data, but we request that they reference the **"HUGO Gene Nomenclature Committee at the European Bioinformatics Institute"** and the website where possible.

* [HUGO Gene Nomenclature Committee Genes](http://terminology.hl7.org/6.5.0/CodeSystem-v3-hgnc.html): [Bundle/bundle-CG-IG-HLA-FullBundle-01](Bundle-bundle-CG-IG-HLA-FullBundle-01.md), [Bundle/bundle-cgexample](Bundle-bundle-cgexample.md)...Show 57 more,[Bundle/bundle-cgexample-withGrouping](Bundle-bundle-cgexample-withGrouping.md),[Bundle/bundle-oncology-diagnostic](Bundle-bundle-oncology-diagnostic.md),[Bundle/bundle-oncology-report-example](Bundle-bundle-oncology-report-example.md),[Bundle/bundle-oncologyexamples-r4](Bundle-bundle-oncologyexamples-r4.md),[Bundle/bundle-oncologyexamples-r4-withGrouping](Bundle-bundle-oncologyexamples-r4-withGrouping.md),[Bundle/bundle-pgxexample](Bundle-bundle-pgxexample.md),[GenomicFinding](StructureDefinition-finding.md),[HGNCVS](ValueSet-hgnc-vs.md),[MolecularBiomarker](StructureDefinition-molecular-biomarker.md),[Observation/ATR-insertion-var](Observation-ATR-insertion-var.md),[Observation/EGFR-L858R-var](Observation-EGFR-L858R-var.md),[Observation/Genotype-Clinical-Trial-Example-using-haplotypes](Observation-Genotype-Clinical-Trial-Example-using-haplotypes.md),[Observation/GenotypeExample1](Observation-GenotypeExample1.md),[Observation/GenotypeExamplePharmVar](Observation-GenotypeExamplePharmVar.md),[Observation/HER2byImmuneStainExample](Observation-HER2byImmuneStainExample.md),[Observation/HER2byImmunoassayExample](Observation-HER2byImmunoassayExample.md),[Observation/HLA-A-haplotype1](Observation-HLA-A-haplotype1.md),[Observation/HLA-A-haplotype2](Observation-HLA-A-haplotype2.md),[Observation/HLA-B-haplotype1](Observation-HLA-B-haplotype1.md),[Observation/HLA-B-haplotype2](Observation-HLA-B-haplotype2.md),[Observation/HLA-C-haplotype1](Observation-HLA-C-haplotype1.md),[Observation/HLA-C-haplotype2](Observation-HLA-C-haplotype2.md),[Observation/HaplotypeExamplePharmVar01](Observation-HaplotypeExamplePharmVar01.md),[Observation/HaplotypeExamplePharmVar02](Observation-HaplotypeExamplePharmVar02.md),[Observation/HaplotypeSet-Clinical-Trial-Example-1of2](Observation-HaplotypeSet-Clinical-Trial-Example-1of2.md),[Observation/HaplotypeSet-Clinical-Trial-Example-2of2](Observation-HaplotypeSet-Clinical-Trial-Example-2of2.md),[Observation/MSH2-del-var](Observation-MSH2-del-var.md),[Observation/MultipleRepeatExpansions](Observation-MultipleRepeatExpansions.md),[Observation/NOTCH1-uncertain-var](Observation-NOTCH1-uncertain-var.md),[Observation/NTHL1-snv-var](Observation-NTHL1-snv-var.md),[Observation/PDL1Example](Observation-PDL1Example.md),[Observation/Pgx-geno-1001](Observation-Pgx-geno-1001.md),[Observation/Pgx-geno-1002](Observation-Pgx-geno-1002.md),[Observation/Pgx-geno-1003](Observation-Pgx-geno-1003.md),[Observation/Pgx-var-1011](Observation-Pgx-var-1011.md),[Observation/Pgx-var-1012](Observation-Pgx-var-1012.md),[Observation/Pgx-var-1013](Observation-Pgx-var-1013.md),[Observation/Pgx-var-1014](Observation-Pgx-var-1014.md),[Observation/Pgx-var-1015](Observation-Pgx-var-1015.md),[Observation/Pgx-var-1016](Observation-Pgx-var-1016.md),[Observation/Pgx-var-1017](Observation-Pgx-var-1017.md),[Observation/Pgx-var-1018](Observation-Pgx-var-1018.md),[Observation/Pgx-var-1019](Observation-Pgx-var-1019.md),[Observation/Pgx-var-1020](Observation-Pgx-var-1020.md),[Observation/Pgx-var-1021](Observation-Pgx-var-1021.md),[Observation/ROS1-Fusion-var](Observation-ROS1-Fusion-var.md),[Observation/RepeatExpansion](Observation-RepeatExpansion.md),[Observation/SNVexample](Observation-SNVexample.md),[Observation/STAG2-insertion-var](Observation-STAG2-insertion-var.md),[Observation/Variant-Somatic-Clinical-Trial](Observation-Variant-Somatic-Clinical-Trial.md),[Observation/ZFHX3-uncertain-var](Observation-ZFHX3-uncertain-var.md),[Observation/genotype-hla-a-glstring-r4](Observation-genotype-hla-a-glstring-r4.md),[Observation/haplotype-hla-a-1-r4](Observation-haplotype-hla-a-1-r4.md),[Observation/obs1-interact-smn1-smn2](Observation-obs1-interact-smn1-smn2.md),[Observation/obs2-interact-smn1-smn2](Observation-obs2-interact-smn1-smn2.md),[Parameters/FindSubjectHaplotypesOutput](Parameters-FindSubjectHaplotypesOutput.md)and[Parameters/FindSubjectSpecificHaplotypesOutput](Parameters-FindSubjectSpecificHaplotypesOutput.md)
* [HUGO Gene Nomenclature Committee Gene Group](http://terminology.hl7.org/6.5.0/CodeSystem-HGNCGeneGroup.html): [GenomicFinding](StructureDefinition-finding.md), [HGNCVS](ValueSet-hgnc-vs.md) and [MolecularBiomarker](StructureDefinition-molecular-biomarker.md)


* NCBI's Disclaimer and Copyright notice must be evident to users of your service.Information that is created by or for the US government on this site is within the public domain. Public domain information on the National Library of Medicine (NLM) Web pages may be freely distributed and copied. However, it is requested that in any subsequent use of this work, NLM be given appropriate acknowledgment.NOTE: This site contains resources which incorporate material contributed or licensed by individuals, companies, or organizations that may be protected by U.S. and foreign copyright laws. These include, but are not limited to PubMed Central (PMC) (see PMC Copyright Notice at [https://www.ncbi.nlm.nih.gov/pmc/about/copyright/)](https://www.ncbi.nlm.nih.gov/pmc/about/copyright/)), Bookshelf (see Bookshelf Copyright Notice at [https://www.ncbi.nlm.nih.gov/books/about/copyright/)](https://www.ncbi.nlm.nih.gov/books/about/copyright/)), OMIM (see OMIM Copyright Status at [https://omim.org/help/copyright)](https://omim.org/help/copyright)), and PubChem. All persons reproducing, redistributing, or making commercial use of this information are expected to adhere to the terms and conditions asserted by the copyright holder. Transmission or reproduction of protected items beyond that allowed by fair use ([https://www.copyright.gov/fls/fl102.html)(PDF)](https://www.copyright.gov/fls/fl102.html)(PDF)) as defined in the copyright laws requires the written permission of the copyright owners.General copyright, as stated on NCBI's GTR site ([https://www.ncbi.nlm.nih.gov/gtr/)](https://www.ncbi.nlm.nih.gov/gtr/)), is as included in the Copyright Statement.

* [Genetic Testing Registry](http://terminology.hl7.org/6.5.0/CodeSystem-GTR.html): [Bundle/bundle-CG-IG-HLA-FullBundle-01](Bundle-bundle-CG-IG-HLA-FullBundle-01.md)


* See [[https://clinicaltrials.gov/about-site/terms-conditions](https://clinicaltrials.gov/about-site/terms-conditions)](https://clinicaltrials.gov/about-site/terms-conditions) for the Terms and Conditions that apply for use of ClinicalTrials.gov data.

* [ClinicalTrials.gov](http://terminology.hl7.org/6.5.0/CodeSystem-ClinicalTrialsGov.html): [Observation/ROS1-Fusion-therapuTrial](Observation-ROS1-Fusion-therapuTrial.md), [Observation/Therapeutic-Implication-Clinical-Trial-2](Observation-Therapeutic-Implication-Clinical-Trial-2.md) and [Observation/Therapeutic-Implication-Clinical-Trial-Somatic](Observation-Therapeutic-Implication-Clinical-Trial-Somatic.md)


* The HPO vocabularies, annotation files, tools and documentation are freely available. 
* The HPO is copyrighted to protect the integrity of the vocabularies, which means that changes to the HPO vocabularies need to be done by HPO developers. However, anyone can download the HPO and use the ontologies or other HPO files under three conditions:
 
*  That the Human Phenotype Ontology Consortium is acknowledged and [cited](https://hpo.jax.org/app/citation) properly. 
 
* That any HPO Consortium file(s) displayed publicly include the date(s) and/or version number(s) of the relevant HPO file(s).
 
*  That neither the content of the HPO file(s) nor the logical relationships embedded within the HPO file(s) be altered in any way. (Content additions and modifications have to be suggested using our [issue tracker](https://github.com/obophenotype/human-phenotype-ontology/issues) .) 
 
* Users of the HPO should add the following statement to their online presence. This service/product uses the Human Phenotype Ontology (version information). Find out more at [http://www.human-phenotype-ontology.org](http://www.human-phenotype-ontology.org). We request that the HPO logo be included as well.
 

* [Human Phenotype Ontology](http://terminology.hl7.org/6.5.0/CodeSystem-HPO.html): [ConditionInheritanceModeVS](ValueSet-condition-inheritance-mode-vs.md), [DiagnosticImplication](StructureDefinition-diagnostic-implication.md) and [Observation/obs-idh-ex](Observation-obs-idh-ex.md)


* The PharmVar database content is licensed under a [Creative Commons Attribution-ShareAlike 4.0 International license](https://creativecommons.org/licenses/by-sa/4.0/) that allows for the sharing and adaptation of our information with proper attribution.See [[https://www.pharmvar.org/terms-and-conditions](https://www.pharmvar.org/terms-and-conditions)](https://www.pharmvar.org/terms-and-conditions) for Terms and Conditions.

* [Pharmacogene Variation](http://terminology.hl7.org/6.5.0/CodeSystem-PharmVar.html): [Bundle/bundle-cgexample](Bundle-bundle-cgexample.md), [Bundle/bundle-cgexample-withGrouping](Bundle-bundle-cgexample-withGrouping.md)...Show 4 more,[Bundle/bundle-pgxexample](Bundle-bundle-pgxexample.md),[Observation/HaplotypeExamplePharmVar01](Observation-HaplotypeExamplePharmVar01.md),[Observation/HaplotypeExamplePharmVar02](Observation-HaplotypeExamplePharmVar02.md)and[Parameters/FindSubjectHaplotypesOutput](Parameters-FindSubjectHaplotypesOutput.md)


* The Sequence Ontology: A tool for the unification of genome annotations. Eilbeck K., Lewis S.E., Mungall C.J., Yandell M., Stein L., Durbin R., Ashburner M. [Genome Biology (2005) 6:R44](http://genomebiology.com/2005/6/5/R44) Please also include the version of SO used.Sequence Ontology data and data products are licensed under the [Creative Commons Attribution 4.0 Unported License](https://creativecommons.org/licenses/by/4.0/legalcode) .

* [Sequence Ontology](http://terminology.hl7.org/6.5.0/CodeSystem-SO.html): [Bundle/bundle-oncology-report-example](Bundle-bundle-oncology-report-example.md), [DNAChangeTypeVS](ValueSet-dna-change-type-vs.md)...Show 46 more,[FunctionalEffectVS](ValueSet-functional-effect-vs.md),[GenomicStudy/lungMass](GenomicStudy-lungMass.md),[GenomicStudy/somaticStudy](GenomicStudy-somaticStudy.md),[MolecularConsequence](StructureDefinition-molecular-consequence.md),[MolecularConsequenceVS](ValueSet-molecular-consequence-vs.md),[Observation/ATR-insertion-molc](Observation-ATR-insertion-molc.md),[Observation/ATR-insertion-var](Observation-ATR-insertion-var.md),[Observation/EGFR-L858R-molc](Observation-EGFR-L858R-molc.md),[Observation/EGFR-L858R-var](Observation-EGFR-L858R-var.md),[Observation/ExampleGermlineCNV](Observation-ExampleGermlineCNV.md),[Observation/ExampleGermlineDEL](Observation-ExampleGermlineDEL.md),[Observation/ExampleGermlineINV](Observation-ExampleGermlineINV.md),[Observation/ExampleSomaticCNV](Observation-ExampleSomaticCNV.md),[Observation/ExampleSomaticDEL](Observation-ExampleSomaticDEL.md),[Observation/ExampleSomaticINV](Observation-ExampleSomaticINV.md),[Observation/MSH2-del-molc](Observation-MSH2-del-molc.md),[Observation/MSH2-del-var](Observation-MSH2-del-var.md),[Observation/NOTCH1-uncertain-molc](Observation-NOTCH1-uncertain-molc.md),[Observation/NTHL1-snv-molc](Observation-NTHL1-snv-molc.md),[Observation/NTHL1-snv-var](Observation-NTHL1-snv-var.md),[Observation/Pgx-var-1011](Observation-Pgx-var-1011.md),[Observation/Pgx-var-1012](Observation-Pgx-var-1012.md),[Observation/Pgx-var-1013](Observation-Pgx-var-1013.md),[Observation/Pgx-var-1014](Observation-Pgx-var-1014.md),[Observation/Pgx-var-1015](Observation-Pgx-var-1015.md),[Observation/Pgx-var-1016](Observation-Pgx-var-1016.md),[Observation/Pgx-var-1017](Observation-Pgx-var-1017.md),[Observation/Pgx-var-1018](Observation-Pgx-var-1018.md),[Observation/Pgx-var-1019](Observation-Pgx-var-1019.md),[Observation/Pgx-var-1020](Observation-Pgx-var-1020.md),[Observation/Pgx-var-1021](Observation-Pgx-var-1021.md),[Observation/ROS1-Fusion](Observation-ROS1-Fusion.md),[Observation/STAG2-insertion-molc](Observation-STAG2-insertion-molc.md),[Observation/STAG2-insertion-var](Observation-STAG2-insertion-var.md),[Observation/ZFHX3-uncertain-molc](Observation-ZFHX3-uncertain-molc.md),[Observation/molec-conseq1](Observation-molec-conseq1.md),[Observation/molec-conseq2](Observation-molec-conseq2.md),[Observation/molec-conseq3](Observation-molec-conseq3.md),[Observation/molec-conseq4](Observation-molec-conseq4.md),[Observation/obs1-interact-smn1-smn2](Observation-obs1-interact-smn1-smn2.md),[Observation/obs2-interact-smn1-smn2](Observation-obs2-interact-smn1-smn2.md),[Parameters/FindStudyMetadataOutput](Parameters-FindStudyMetadataOutput.md),[Parameters/FindSubjectMolecConseqOutput](Parameters-FindSubjectMolecConseqOutput.md),[Parameters/FindSubjectStructuralIntersectingVariantsOutput](Parameters-FindSubjectStructuralIntersectingVariantsOutput.md),[Parameters/FindSubjectStructuralSubsumingVariantsOutput](Parameters-FindSubjectStructuralSubsumingVariantsOutput.md)and[Variant](StructureDefinition-variant.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ucum.html): [Bundle/bundle-cgexample](Bundle-bundle-cgexample.md), [Bundle/bundle-cgexample-withGrouping](Bundle-bundle-cgexample-withGrouping.md)...Show 20 more,[Bundle/bundle-oncology-diagnostic](Bundle-bundle-oncology-diagnostic.md),[Bundle/bundle-oncology-report-example](Bundle-bundle-oncology-report-example.md),[Bundle/bundle-oncologyexamples-r4](Bundle-bundle-oncologyexamples-r4.md),[Bundle/bundle-oncologyexamples-r4-withGrouping](Bundle-bundle-oncologyexamples-r4-withGrouping.md),[Observation/ATR-insertion-var](Observation-ATR-insertion-var.md),[Observation/EGFR-L858R-var](Observation-EGFR-L858R-var.md),[Observation/ExampleGermlineCNV](Observation-ExampleGermlineCNV.md),[Observation/ExampleSomaticCNV](Observation-ExampleSomaticCNV.md),[Observation/ExampleSomaticDEL](Observation-ExampleSomaticDEL.md),[Observation/NOTCH1-uncertain-var](Observation-NOTCH1-uncertain-var.md),[Observation/SNVexample](Observation-SNVexample.md),[Observation/STAG2-insertion-var](Observation-STAG2-insertion-var.md),[Observation/ZFHX3-uncertain-var](Observation-ZFHX3-uncertain-var.md),[Observation/obs1-interact-smn1-smn2](Observation-obs1-interact-smn1-smn2.md),[Observation/obs2-interact-smn1-smn2](Observation-obs2-interact-smn1-smn2.md),[Observation/variant-with-molec-consequences](Observation-variant-with-molec-consequences.md),[Parameters/FindSubjectMolecConseqOutput](Parameters-FindSubjectMolecConseqOutput.md),[Parameters/FindSubjectStructuralSubsumingVariantsOutput](Parameters-FindSubjectStructuralSubsumingVariantsOutput.md),[Parameters/FindSubjectVariantsOutput](Parameters-FindSubjectVariantsOutput.md)and[RiskAssessment/GenRiskDiabetesT2](RiskAssessment-GenRiskDiabetesT2.md)


* The content on the Website including but not limited to the content of ISCN 2020 in whole or in parts, the title, the logo, graphic designs or adverts are the intellectual property of S. Karger AG (Basel) or published with permission from the legal copyright owner. All rights are reserved. Unless otherwise noted, no part of the content on the Website may be translated into other languages, reproduced or utilized in any form or by any means, electronic or mechanical, including photocopying, recording, microcopying, or by any information storage and retrieval system, without permission in writing from Karger.For further information or permission requests please see the explanations under Rights and Permissions ([https://www.karger.com/Services/RightsPermissions)](https://www.karger.com/Services/RightsPermissions)).

* [International System for Human Cytogenomic Nomenclature (ISCN)](http://terminology.hl7.org/6.5.0/CodeSystem-ISCN.html): [Observation/ISCN-CMLExample](Observation-ISCN-CMLExample.md) and [Observation/ISCN-NormalExample](Observation-ISCN-NormalExample.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [Bundle/bundle-CG-IG-HLA-FullBundle-01](Bundle-bundle-CG-IG-HLA-FullBundle-01.md), [Bundle/bundle-CYP2C19](Bundle-bundle-CYP2C19.md)...Show 156 more,[Bundle/bundle-cgexample](Bundle-bundle-cgexample.md),[Bundle/bundle-cgexample-withGrouping](Bundle-bundle-cgexample-withGrouping.md),[Bundle/bundle-complexVariant-nonHGVS](Bundle-bundle-complexVariant-nonHGVS.md),[Bundle/bundle-compound-heterozygote](Bundle-bundle-compound-heterozygote.md),[Bundle/bundle-oncology-diagnostic](Bundle-bundle-oncology-diagnostic.md),[Bundle/bundle-oncology-report-example](Bundle-bundle-oncology-report-example.md),[Bundle/bundle-oncologyexamples-r4](Bundle-bundle-oncologyexamples-r4.md),[Bundle/bundle-oncologyexamples-r4-withGrouping](Bundle-bundle-oncologyexamples-r4-withGrouping.md),[Bundle/bundle-pgxexample](Bundle-bundle-pgxexample.md),[Bundle/bundle-sequence-phase-relation-CYP2C19](Bundle-bundle-sequence-phase-relation-CYP2C19.md),[DiagnosticImplication](StructureDefinition-diagnostic-implication.md),[DiagnosticReport/GenomicReportExample01](DiagnosticReport-GenomicReportExample01.md),[DiagnosticReport/PGxGenomicReportEMERGE](DiagnosticReport-PGxGenomicReportEMERGE.md),[DiagnosticReport/PGxGenomicReportEMERGE-withGrouping](DiagnosticReport-PGxGenomicReportEMERGE-withGrouping.md),[DiagnosticReport/diagnosticreport-hla-glstring-r4](DiagnosticReport-diagnosticreport-hla-glstring-r4.md),[DiagnosticReport/somaticReport](DiagnosticReport-somaticReport.md),[GeneticTherapeuticImplicationsVS](ValueSet-genetic-therapeutic-implications-vs.md),[GenomicAnnotation](StructureDefinition-genomic-annotation.md),[GenomicFinding](StructureDefinition-finding.md),[GenomicImplication](StructureDefinition-implication.md),[GenomicReport](StructureDefinition-genomic-report.md),[GenomicStudy/PGXGenomicStudy](GenomicStudy-PGXGenomicStudy.md),[GenomicStudy/genomicstudy-trio2](GenomicStudy-genomicstudy-trio2.md),[GenomicStudy/lungMass](GenomicStudy-lungMass.md),[GenomicStudy/somaticStudy](GenomicStudy-somaticStudy.md),[Genotype](StructureDefinition-genotype.md),[Haplotype](StructureDefinition-haplotype.md),[MolecularBiomarker](StructureDefinition-molecular-biomarker.md),[MolecularBiomarkerCodeVS](ValueSet-molecular-biomarker-code-vs.md),[MolecularConsequence](StructureDefinition-molecular-consequence.md),[Observation/ATR-insertion-molc](Observation-ATR-insertion-molc.md),[Observation/ATR-insertion-significance](Observation-ATR-insertion-significance.md),[Observation/ATR-insertion-var](Observation-ATR-insertion-var.md),[Observation/AnnotationExample](Observation-AnnotationExample.md),[Observation/EGFR-L858R-molc](Observation-EGFR-L858R-molc.md),[Observation/EGFR-L858R-significance](Observation-EGFR-L858R-significance.md),[Observation/EGFR-L858R-therapuDrug1](Observation-EGFR-L858R-therapuDrug1.md),[Observation/EGFR-L858R-therapuDrug2](Observation-EGFR-L858R-therapuDrug2.md),[Observation/EGFR-L858R-var](Observation-EGFR-L858R-var.md),[Observation/ExampleGermlineCNV](Observation-ExampleGermlineCNV.md),[Observation/ExampleGermlineDEL](Observation-ExampleGermlineDEL.md),[Observation/ExampleGermlineINV](Observation-ExampleGermlineINV.md),[Observation/ExampleSomaticCNV](Observation-ExampleSomaticCNV.md),[Observation/ExampleSomaticDEL](Observation-ExampleSomaticDEL.md),[Observation/ExampleSomaticINV](Observation-ExampleSomaticINV.md),[Observation/Genotype-Clinical-Trial-Example-using-haplotypes](Observation-Genotype-Clinical-Trial-Example-using-haplotypes.md),[Observation/GenotypeExample1](Observation-GenotypeExample1.md),[Observation/GenotypeExamplePharmVar](Observation-GenotypeExamplePharmVar.md),[Observation/HER2byImmuneStainExample](Observation-HER2byImmuneStainExample.md),[Observation/HER2byImmunoassayExample](Observation-HER2byImmunoassayExample.md),[Observation/HLA-A-haplotype1](Observation-HLA-A-haplotype1.md),[Observation/HLA-A-haplotype2](Observation-HLA-A-haplotype2.md),[Observation/HLA-B-haplotype1](Observation-HLA-B-haplotype1.md),[Observation/HLA-B-haplotype2](Observation-HLA-B-haplotype2.md),[Observation/HLA-C-haplotype1](Observation-HLA-C-haplotype1.md),[Observation/HLA-C-haplotype2](Observation-HLA-C-haplotype2.md),[Observation/HaplotypeExamplePharmVar01](Observation-HaplotypeExamplePharmVar01.md),[Observation/HaplotypeExamplePharmVar02](Observation-HaplotypeExamplePharmVar02.md),[Observation/HaplotypeSet-Clinical-Trial-Example-1of2](Observation-HaplotypeSet-Clinical-Trial-Example-1of2.md),[Observation/HaplotypeSet-Clinical-Trial-Example-2of2](Observation-HaplotypeSet-Clinical-Trial-Example-2of2.md),[Observation/ISCN-CMLExample](Observation-ISCN-CMLExample.md),[Observation/ISCN-CMLImplication](Observation-ISCN-CMLImplication.md),[Observation/ISCN-NormalExample](Observation-ISCN-NormalExample.md),[Observation/MSH2-del-disease](Observation-MSH2-del-disease.md),[Observation/MSH2-del-molc](Observation-MSH2-del-molc.md),[Observation/MSH2-del-var](Observation-MSH2-del-var.md),[Observation/MSIExample](Observation-MSIExample.md),[Observation/MicrosatelliteInstabilityExample01](Observation-MicrosatelliteInstabilityExample01.md),[Observation/MultipleRepeatExpansions](Observation-MultipleRepeatExpansions.md),[Observation/NOTCH1-significance](Observation-NOTCH1-significance.md),[Observation/NOTCH1-uncertain-molc](Observation-NOTCH1-uncertain-molc.md),[Observation/NOTCH1-uncertain-var](Observation-NOTCH1-uncertain-var.md),[Observation/NTHL1-snv-disease](Observation-NTHL1-snv-disease.md),[Observation/NTHL1-snv-molc](Observation-NTHL1-snv-molc.md),[Observation/NTHL1-snv-var](Observation-NTHL1-snv-var.md),[Observation/PDL1Example](Observation-PDL1Example.md),[Observation/Pgx-geno-1001](Observation-Pgx-geno-1001.md),[Observation/Pgx-geno-1002](Observation-Pgx-geno-1002.md),[Observation/Pgx-geno-1003](Observation-Pgx-geno-1003.md),[Observation/Pgx-var-1011](Observation-Pgx-var-1011.md),[Observation/Pgx-var-1012](Observation-Pgx-var-1012.md),[Observation/Pgx-var-1013](Observation-Pgx-var-1013.md),[Observation/Pgx-var-1014](Observation-Pgx-var-1014.md),[Observation/Pgx-var-1015](Observation-Pgx-var-1015.md),[Observation/Pgx-var-1016](Observation-Pgx-var-1016.md),[Observation/Pgx-var-1017](Observation-Pgx-var-1017.md),[Observation/Pgx-var-1018](Observation-Pgx-var-1018.md),[Observation/Pgx-var-1019](Observation-Pgx-var-1019.md),[Observation/Pgx-var-1020](Observation-Pgx-var-1020.md),[Observation/Pgx-var-1021](Observation-Pgx-var-1021.md),[Observation/PolyGenicDiagnosticImpExample](Observation-PolyGenicDiagnosticImpExample.md),[Observation/ROS1-Fusion-disease](Observation-ROS1-Fusion-disease.md),[Observation/ROS1-Fusion-therapuDrug](Observation-ROS1-Fusion-therapuDrug.md),[Observation/ROS1-Fusion-therapuTrial](Observation-ROS1-Fusion-therapuTrial.md),[Observation/ROS1-Fusion-var](Observation-ROS1-Fusion-var.md),[Observation/RepeatExpansion](Observation-RepeatExpansion.md),[Observation/SNVexample](Observation-SNVexample.md),[Observation/STAG2-insertion-molc](Observation-STAG2-insertion-molc.md),[Observation/STAG2-insertion-significance](Observation-STAG2-insertion-significance.md),[Observation/STAG2-insertion-var](Observation-STAG2-insertion-var.md),[Observation/SequencePhaseRelationExample1](Observation-SequencePhaseRelationExample1.md),[Observation/TMB-therapuDrug](Observation-TMB-therapuDrug.md),[Observation/TMBExample](Observation-TMBExample.md),[Observation/Therapeutic-Implication-Clinical-Trial-Somatic](Observation-Therapeutic-Implication-Clinical-Trial-Somatic.md),[Observation/TherapeuticImplicationExample1](Observation-TherapeuticImplicationExample1.md),[Observation/TumorMutationBurdenExample01](Observation-TumorMutationBurdenExample01.md),[Observation/TxImp01](Observation-TxImp01.md),[Observation/TxImp02](Observation-TxImp02.md),[Observation/TxImp03](Observation-TxImp03.md),[Observation/TxImp04](Observation-TxImp04.md),[Observation/TxImp05](Observation-TxImp05.md),[Observation/TxImp06](Observation-TxImp06.md),[Observation/Variant-Somatic-Clinical-Trial](Observation-Variant-Somatic-Clinical-Trial.md),[Observation/VariantExample](Observation-VariantExample.md),[Observation/VariantExample1](Observation-VariantExample1.md),[Observation/VariantExample2](Observation-VariantExample2.md),[Observation/ZFHX3-significance](Observation-ZFHX3-significance.md),[Observation/ZFHX3-uncertain-molc](Observation-ZFHX3-uncertain-molc.md),[Observation/ZFHX3-uncertain-var](Observation-ZFHX3-uncertain-var.md),[Observation/diagnosticImplication-interact-smn1-smn2](Observation-diagnosticImplication-interact-smn1-smn2.md),[Observation/genotype-hla-a-glstring-r4](Observation-genotype-hla-a-glstring-r4.md),[Observation/haplotype-hla-a-1-r4](Observation-haplotype-hla-a-1-r4.md),[Observation/molec-conseq1](Observation-molec-conseq1.md),[Observation/molec-conseq2](Observation-molec-conseq2.md),[Observation/molec-conseq3](Observation-molec-conseq3.md),[Observation/molec-conseq4](Observation-molec-conseq4.md),[Observation/obs-idh-ex](Observation-obs-idh-ex.md),[Observation/obs1-interact-smn1-smn2](Observation-obs1-interact-smn1-smn2.md),[Observation/obs2-interact-smn1-smn2](Observation-obs2-interact-smn1-smn2.md),[Observation/pop-allele-freq](Observation-pop-allele-freq.md),[Observation/therapuDrug1-interact-smn1-smn2](Observation-therapuDrug1-interact-smn1-smn2.md),[Observation/therapuDrug2-interact-smn1-smn2](Observation-therapuDrug2-interact-smn1-smn2.md),[Observation/therapuDrug3-interact-smn1-smn2](Observation-therapuDrug3-interact-smn1-smn2.md),[Observation/variant-with-molec-consequences](Observation-variant-with-molec-consequences.md),[Parameters/FindStudyMetadataOutput](Parameters-FindStudyMetadataOutput.md),[Parameters/FindSubjectDxImplicationsOutput](Parameters-FindSubjectDxImplicationsOutput.md),[Parameters/FindSubjectHaplotypesOutput](Parameters-FindSubjectHaplotypesOutput.md),[Parameters/FindSubjectMolecConseqOutput](Parameters-FindSubjectMolecConseqOutput.md),[Parameters/FindSubjectSpecificHaplotypesOutput](Parameters-FindSubjectSpecificHaplotypesOutput.md),[Parameters/FindSubjectSpecificVariantsOutput](Parameters-FindSubjectSpecificVariantsOutput.md),[Parameters/FindSubjectStructuralIntersectingVariantsOutput](Parameters-FindSubjectStructuralIntersectingVariantsOutput.md),[Parameters/FindSubjectStructuralSubsumingVariantsOutput](Parameters-FindSubjectStructuralSubsumingVariantsOutput.md),[Parameters/FindSubjectTxImplicationsOutput](Parameters-FindSubjectTxImplicationsOutput.md),[Parameters/FindSubjectVariantsOutput](Parameters-FindSubjectVariantsOutput.md),[SequencePhaseRelationship](StructureDefinition-sequence-phase-relationship.md),[ServiceRequest/ExampleServiceRequest](ServiceRequest-ExampleServiceRequest.md),[ServiceRequest/GenomicServiceRequestExample01](ServiceRequest-GenomicServiceRequestExample01.md),[ServiceRequest/servicerequest-hla-a-r4](ServiceRequest-servicerequest-hla-a-r4.md),[Task/MedicationRecommendationExample1](Task-MedicationRecommendationExample1.md),[Task/PGxRecEx01](Task-PGxRecEx01.md),[Task/PGxRecEx02](Task-PGxRecEx02.md),[Task/PGxRecEx03](Task-PGxRecEx03.md),[Task/PGxRecEx04](Task-PGxRecEx04.md),[Task/PGxRecEx05](Task-PGxRecEx05.md),[TherapeuticImplication](StructureDefinition-therapeutic-implication.md)and[Variant](StructureDefinition-variant.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* SNOMED Clinical Terms&reg; (SNOMED CT&reg;): [Bundle/bundle-CG-IG-HLA-FullBundle-01](Bundle-bundle-CG-IG-HLA-FullBundle-01.md), [Bundle/bundle-cgexample](Bundle-bundle-cgexample.md)...Show 34 more,[Bundle/bundle-cgexample-withGrouping](Bundle-bundle-cgexample-withGrouping.md),[Device/triodenovo-software](Device-triodenovo-software.md),[GeneticTherapeuticImplicationsVS](ValueSet-genetic-therapeutic-implications-vs.md),[GenomicStudy/lungMass](GenomicStudy-lungMass.md),[GenomicStudy/somaticStudy](GenomicStudy-somaticStudy.md),[Observation/AnnotationExample](Observation-AnnotationExample.md),[Observation/EGFR-L858R-therapuDrug1](Observation-EGFR-L858R-therapuDrug1.md),[Observation/EGFR-L858R-therapuDrug2](Observation-EGFR-L858R-therapuDrug2.md),[Observation/ISCN-CMLImplication](Observation-ISCN-CMLImplication.md),[Observation/MSH2-del-disease](Observation-MSH2-del-disease.md),[Observation/NTHL1-snv-disease](Observation-NTHL1-snv-disease.md),[Observation/PolyGenicDiagnosticImpExample](Observation-PolyGenicDiagnosticImpExample.md),[Observation/ROS1-Fusion-therapuDrug](Observation-ROS1-Fusion-therapuDrug.md),[Observation/ROS1-Fusion-therapuTrial](Observation-ROS1-Fusion-therapuTrial.md),[Observation/TMB-therapuDrug](Observation-TMB-therapuDrug.md),[Observation/Therapeutic-Implication-Clinical-Trial-2](Observation-Therapeutic-Implication-Clinical-Trial-2.md),[Observation/Therapeutic-Implication-Clinical-Trial-Somatic](Observation-Therapeutic-Implication-Clinical-Trial-Somatic.md),[Observation/Variant-Somatic-Clinical-Trial](Observation-Variant-Somatic-Clinical-Trial.md),[Observation/diagnosticImplication-interact-smn1-smn2](Observation-diagnosticImplication-interact-smn1-smn2.md),[Observation/therapuDrug1-interact-smn1-smn2](Observation-therapuDrug1-interact-smn1-smn2.md),[Observation/therapuDrug2-interact-smn1-smn2](Observation-therapuDrug2-interact-smn1-smn2.md),[Observation/therapuDrug3-interact-smn1-smn2](Observation-therapuDrug3-interact-smn1-smn2.md),[Parameters/FindSubjectDxImplicationsOutput](Parameters-FindSubjectDxImplicationsOutput.md),[Procedure/SequencingProcedure](Procedure-SequencingProcedure.md),[RiskAssessment/GenRiskDiabetesT2](RiskAssessment-GenRiskDiabetesT2.md),[ServiceRequest/genomicServiceRequest](ServiceRequest-genomicServiceRequest.md),[ServiceRequest/servicerequest-hla-a-r4](ServiceRequest-servicerequest-hla-a-r4.md),[ServiceRequest/somaticServiceRequest](ServiceRequest-somaticServiceRequest.md),[Specimen/GenomicSpecimenExample02](Specimen-GenomicSpecimenExample02.md),[Specimen/genomicSpecimen](Specimen-genomicSpecimen.md),[Specimen/normalSpecimen](Specimen-normalSpecimen.md),[Specimen/specimen-hla-r4](Specimen-specimen-hla-r4.md),[Specimen/tumorSpecimen](Specimen-tumorSpecimen.md)and[TherapeuticImplication](StructureDefinition-therapeutic-implication.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Observation Category Codes](http://terminology.hl7.org/6.5.0/CodeSystem-observation-category.html): [Bundle/bundle-CG-IG-HLA-FullBundle-01](Bundle-bundle-CG-IG-HLA-FullBundle-01.md), [Bundle/bundle-CYP2C19](Bundle-bundle-CYP2C19.md)...Show 140 more,[Bundle/bundle-cgexample](Bundle-bundle-cgexample.md),[Bundle/bundle-cgexample-withGrouping](Bundle-bundle-cgexample-withGrouping.md),[Bundle/bundle-complexVariant-nonHGVS](Bundle-bundle-complexVariant-nonHGVS.md),[Bundle/bundle-compound-heterozygote](Bundle-bundle-compound-heterozygote.md),[Bundle/bundle-oncology-diagnostic](Bundle-bundle-oncology-diagnostic.md),[Bundle/bundle-oncology-report-example](Bundle-bundle-oncology-report-example.md),[Bundle/bundle-oncologyexamples-r4](Bundle-bundle-oncologyexamples-r4.md),[Bundle/bundle-oncologyexamples-r4-withGrouping](Bundle-bundle-oncologyexamples-r4-withGrouping.md),[Bundle/bundle-pgxexample](Bundle-bundle-pgxexample.md),[Bundle/bundle-sequence-phase-relation-CYP2C19](Bundle-bundle-sequence-phase-relation-CYP2C19.md),[DiagnosticImplication](StructureDefinition-diagnostic-implication.md),[GenomicAnnotation](StructureDefinition-genomic-annotation.md),[GenomicBase](StructureDefinition-genomic-base.md),[GenomicFinding](StructureDefinition-finding.md),[GenomicImplication](StructureDefinition-implication.md),[Genotype](StructureDefinition-genotype.md),[Haplotype](StructureDefinition-haplotype.md),[MolecularBiomarker](StructureDefinition-molecular-biomarker.md),[MolecularConsequence](StructureDefinition-molecular-consequence.md),[Observation/ATR-insertion-molc](Observation-ATR-insertion-molc.md),[Observation/ATR-insertion-significance](Observation-ATR-insertion-significance.md),[Observation/ATR-insertion-var](Observation-ATR-insertion-var.md),[Observation/AnnotationExample](Observation-AnnotationExample.md),[Observation/EGFR-L858R-molc](Observation-EGFR-L858R-molc.md),[Observation/EGFR-L858R-significance](Observation-EGFR-L858R-significance.md),[Observation/EGFR-L858R-therapuDrug1](Observation-EGFR-L858R-therapuDrug1.md),[Observation/EGFR-L858R-therapuDrug2](Observation-EGFR-L858R-therapuDrug2.md),[Observation/EGFR-L858R-var](Observation-EGFR-L858R-var.md),[Observation/ExampleGermlineCNV](Observation-ExampleGermlineCNV.md),[Observation/ExampleGermlineDEL](Observation-ExampleGermlineDEL.md),[Observation/ExampleGermlineINV](Observation-ExampleGermlineINV.md),[Observation/ExampleSomaticCNV](Observation-ExampleSomaticCNV.md),[Observation/ExampleSomaticDEL](Observation-ExampleSomaticDEL.md),[Observation/ExampleSomaticINV](Observation-ExampleSomaticINV.md),[Observation/Genotype-Clinical-Trial-Example-using-haplotypes](Observation-Genotype-Clinical-Trial-Example-using-haplotypes.md),[Observation/GenotypeExample1](Observation-GenotypeExample1.md),[Observation/GenotypeExamplePharmVar](Observation-GenotypeExamplePharmVar.md),[Observation/GrouperEx01](Observation-GrouperEx01.md),[Observation/GrouperEx02](Observation-GrouperEx02.md),[Observation/GrouperEx03](Observation-GrouperEx03.md),[Observation/HER2byImmuneStainExample](Observation-HER2byImmuneStainExample.md),[Observation/HER2byImmunoassayExample](Observation-HER2byImmunoassayExample.md),[Observation/HLA-A-haplotype1](Observation-HLA-A-haplotype1.md),[Observation/HLA-A-haplotype2](Observation-HLA-A-haplotype2.md),[Observation/HLA-B-haplotype1](Observation-HLA-B-haplotype1.md),[Observation/HLA-B-haplotype2](Observation-HLA-B-haplotype2.md),[Observation/HLA-C-haplotype1](Observation-HLA-C-haplotype1.md),[Observation/HLA-C-haplotype2](Observation-HLA-C-haplotype2.md),[Observation/HaplotypeExamplePharmVar01](Observation-HaplotypeExamplePharmVar01.md),[Observation/HaplotypeExamplePharmVar02](Observation-HaplotypeExamplePharmVar02.md),[Observation/HaplotypeSet-Clinical-Trial-Example-1of2](Observation-HaplotypeSet-Clinical-Trial-Example-1of2.md),[Observation/HaplotypeSet-Clinical-Trial-Example-2of2](Observation-HaplotypeSet-Clinical-Trial-Example-2of2.md),[Observation/ISCN-CMLExample](Observation-ISCN-CMLExample.md),[Observation/ISCN-CMLImplication](Observation-ISCN-CMLImplication.md),[Observation/ISCN-NormalExample](Observation-ISCN-NormalExample.md),[Observation/MSH2-del-disease](Observation-MSH2-del-disease.md),[Observation/MSH2-del-molc](Observation-MSH2-del-molc.md),[Observation/MSH2-del-var](Observation-MSH2-del-var.md),[Observation/MSIExample](Observation-MSIExample.md),[Observation/MicrosatelliteInstabilityExample01](Observation-MicrosatelliteInstabilityExample01.md),[Observation/MultipleRepeatExpansions](Observation-MultipleRepeatExpansions.md),[Observation/NOTCH1-significance](Observation-NOTCH1-significance.md),[Observation/NOTCH1-uncertain-molc](Observation-NOTCH1-uncertain-molc.md),[Observation/NOTCH1-uncertain-var](Observation-NOTCH1-uncertain-var.md),[Observation/NTHL1-snv-disease](Observation-NTHL1-snv-disease.md),[Observation/NTHL1-snv-molc](Observation-NTHL1-snv-molc.md),[Observation/NTHL1-snv-var](Observation-NTHL1-snv-var.md),[Observation/PDL1Example](Observation-PDL1Example.md),[Observation/Pgx-geno-1001](Observation-Pgx-geno-1001.md),[Observation/Pgx-geno-1002](Observation-Pgx-geno-1002.md),[Observation/Pgx-geno-1003](Observation-Pgx-geno-1003.md),[Observation/Pgx-var-1011](Observation-Pgx-var-1011.md),[Observation/Pgx-var-1012](Observation-Pgx-var-1012.md),[Observation/Pgx-var-1013](Observation-Pgx-var-1013.md),[Observation/Pgx-var-1014](Observation-Pgx-var-1014.md),[Observation/Pgx-var-1015](Observation-Pgx-var-1015.md),[Observation/Pgx-var-1016](Observation-Pgx-var-1016.md),[Observation/Pgx-var-1017](Observation-Pgx-var-1017.md),[Observation/Pgx-var-1018](Observation-Pgx-var-1018.md),[Observation/Pgx-var-1019](Observation-Pgx-var-1019.md),[Observation/Pgx-var-1020](Observation-Pgx-var-1020.md),[Observation/Pgx-var-1021](Observation-Pgx-var-1021.md),[Observation/PolyGenicDiagnosticImpExample](Observation-PolyGenicDiagnosticImpExample.md),[Observation/ROS1-Fusion](Observation-ROS1-Fusion.md),[Observation/ROS1-Fusion-disease](Observation-ROS1-Fusion-disease.md),[Observation/ROS1-Fusion-therapuDrug](Observation-ROS1-Fusion-therapuDrug.md),[Observation/ROS1-Fusion-therapuTrial](Observation-ROS1-Fusion-therapuTrial.md),[Observation/ROS1-Fusion-var](Observation-ROS1-Fusion-var.md),[Observation/RepeatExpansion](Observation-RepeatExpansion.md),[Observation/SNVexample](Observation-SNVexample.md),[Observation/STAG2-insertion-molc](Observation-STAG2-insertion-molc.md),[Observation/STAG2-insertion-significance](Observation-STAG2-insertion-significance.md),[Observation/STAG2-insertion-var](Observation-STAG2-insertion-var.md),[Observation/SequencePhaseRelationExample1](Observation-SequencePhaseRelationExample1.md),[Observation/TMB-therapuDrug](Observation-TMB-therapuDrug.md),[Observation/TMBExample](Observation-TMBExample.md),[Observation/Therapeutic-Implication-Clinical-Trial-2](Observation-Therapeutic-Implication-Clinical-Trial-2.md),[Observation/Therapeutic-Implication-Clinical-Trial-Somatic](Observation-Therapeutic-Implication-Clinical-Trial-Somatic.md),[Observation/TherapeuticImplicationExample1](Observation-TherapeuticImplicationExample1.md),[Observation/TumorMutationBurdenExample01](Observation-TumorMutationBurdenExample01.md),[Observation/TxImp01](Observation-TxImp01.md),[Observation/TxImp02](Observation-TxImp02.md),[Observation/TxImp03](Observation-TxImp03.md),[Observation/TxImp04](Observation-TxImp04.md),[Observation/TxImp05](Observation-TxImp05.md),[Observation/TxImp06](Observation-TxImp06.md),[Observation/Variant-Somatic-Clinical-Trial](Observation-Variant-Somatic-Clinical-Trial.md),[Observation/VariantExample](Observation-VariantExample.md),[Observation/VariantExample1](Observation-VariantExample1.md),[Observation/VariantExample2](Observation-VariantExample2.md),[Observation/ZFHX3-significance](Observation-ZFHX3-significance.md),[Observation/ZFHX3-uncertain-molc](Observation-ZFHX3-uncertain-molc.md),[Observation/ZFHX3-uncertain-var](Observation-ZFHX3-uncertain-var.md),[Observation/diagnosticImplication-interact-smn1-smn2](Observation-diagnosticImplication-interact-smn1-smn2.md),[Observation/genotype-hla-a-glstring-r4](Observation-genotype-hla-a-glstring-r4.md),[Observation/haplotype-hla-a-1-r4](Observation-haplotype-hla-a-1-r4.md),[Observation/molec-conseq1](Observation-molec-conseq1.md),[Observation/molec-conseq2](Observation-molec-conseq2.md),[Observation/molec-conseq3](Observation-molec-conseq3.md),[Observation/molec-conseq4](Observation-molec-conseq4.md),[Observation/obs-idh-ex](Observation-obs-idh-ex.md),[Observation/obs1-interact-smn1-smn2](Observation-obs1-interact-smn1-smn2.md),[Observation/obs2-interact-smn1-smn2](Observation-obs2-interact-smn1-smn2.md),[Observation/pop-allele-freq](Observation-pop-allele-freq.md),[Observation/therapuDrug1-interact-smn1-smn2](Observation-therapuDrug1-interact-smn1-smn2.md),[Observation/therapuDrug2-interact-smn1-smn2](Observation-therapuDrug2-interact-smn1-smn2.md),[Observation/therapuDrug3-interact-smn1-smn2](Observation-therapuDrug3-interact-smn1-smn2.md),[Observation/variant-with-molec-consequences](Observation-variant-with-molec-consequences.md),[Parameters/FindSubjectDxImplicationsOutput](Parameters-FindSubjectDxImplicationsOutput.md),[Parameters/FindSubjectHaplotypesOutput](Parameters-FindSubjectHaplotypesOutput.md),[Parameters/FindSubjectMolecConseqOutput](Parameters-FindSubjectMolecConseqOutput.md),[Parameters/FindSubjectSpecificHaplotypesOutput](Parameters-FindSubjectSpecificHaplotypesOutput.md),[Parameters/FindSubjectSpecificVariantsOutput](Parameters-FindSubjectSpecificVariantsOutput.md),[Parameters/FindSubjectStructuralIntersectingVariantsOutput](Parameters-FindSubjectStructuralIntersectingVariantsOutput.md),[Parameters/FindSubjectStructuralSubsumingVariantsOutput](Parameters-FindSubjectStructuralSubsumingVariantsOutput.md),[Parameters/FindSubjectTxImplicationsOutput](Parameters-FindSubjectTxImplicationsOutput.md),[Parameters/FindSubjectVariantsOutput](Parameters-FindSubjectVariantsOutput.md),[SequencePhaseRelationship](StructureDefinition-sequence-phase-relationship.md),[TherapeuticImplication](StructureDefinition-therapeutic-implication.md)and[Variant](StructureDefinition-variant.md)
* [Risk Probability](http://terminology.hl7.org/6.5.0/CodeSystem-risk-probability.html): [RiskAssessment/GenRiskDiabetesT2](RiskAssessment-GenRiskDiabetesT2.md)
* [diagnosticServiceSectionId](http://terminology.hl7.org/6.5.0/CodeSystem-v2-0074.html): [Bundle/bundle-CG-IG-HLA-FullBundle-01](Bundle-bundle-CG-IG-HLA-FullBundle-01.md), [Bundle/bundle-CYP2C19](Bundle-bundle-CYP2C19.md)...Show 144 more,[Bundle/bundle-cgexample](Bundle-bundle-cgexample.md),[Bundle/bundle-cgexample-withGrouping](Bundle-bundle-cgexample-withGrouping.md),[Bundle/bundle-complexVariant-nonHGVS](Bundle-bundle-complexVariant-nonHGVS.md),[Bundle/bundle-compound-heterozygote](Bundle-bundle-compound-heterozygote.md),[Bundle/bundle-oncology-diagnostic](Bundle-bundle-oncology-diagnostic.md),[Bundle/bundle-oncology-report-example](Bundle-bundle-oncology-report-example.md),[Bundle/bundle-oncologyexamples-r4](Bundle-bundle-oncologyexamples-r4.md),[Bundle/bundle-oncologyexamples-r4-withGrouping](Bundle-bundle-oncologyexamples-r4-withGrouping.md),[Bundle/bundle-pgxexample](Bundle-bundle-pgxexample.md),[Bundle/bundle-sequence-phase-relation-CYP2C19](Bundle-bundle-sequence-phase-relation-CYP2C19.md),[DiagnosticImplication](StructureDefinition-diagnostic-implication.md),[DiagnosticReport/GenomicReportExample01](DiagnosticReport-GenomicReportExample01.md),[DiagnosticReport/PGxGenomicReportEMERGE](DiagnosticReport-PGxGenomicReportEMERGE.md),[DiagnosticReport/PGxGenomicReportEMERGE-withGrouping](DiagnosticReport-PGxGenomicReportEMERGE-withGrouping.md),[DiagnosticReport/diagnosticreport-hla-glstring-r4](DiagnosticReport-diagnosticreport-hla-glstring-r4.md),[DiagnosticReport/somaticReport](DiagnosticReport-somaticReport.md),[GenomicAnnotation](StructureDefinition-genomic-annotation.md),[GenomicBase](StructureDefinition-genomic-base.md),[GenomicFinding](StructureDefinition-finding.md),[GenomicImplication](StructureDefinition-implication.md),[GenomicReport](StructureDefinition-genomic-report.md),[Genotype](StructureDefinition-genotype.md),[Haplotype](StructureDefinition-haplotype.md),[MolecularBiomarker](StructureDefinition-molecular-biomarker.md),[MolecularConsequence](StructureDefinition-molecular-consequence.md),[Observation/ATR-insertion-molc](Observation-ATR-insertion-molc.md),[Observation/ATR-insertion-significance](Observation-ATR-insertion-significance.md),[Observation/ATR-insertion-var](Observation-ATR-insertion-var.md),[Observation/AnnotationExample](Observation-AnnotationExample.md),[Observation/EGFR-L858R-molc](Observation-EGFR-L858R-molc.md),[Observation/EGFR-L858R-significance](Observation-EGFR-L858R-significance.md),[Observation/EGFR-L858R-therapuDrug1](Observation-EGFR-L858R-therapuDrug1.md),[Observation/EGFR-L858R-therapuDrug2](Observation-EGFR-L858R-therapuDrug2.md),[Observation/EGFR-L858R-var](Observation-EGFR-L858R-var.md),[Observation/ExampleGermlineCNV](Observation-ExampleGermlineCNV.md),[Observation/ExampleGermlineDEL](Observation-ExampleGermlineDEL.md),[Observation/ExampleGermlineINV](Observation-ExampleGermlineINV.md),[Observation/ExampleSomaticCNV](Observation-ExampleSomaticCNV.md),[Observation/ExampleSomaticDEL](Observation-ExampleSomaticDEL.md),[Observation/ExampleSomaticINV](Observation-ExampleSomaticINV.md),[Observation/Genotype-Clinical-Trial-Example-using-haplotypes](Observation-Genotype-Clinical-Trial-Example-using-haplotypes.md),[Observation/GenotypeExample1](Observation-GenotypeExample1.md),[Observation/GenotypeExamplePharmVar](Observation-GenotypeExamplePharmVar.md),[Observation/GrouperEx01](Observation-GrouperEx01.md),[Observation/GrouperEx02](Observation-GrouperEx02.md),[Observation/GrouperEx03](Observation-GrouperEx03.md),[Observation/HLA-A-haplotype1](Observation-HLA-A-haplotype1.md),[Observation/HLA-A-haplotype2](Observation-HLA-A-haplotype2.md),[Observation/HLA-B-haplotype1](Observation-HLA-B-haplotype1.md),[Observation/HLA-B-haplotype2](Observation-HLA-B-haplotype2.md),[Observation/HLA-C-haplotype1](Observation-HLA-C-haplotype1.md),[Observation/HLA-C-haplotype2](Observation-HLA-C-haplotype2.md),[Observation/HaplotypeExamplePharmVar01](Observation-HaplotypeExamplePharmVar01.md),[Observation/HaplotypeExamplePharmVar02](Observation-HaplotypeExamplePharmVar02.md),[Observation/HaplotypeSet-Clinical-Trial-Example-1of2](Observation-HaplotypeSet-Clinical-Trial-Example-1of2.md),[Observation/HaplotypeSet-Clinical-Trial-Example-2of2](Observation-HaplotypeSet-Clinical-Trial-Example-2of2.md),[Observation/ISCN-CMLExample](Observation-ISCN-CMLExample.md),[Observation/ISCN-CMLImplication](Observation-ISCN-CMLImplication.md),[Observation/ISCN-NormalExample](Observation-ISCN-NormalExample.md),[Observation/MSH2-del-disease](Observation-MSH2-del-disease.md),[Observation/MSH2-del-molc](Observation-MSH2-del-molc.md),[Observation/MSH2-del-var](Observation-MSH2-del-var.md),[Observation/MSIExample](Observation-MSIExample.md),[Observation/MicrosatelliteInstabilityExample01](Observation-MicrosatelliteInstabilityExample01.md),[Observation/MultipleRepeatExpansions](Observation-MultipleRepeatExpansions.md),[Observation/NOTCH1-significance](Observation-NOTCH1-significance.md),[Observation/NOTCH1-uncertain-molc](Observation-NOTCH1-uncertain-molc.md),[Observation/NOTCH1-uncertain-var](Observation-NOTCH1-uncertain-var.md),[Observation/NTHL1-snv-disease](Observation-NTHL1-snv-disease.md),[Observation/NTHL1-snv-molc](Observation-NTHL1-snv-molc.md),[Observation/NTHL1-snv-var](Observation-NTHL1-snv-var.md),[Observation/PDL1Example](Observation-PDL1Example.md),[Observation/Pgx-geno-1001](Observation-Pgx-geno-1001.md),[Observation/Pgx-geno-1002](Observation-Pgx-geno-1002.md),[Observation/Pgx-geno-1003](Observation-Pgx-geno-1003.md),[Observation/Pgx-var-1011](Observation-Pgx-var-1011.md),[Observation/Pgx-var-1012](Observation-Pgx-var-1012.md),[Observation/Pgx-var-1013](Observation-Pgx-var-1013.md),[Observation/Pgx-var-1014](Observation-Pgx-var-1014.md),[Observation/Pgx-var-1015](Observation-Pgx-var-1015.md),[Observation/Pgx-var-1016](Observation-Pgx-var-1016.md),[Observation/Pgx-var-1017](Observation-Pgx-var-1017.md),[Observation/Pgx-var-1018](Observation-Pgx-var-1018.md),[Observation/Pgx-var-1019](Observation-Pgx-var-1019.md),[Observation/Pgx-var-1020](Observation-Pgx-var-1020.md),[Observation/Pgx-var-1021](Observation-Pgx-var-1021.md),[Observation/PolyGenicDiagnosticImpExample](Observation-PolyGenicDiagnosticImpExample.md),[Observation/ROS1-Fusion](Observation-ROS1-Fusion.md),[Observation/ROS1-Fusion-disease](Observation-ROS1-Fusion-disease.md),[Observation/ROS1-Fusion-therapuDrug](Observation-ROS1-Fusion-therapuDrug.md),[Observation/ROS1-Fusion-therapuTrial](Observation-ROS1-Fusion-therapuTrial.md),[Observation/ROS1-Fusion-var](Observation-ROS1-Fusion-var.md),[Observation/RepeatExpansion](Observation-RepeatExpansion.md),[Observation/SNVexample](Observation-SNVexample.md),[Observation/STAG2-insertion-molc](Observation-STAG2-insertion-molc.md),[Observation/STAG2-insertion-significance](Observation-STAG2-insertion-significance.md),[Observation/STAG2-insertion-var](Observation-STAG2-insertion-var.md),[Observation/SequencePhaseRelationExample1](Observation-SequencePhaseRelationExample1.md),[Observation/TMB-therapuDrug](Observation-TMB-therapuDrug.md),[Observation/TMBExample](Observation-TMBExample.md),[Observation/Therapeutic-Implication-Clinical-Trial-2](Observation-Therapeutic-Implication-Clinical-Trial-2.md),[Observation/Therapeutic-Implication-Clinical-Trial-Somatic](Observation-Therapeutic-Implication-Clinical-Trial-Somatic.md),[Observation/TherapeuticImplicationExample1](Observation-TherapeuticImplicationExample1.md),[Observation/TumorMutationBurdenExample01](Observation-TumorMutationBurdenExample01.md),[Observation/TxImp01](Observation-TxImp01.md),[Observation/TxImp02](Observation-TxImp02.md),[Observation/TxImp03](Observation-TxImp03.md),[Observation/TxImp04](Observation-TxImp04.md),[Observation/TxImp05](Observation-TxImp05.md),[Observation/TxImp06](Observation-TxImp06.md),[Observation/Variant-Somatic-Clinical-Trial](Observation-Variant-Somatic-Clinical-Trial.md),[Observation/VariantExample](Observation-VariantExample.md),[Observation/VariantExample1](Observation-VariantExample1.md),[Observation/VariantExample2](Observation-VariantExample2.md),[Observation/ZFHX3-significance](Observation-ZFHX3-significance.md),[Observation/ZFHX3-uncertain-molc](Observation-ZFHX3-uncertain-molc.md),[Observation/ZFHX3-uncertain-var](Observation-ZFHX3-uncertain-var.md),[Observation/diagnosticImplication-interact-smn1-smn2](Observation-diagnosticImplication-interact-smn1-smn2.md),[Observation/genotype-hla-a-glstring-r4](Observation-genotype-hla-a-glstring-r4.md),[Observation/haplotype-hla-a-1-r4](Observation-haplotype-hla-a-1-r4.md),[Observation/molec-conseq1](Observation-molec-conseq1.md),[Observation/molec-conseq2](Observation-molec-conseq2.md),[Observation/molec-conseq3](Observation-molec-conseq3.md),[Observation/molec-conseq4](Observation-molec-conseq4.md),[Observation/obs-idh-ex](Observation-obs-idh-ex.md),[Observation/obs1-interact-smn1-smn2](Observation-obs1-interact-smn1-smn2.md),[Observation/obs2-interact-smn1-smn2](Observation-obs2-interact-smn1-smn2.md),[Observation/pop-allele-freq](Observation-pop-allele-freq.md),[Observation/therapuDrug1-interact-smn1-smn2](Observation-therapuDrug1-interact-smn1-smn2.md),[Observation/therapuDrug2-interact-smn1-smn2](Observation-therapuDrug2-interact-smn1-smn2.md),[Observation/therapuDrug3-interact-smn1-smn2](Observation-therapuDrug3-interact-smn1-smn2.md),[Observation/variant-with-molec-consequences](Observation-variant-with-molec-consequences.md),[Parameters/FindSubjectDxImplicationsOutput](Parameters-FindSubjectDxImplicationsOutput.md),[Parameters/FindSubjectHaplotypesOutput](Parameters-FindSubjectHaplotypesOutput.md),[Parameters/FindSubjectMolecConseqOutput](Parameters-FindSubjectMolecConseqOutput.md),[Parameters/FindSubjectSpecificHaplotypesOutput](Parameters-FindSubjectSpecificHaplotypesOutput.md),[Parameters/FindSubjectSpecificVariantsOutput](Parameters-FindSubjectSpecificVariantsOutput.md),[Parameters/FindSubjectStructuralIntersectingVariantsOutput](Parameters-FindSubjectStructuralIntersectingVariantsOutput.md),[Parameters/FindSubjectStructuralSubsumingVariantsOutput](Parameters-FindSubjectStructuralSubsumingVariantsOutput.md),[Parameters/FindSubjectTxImplicationsOutput](Parameters-FindSubjectTxImplicationsOutput.md),[Parameters/FindSubjectVariantsOutput](Parameters-FindSubjectVariantsOutput.md),[SequencePhaseRelationship](StructureDefinition-sequence-phase-relationship.md),[TherapeuticImplication](StructureDefinition-therapeutic-implication.md)and[Variant](StructureDefinition-variant.md)
* [identifierType](http://terminology.hl7.org/6.5.0/CodeSystem-v2-0203.html): [Bundle/bundle-CG-IG-HLA-FullBundle-01](Bundle-bundle-CG-IG-HLA-FullBundle-01.md), [DiagnosticReport/somaticReport](DiagnosticReport-somaticReport.md)...Show 10 more,[Patient/CGPatientExample01](Patient-CGPatientExample01.md),[Patient/HG00403](Patient-HG00403.md),[Patient/denovoChild](Patient-denovoChild.md),[Patient/denovoFather](Patient-denovoFather.md),[Patient/denovoMother](Patient-denovoMother.md),[Patient/genomicPatient](Patient-genomicPatient.md),[Patient/somaticPatient](Patient-somaticPatient.md),[Practitioner/practitioner02](Practitioner-practitioner02.md),[ServiceRequest/genomicServiceRequest](ServiceRequest-genomicServiceRequest.md)and[ServiceRequest/somaticServiceRequest](ServiceRequest-somaticServiceRequest.md)
* [specimenType](http://terminology.hl7.org/6.5.0/CodeSystem-v2-0487.html): [Bundle/bundle-oncology-report-example](Bundle-bundle-oncology-report-example.md) and [Specimen/GenomicSpecimenExample01](Specimen-GenomicSpecimenExample01.md)
* [Confidentiality](http://terminology.hl7.org/6.5.0/CodeSystem-v3-Confidentiality.html): [DocumentReference/CNVAnalysis-called](DocumentReference-CNVAnalysis-called.md), [DocumentReference/FullGenome-GRCh38](DocumentReference-FullGenome-GRCh38.md)...Show 11 more,[DocumentReference/SimpleVariantAnalysis-called](DocumentReference-SimpleVariantAnalysis-called.md),[DocumentReference/UncallableRegions](DocumentReference-UncallableRegions.md),[DocumentReference/WES-FullSequencedRegion-GRCh38](DocumentReference-WES-FullSequencedRegion-GRCh38.md),[DocumentReference/WES-UncallableRegions-GRCh38](DocumentReference-WES-UncallableRegions-GRCh38.md),[DocumentReference/genomicFileFatherBAM](DocumentReference-genomicFileFatherBAM.md),[DocumentReference/genomicFileMotherBAM](DocumentReference-genomicFileMotherBAM.md),[DocumentReference/genomicFileProbandBAM](DocumentReference-genomicFileProbandBAM.md),[DocumentReference/genomicFileProbandVCF](DocumentReference-genomicFileProbandVCF.md),[DocumentReference/genomicVCFfile-cnv](DocumentReference-genomicVCFfile-cnv.md),[DocumentReference/genomicVCFfile-simple](DocumentReference-genomicVCFfile-simple.md)and[DocumentReference/somaticVCFfile](DocumentReference-somaticVCFfile.md)
* [ParticipationType](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ParticipationType.html): [GenomicStudy/lungMass](GenomicStudy-lungMass.md)


* Using RxNorm codes of type SAB=RXNORM as this specification describes does not require a UMLS license. Access to the full set of RxNorm definitions, and/or additional use of other RxNorm structures and information requires a UMLS license. The use of RxNorm in this specification is pursuant to HL7's status as a licensee of the NLM UMLS. HL7's license does not convey the right to use RxNorm to any users of this specification; implementers must acquire a license to use RxNorm in their own right.

* [RxNorm](http://terminology.hl7.org/6.5.0/CodeSystem-v3-rxNorm.html): [Bundle/bundle-cgexample](Bundle-bundle-cgexample.md), [Bundle/bundle-cgexample-withGrouping](Bundle-bundle-cgexample-withGrouping.md)...Show 11 more,[Bundle/bundle-oncologyexamples-r4-withGrouping](Bundle-bundle-oncologyexamples-r4-withGrouping.md),[Bundle/bundle-pgxexample](Bundle-bundle-pgxexample.md),[MedicationStatement/MedicationStatementWarfarin](MedicationStatement-MedicationStatementWarfarin.md),[Observation/TherapeuticImplicationExample1](Observation-TherapeuticImplicationExample1.md),[Observation/TxImp01](Observation-TxImp01.md),[Observation/TxImp02](Observation-TxImp02.md),[Observation/TxImp03](Observation-TxImp03.md),[Observation/TxImp04](Observation-TxImp04.md),[Observation/TxImp05](Observation-TxImp05.md),[Observation/TxImp06](Observation-TxImp06.md)and[Parameters/FindSubjectTxImplicationsOutput](Parameters-FindSubjectTxImplicationsOutput.md)


### Appendices

| | |
| :--- | :--- |
| [Appendix A: Relation to v2 reporting](v2.md) | Links to v2 Genetic Variation Model Implementation Guide and v2 Cytogenomic Model Implementation Guide |
| [Appendix B: Clinical Genomics Apps](cgapps.md) | Introduction of the Clinical Genomics Applications (Genomics Advisor, etc) apply for this implementation guide |
| [Appendix C: Domain Analysis Model](domain.md) | A domain analysis model for various use cases in clinical genomics |
| [Appendix D: Query Guidance](usecases.md) | Query guidance based on use-cases from the Domain Analysis Document |
| [Appendix E: External Coding Systems](codings.md) | Reference for publicly available external coding systems |
| [Appendix F: Conversion from FHIR Core STU3](conversion.md) | Notes on since deprecated extensions defined in FHIR Core STU3 |
| [Appendix G: Molecular Sequence](molecularsequence.md) | Notes on the FHIR Resource for representing a Molecular Sequence |
| [Appendix H: Grouping observations](groupingguidance.md) | Guidance on the types of grouping that might be encountered |
| [Appendix I: Glossary](glossary.md) | Table of concepts referenced on Observation profiles |

### Acknowledgments

The Genomics Reporting Implementation Guide is a product of the [HL7 Clinical Genomics Work Group](https://confluence.hl7.org/display/CGW/WorkGroup+Home). The work group welcomes and actively encourages feedback on this guide. Whether you have questions regarding its usage, recommendations for improvement, or identify any issues requiring correction, please don't hesitate to reach out to us! You may propose a change (see link at the bottom of the page), reach out on [Zulip](https://chat.fhir.org/#narrow/stream/179197-genomics) to chat, or email the Work Group at [clingenomics@lists.hl7.org](mailto:clingenomics@lists.hl7.org).

The authors of this guide wish to recognize the following participants who contributed their time and expertise to the continued development of this guide:

| | | |
| :--- | :--- | :--- |
| Srikar Chamala | Childrens Hospital of Los Angeles | CG Co-Chair |
| Willie Chang | Epic | Contributor |
| Bob Dolin | Elimu Informatics | Contributor |
| Bob Freimuth | Mayo Clinic | CG Co-Chair, IM Sub-Group Lead |
| Bret Heale | Intermountain | Contributor |
| Arthur Hermann | Kaiser Permanente | Contributor |
| Jamie Jones | Boston Children's Hospital | CG Co-Chair, Modeling Sub-Group Lead |
| Aly Khalifa | Mayo Clinic | Contributor |
| Anand Kulanthaivel | Clinical Architecture | Contributor |
| Lloyd McKenzie | Dogwood Consulting | Contributor |
| Mullai Murugan | Baylor College of Medicine | Contributor |
| JD Nolen | Children's Mercy Hospital | Contributor |
| Kevin Power | Children's Mercy Hospital | Contributor |
| Joel Schneider | NMDP/CIBMTR | Contributor |
| May Terry | MITRE Corporation | CG Co-Chair |
| Michael Watkins | University of Chicago | CG Co-Chair |
| Patrick Werner | MOLIT Institut | CG Co-Chair |

