# Appendix I: Glossary - Genomics Reporting Implementation Guide v4.0.0-ballot

* [**Table of Contents**](toc.md)
* **Appendix I: Glossary**

## Appendix I: Glossary

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R5/versions.html#std-process) |

| | |
| :--- | :--- |
| Allele | An allele is a specific version of a contiguous nucleotide sequence, typically located within a gene. Two or more alleles may exist for any given gene or section of genomic DNA. An individual inherits two alleles for each sequenced gene or region, one from each parent. If the two alleles are the same, the individual is homozygous for that gene. If the alleles are different, the individual is heterozygous. In other organisms, the ploidy (number of alleles per locus) differs from two. |
| Allelic Read Depth | Also known as the allele depth, this annotation gives the unfiltered count of reads that support a given allele for an individual sample. |
| Allelic State | The level of occurrence of a single DNA Marker within a set of chromosomes. Heterozygous indicates the DNA Marker is only present in one of the two genes contained in homologous chromosomes. Homozygous indicates the DNA Marker is present in both genes contained in homologous chromosomes. Hemizygous indicates the DNA Marker exists in the only single copy of a gene in a non-homologous chromosome (The male X and Y chromosome are non-homologous). Hemiplasmic indicates that the DNA Marker is present in some but not all of the copies of mitochondrial DNA. Homoplasmic indicates that the DNA Maker is present in all of the copies of mitochondrial DNA. |
| Alternate Allele | The contiguous segment of DNA in the test sample that differs from the expected (reference) allele at the same location and thus defines a variant. |
| Amino Acid Change | The protein sequence change that occurs as a direct consequence of a nucleotide (genetic) sequence change, expressed in HGVS notation: Variants described on the amino acid level are mostly reported in relation to a specific gene based on a so-called 'proteomic reference sequence'. When this notation is used, the description of the variant is in pHGVS format and starts with 'p.' |
| Amino Acid Change Type | Codified type for the protein (amino acid) sequence change, as implied by the pHGVS section of the variant's HGVS string. |
| Chromosome Identifier | An indicator, enumerated in humans by numbers 1-22, X, and Y, representing a structural unit composed of a nucleic acid molecule which controls its own replication through the interaction of specific proteins at one or more origins of replication. |
| Clinical Significance | An assessment of the magnitude of a genetic variant's clinical effects as per estimates supplied by researchers and/or guidelines. |
| Coding DNA Change | A description of the cDNA facet of a variant, expressed in HGVS notation: Variants described on the DNA level are mostly reported in relation to a specific gene based on a so-called 'coding DNA reference sequence'. When a coding DNA reference sequence is used, the description of the variant starts with 'c.' |
| Copy number | Refers to the genetic trait involving the number of copies of a particular gene or structural DNA region present in the genome of an individual. Note that a copy number of 1 implies a deletion. The copy number can usually be inferred from the HGVS or ISCN fields. Copy number is not Allelic state. Copies have to do with cis related sequences (those on the same chromosome), allelic state is related to the number of molecules containing the sequence. |
| Cytogenetic Location | The cytogenetic location describes the position of a particular band on an arm of a stained chromosome. It can also be written as a range of bands, if less is known about the exact location. The combination of numbers and letters provide a gene's 'address' on a chromosome. |
| DNA Change Type | Codified type for associated DNA Marker. DNA Markers use the HGVS notation which implies the DNA Marker Type, but the concurrent use of this code will allow a standard and explicit type for technical and display convenience. Enumeration: Children of Sequence Ontology, SO:0002072 |
| Functional Effect | A predicted or observed effect of a variant on its gene's (or protein product thereof) ability to function. Value set enumeration is to be the children of Sequence Ontology SO:0001536. |
| Gene | A unit of heredity encoded in DNA with defined start and stop coordinates. All genes code for transcript RNAs, and some encoded RNAs will be translated into proteins. (IDT) |
| Gene Symbol | An abbreviation for a gene name. In biomedicine, the HUGO Gene Nomenclature Committee (HGNC) Approved Symbol is most frequently used, but there exist other nomenclatures. |
| Genetic Testing | Genetic testing is a type of medical test that identifies changes in chromosomes, genes, or proteins. The results of a genetic test can confirm or rule out a suspected genetic condition or help determine a person's chance of developing or passing on a genetic disorder. More than 1,000 genetic tests are currently in use, and more are being developed |
| Genetic Testing Methods | The specific laboratory test method used to perform the analysis reporting the variant. Genetic testing methods are diverse and span from testing for known germline mutations in the context of single-gene disorders, to full sequencing of genes in tumor tissues looking for somatic variations in cancer cells. |
| Genomic Coordinate | Consists of chromosome name and integers that together define a location (position or series of nucleotides) within a reference genome. The information specified typically includes chromosome name, start position, end position, and chromosome strand. |
| Genomic coordinate system | These are different ways of identifying nucleotides or amino acids within a sequence. In the 1-based system, the first unit of the polymer (e.g., the first nucleotide) is counted as number 1. In the 0-based system, the number 0 designates the location before the first nucleotide. Different databases and file types may use different systems. |
| Genomic DNA Change | Variants described on the genomic DNA level can be reported in HGVS notation with respect to the position and changes in the entire organism's genome as compared to a reference genome for the organism. Such genomically-reported DNA changes are prefixed with "g." in HGVS. |
| Genotype | Two alleles inherited for a particular gene. The genotype is expressed when the information encoded is the genes' DNA is used to make protein and RNA molecules. NOTE: In this context, the corresponding alleles for each of the genes listed under gene(s) studied are also shown separated by a slash e.g.,**1/**2 as is the common format. The genotype is almost always reported as a pair of star alleles in pharmacogenomic studies. |
| Haplotype | A haplotype is a set of DNA variants that tend to be inherited together. |
| ISCN Notation | The ISCN (International System for Human Cytogenomic Nomenclature) recommendations cover the description of numerical and structural chromosomal changes detected using microscopic and cytogenetic techniques. |
| Microsatellite Instability | The appearance of abnormally long or short microsatellites in an individual's DNA is referred to as microsatellite instability. Microsatellite instability (MSI) is a condition manifested by damaged DNA due to defects in the normal DNA repair process. Sections of DNA called microsatellites, which consist of a sequence of repeating units of 1-6 base pairs in length, become unstable and can shorten or lengthen. Microsatellites are also known as simple sequence repeats (SSRs). |
| Mode of Inheritance | The transmission pattern of the condition/phenotype in a pedigree. Values enumerated by the Answers to LL3731-8. |
| Molecular Consequence | A calculated classification of the effect of the gene's sequence change on the resulting transcript and/or amino acid (protein) sequence. Enumerated by the children of Sequence Ontology SO:0001537 |
| Phenotype | The observable characteristics in an individual resulting from the expression of genes; the clinical presentation of an individual with a particular genotype. |
| Read Depth | The average number of sequenced bases that align to, or 'cover,' known reference bases. At higher levels of coverage, base calls can be made with a higher degree of confidence. |
| Reference Allele | Reference values ("normal") examined within the DNA Reference Sequence. This is used in a genotyping test to define the reference and variable nucleotide strings. |
| Reference genome | A reference genome (reference assembly) is a fully sequenced and assembled genome that acts as a scaffold against which new sequence reads are aligned and compared. Typically, reads generated from a sequencing run are aligned to a reference genome as a first step in data analysis. Examples of reference genomes include hg19 and hg38. |
| Reference Sequence | The expected sequence of a genetic region as per the proper reference genome. |
| Reference Transcript | The expected sequence of a cDNA (DNA coding) transcript as per the proper reference transcript. Reference transcripts are coded by NCBI's RefSeq ('NM_…'), Ensembl ('ENST…'), and LRG ('LRG…' plus 't1' to indicate transcript). See Appendix D for more information on code systems. |
| Sample Allelic Frequency | A physical quality which inheres to the allele by virtue of the number instances of the allele within a sample. This is the relative frequency of the allele at a given locus in that sample. |
| Start-End, Exact | The exact integer-based genomic coordinates of the start and end of a variant region. |
| Start-End, Inner | The genomic coordinates of the narrowest genomic range in which the variant might reside. Used when the exact boundaries of the variant are not clear. |
| Start-End, Outer | The genomic coordinates of the widest genomic range in which the variant might reside. Used when the exact boundaries of the variant are not clear. |
| Tumor Mutation Burden | Tumor mutation/mutational burden (TMB), also known as mutation load, is a biomarker for various cancer types to identify patients who will benefit from immunotherapy, such as immune checkpoint blockade (ICB) therapy. [PMID: 30395155]. TMB may or may not take into account synonymous (proteomically silent) mutations. There are multiple ways of reporting this biomarker, both quantitative (e.g., mutations/Mb) and ordinal interpretation (e.g., high/low) may be given. |
| Un-callable Region | Also known as a no-call result, means that the lab was not able to run the test, or that the test did not produce a result for a specific genetic region |
| Variant | An alteration in the most common DNA nucleotide sequence. The term variant can be used to describe an alteration that may be benign, pathogenic, or of unknown significance. The term variant is increasingly being used in place of the term mutation. Additionally, the line between variant and allele is blurring. However, variant implies a difference from a reference sequence. As such, variants are typically reported with a reference either indicated or implied. |
| Variant Drug Metabolism Effect | A variant's effect on a drug's metabolism. The metabolism (or pharmacokinetics) of a drug determines the concentration of the drug, prodrug, and/or break-down products over time. Therefore, variants that affect a drug's metabolism will alter the concentration of drug/prodrug/metabolites over time. Example: Due to this variant, the patient is a 'slow metabolizer' (i.e., the drug's metabolism is slowed). |
| Variant Inheritance | The source or inheritance of a variation found in an individual patient. Understanding the source can help determine the significance of a particular variant and its association with different diseases or syndromes. Germline variants are either inherited or de novo. Inherited variants can be maternal, paternal, or a combination of maternal and paternal. De novo variants are those that are not present in parental germline cells, but that arise in the egg or sperm prior to conception or just after the zygote is formed. Somatic variants arise at points later in time. The enumeration for this element is Sequence Ontology, all terms that are children of SO:0001762. |
| Variant Risk (Medication) | How a variant affects the risk of the possessing individual being administered certain medications. Example: Due to this variant, the drug is at increased risk of causing an adverse reaction. |
| Variant Therapeutic Efficacy Effect | A variant's effect on the efficacy of a specified treatment. The efficacy (or pharmacodynamics) of a drug determines how effective a drug is at a given concentration. Therefore, variants that affect a drug's efficacy will alter the potency of a drug. Example: Due to this variant, the drug will be less efficacious against this target. |

